/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import turtlemessenger.TMController;

public class TMBcasAddrSettingDialog
extends JDialog {
    byte[] broadcastAddress;
    TMController controller;
    private JTextField addressDigit0TextField;
    private JTextField addressDigit1TextField;
    private JTextField addressDigit2TextField;
    private JTextField addressDigit3TextField;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton okButton;

    public TMBcasAddrSettingDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.controller = (TMController)parent;
        this.broadcastAddress = new byte[4];
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.addressDigit0TextField = new JTextField();
        this.addressDigit1TextField = new JTextField();
        this.addressDigit2TextField = new JTextField();
        this.addressDigit3TextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        ResourceBundle bundle = ResourceBundle.getBundle("turtlemessenger/TMBundle");
        this.jLabel1.setText(bundle.getString("BROADCASTADDRESS"));
        this.jLabel1.setToolTipText("<html>\n\u8907\u6570\u306e\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u6301\u3064\u30de\u30b7\u30f3\u306e\u5834\u5408\u3001\u5b66\u751f\u7528\uff30\uff23\u304c\u63a5\u7d9a\u3055\u308c\u3066\u3044\u308b\u30b5\u30d6\u30cd\u30c3\u30c8<br>\n\u306e\u30d6\u30ed\u30fc\u30c9\u30ad\u30e3\u30b9\u30c8\u30a2\u30c9\u30ec\u30b9\u3092\u4ee5\u4e0b\u306e\u6b04\u306b\u6307\u5b9a\u3057\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002<br>\n\u4f8b\u3048\u3070\u3001192 . 168 . 0 . 255 \u306e\u3088\u3046\u306a\u5f62\u5f0f\u306b\u306a\u308a\u307e\u3059\u3002<br>\n<br>\n\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u304c\u3072\u3068\u3064\u306e\u5834\u5408\u306f 255 . 255 . 255 . 255 \uff08\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\uff09\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002<br>\n</html>");
        this.addressDigit0TextField.setHorizontalAlignment(4);
        this.addressDigit0TextField.setText("255");
        this.addressDigit1TextField.setHorizontalAlignment(4);
        this.addressDigit1TextField.setText("255");
        this.addressDigit2TextField.setHorizontalAlignment(4);
        this.addressDigit2TextField.setText("255");
        this.addressDigit3TextField.setHorizontalAlignment(4);
        this.addressDigit3TextField.setText("255");
        this.jLabel2.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel2.setText(" . ");
        this.jLabel3.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel3.setText(" . ");
        this.jLabel4.setFont(new Font("Lucida Grande", 0, 18));
        this.jLabel4.setText(" . ");
        this.jLabel5.setText(bundle.getString("TYPICALBCASADDR"));
        this.cancelButton.setText(bundle.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMBcasAddrSettingDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMBcasAddrSettingDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel5, -2, 286, -2).addGap(47, 47, 47)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addGap(42, 42, 42)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.addressDigit0TextField, -2, 55, -2).addGap(2, 2, 2).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressDigit1TextField, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(1, 1, 1).addComponent(this.addressDigit2TextField, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(2, 2, 2).addComponent(this.addressDigit3TextField, -2, 55, -2)).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel1))).addContainerGap(62, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressDigit0TextField, -2, -1, -2).addComponent(this.addressDigit1TextField, -2, -1, -2).addComponent(this.addressDigit2TextField, -2, -1, -2).addComponent(this.addressDigit3TextField, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(18, 18, 18).addComponent(this.jLabel5).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(16, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setBroadcastAddress();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    byte getDigit8(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException nfex) {
            return -1;
        }
        int n = Integer.valueOf(str);
        if (n < 0) {
            n = 255;
        } else if (n > 255) {
            n = 255;
        }
        return (byte)n;
    }

    private void setBroadcastAddress() {
        this.broadcastAddress[0] = this.getDigit8(this.addressDigit0TextField.getText());
        this.broadcastAddress[1] = this.getDigit8(this.addressDigit1TextField.getText());
        this.broadcastAddress[2] = this.getDigit8(this.addressDigit2TextField.getText());
        this.broadcastAddress[3] = this.getDigit8(this.addressDigit3TextField.getText());
        this.controller.changeBroadcastAddress(this.broadcastAddress);
    }

    public void setBroadcastAddressToTextField(byte[] bcas) {
        this.addressDigit0TextField.setText(String.valueOf(bcas[0] & 0xFF));
        this.addressDigit1TextField.setText(String.valueOf(bcas[1] & 0xFF));
        this.addressDigit2TextField.setText(String.valueOf(bcas[2] & 0xFF));
        this.addressDigit3TextField.setText(String.valueOf(bcas[3] & 0xFF));
    }
}

