/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import sun.misc.HexDumpEncoder;
import turtlemessenger.TMAboutDialog;
import turtlemessenger.TMBcasAddrSettingDialog;
import turtlemessenger.TMHelpDialog;
import turtlemessenger.TMHttpServer;
import turtlemessenger.TMMessages;
import turtlemessenger.TMReceiver;
import turtlemessenger.TMVotingSummary;

public class TMController
extends JFrame {
    private static final int MAXCHARS = 140;
    private static final int PORT_BROADCAST = 3100;
    private static final int PORT_SUBMISSION = 3100;
    private static final int RSA_KEY_LENGTH = 512;
    private int serverChannel;
    private static final int BROADCAST_MESSAGE_LENGTH = 1024;
    private static final int BORADCAST_INTERVAL_MS = 5000;
    private boolean receiverIsRunning;
    private TMReceiver receiver;
    private BroadcastThread broadcaster;
    private boolean broadcasterIsTerminating = false;
    private TMHttpServer httpserver = null;
    public HashMap<String, Integer> choices;
    public int[] nchoices;
    private TMMessages messageDialog;
    private TMVotingSummary votingSummaryDialog;
    private KeyPair rsaKeyPair;
    public RSAPrivateKey privateKey;
    public RSAPublicKey publicKey;
    public byte[] broadcastAddress;
    private Preferences prefs;
    List<String> commentList;
    private JMenuItem aboutMenuItem;
    private JMenuItem broadcastMenuItem;
    private JRadioButton channelARadioButton;
    private JRadioButton channelBRadioButton;
    private ButtonGroup channelButtonGroup;
    private JRadioButton channelCRadioButton;
    private JTextArea commentsTextArea;
    private JMenuItem copyLogMenuItem;
    private JMenu copyMenu;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JButton displayMessagesButton;
    private JButton displayVotingResutsButton;
    private JCheckBox enableHttpCheckBox;
    private JMenuItem exitMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSpinner lineNumberSpinner;
    private JTextPane logTextPane;
    private JTextField passcodeTextField;
    private JMenuItem pasteMenuItem;
    private JButton readFileButton;
    private JButton resetVoteButton;
    private JMenuItem saveLogMenuItem;
    private JMenu settingsMenu;
    private JToggleButton startToggleButton;

    public TMController() {
        this.initComponents();
        if (!this.isFaculty()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("STUDENTS ARE NOT ELIGIBLE TO USE THIS SOFTWARE"), "WARNING", 2);
            System.exit(0);
        }
        this.choices = new HashMap(100);
        this.resetChoices();
        this.nchoices = new int[10];
        this.broadcastAddress = new byte[4];
        this.broadcastAddress[0] = -1;
        this.broadcastAddress[1] = -1;
        this.broadcastAddress[2] = -1;
        this.broadcastAddress[3] = -1;
        this.serverChannel = 0;
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.restorePreferences();
        this.receiver = new TMReceiver(this, 3100 + this.serverChannel);
        this.receiverIsRunning = false;
        this.broadcaster = null;
        this.messageDialog = null;
        this.votingSummaryDialog = null;
        this.commentList = new ArrayList<String>();
        this.generateKeyPair();
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tmsgr-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException ex) {
            System.err.println("icon not found");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TMController.this.exitMenuItemActionPerformed(null);
            }
        });
    }

    private void initComponents() {
        this.channelButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.resetVoteButton = new JButton();
        this.startToggleButton = new JToggleButton();
        this.passcodeTextField = new JTextField();
        this.displayMessagesButton = new JButton();
        this.displayVotingResutsButton = new JButton();
        this.jPanel2 = new JPanel();
        this.channelARadioButton = new JRadioButton();
        this.channelBRadioButton = new JRadioButton();
        this.channelCRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.commentsTextArea = new JTextArea();
        this.readFileButton = new JButton();
        this.lineNumberSpinner = new JSpinner();
        this.enableHttpCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.logTextPane = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.saveLogMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.copyMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.copyLogMenuItem = new JMenuItem();
        this.settingsMenu = new JMenu();
        this.broadcastMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("TurtleMessenger");
        this.setMinimumSize(new Dimension(520, 330));
        ResourceBundle bundle = ResourceBundle.getBundle("turtlemessenger/TMBundle");
        this.resetVoteButton.setText(bundle.getString("RESET VOTE COUNT"));
        this.resetVoteButton.setToolTipText("\u6295\u7968\u6570\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059");
        this.resetVoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.resetVoteButtonActionPerformed(evt);
            }
        });
        this.startToggleButton.setText(bundle.getString("START"));
        this.startToggleButton.setToolTipText("<html>\u3053\u306e\u30dc\u30bf\u30f3\u3092\u62bc\u3059\u3068\u3001\u53d7\u8b1b\u8005\u304b\u3089\u306e\u30d5\u30a3\u30fc\u30c9\u30d0\u30c3\u30af\u306e\u53d7\u4ed8\u304c\u59cb\u307e\u308a\u307e\u3059\u3002<br>\n\u3082\u3046\u4e00\u5ea6\u304a\u3059\u3068\u3001\u53d7\u4ed8\u3092\u505c\u6b62\u3057\u307e\u3059\u3002\n</html>");
        this.startToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.startToggleButtonActionPerformed(evt);
            }
        });
        this.passcodeTextField.setText("any");
        this.passcodeTextField.setToolTipText("<html>\n\u3053\u306e\u30d1\u30b9\u30b3\u30fc\u30c9\uff08\u82f1\u6570\u5b57\u5217\uff09\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u5b66\u751f\u306e\u307f\u304b\u3089\u306e\u6295\u7a3f\u3092\u53d7\u4ed8\u307e\u3059<br>\n\u8ab0\u3067\u3082\u6295\u7a3f\u53ef\u80fd\u306b\u3059\u308b\u306b\u306f any \u3092\u8a2d\u5b9a\u3057\u307e\u3059\n</html>");
        this.passcodeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.passcodeTextFieldActionPerformed(evt);
            }
        });
        this.displayMessagesButton.setText(bundle.getString("DISPLAY MESSAGES"));
        this.displayMessagesButton.setToolTipText("\u53d7\u8b1b\u8005\u304b\u3089\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u6295\u7a3f\u306e\u4e00\u89a7\u3092\u5225\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u8868\u793a\u3057\u307e\u3059");
        this.displayMessagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.displayMessagesButtonActionPerformed(evt);
            }
        });
        this.displayVotingResutsButton.setText(bundle.getString("DISPLAY VOTING RESULTS"));
        this.displayVotingResutsButton.setToolTipText("\u6295\u7968\u7d50\u679c\u306e\u4e00\u89a7\u3092\u5225\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u8868\u793a\u3057\u307e\u3059");
        this.displayVotingResutsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.displayVotingResutsButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setToolTipText("<html>\n\u901a\u4fe1\u306b\u4f7f\u3046\u300c\u30c1\u30e3\u30cd\u30eb\u300d\u8a2d\u5b9a\u3067\u3059<br>\n\u901a\u5e38\u306fA\u306e\u307e\u307e\u3067\u304a\u4f7f\u3044\u304f\u3060\u3055\u3044\n</html>");
        this.channelButtonGroup.add(this.channelARadioButton);
        this.channelARadioButton.setSelected(true);
        this.channelARadioButton.setText("A");
        this.channelARadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.channelARadioButtonActionPerformed(evt);
            }
        });
        this.channelButtonGroup.add(this.channelBRadioButton);
        this.channelBRadioButton.setText("B");
        this.channelBRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.channelBRadioButtonActionPerformed(evt);
            }
        });
        this.channelButtonGroup.add(this.channelCRadioButton);
        this.channelCRadioButton.setText("C");
        this.channelCRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.channelCRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.channelARadioButton).add(12, 12, 12).add(this.channelBRadioButton).addPreferredGap(1).add(this.channelCRadioButton).add(0, 8, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(2).add(this.channelARadioButton).add(jPanel2Layout.createParallelGroup(3).add(this.channelCRadioButton).add(this.channelBRadioButton))).addContainerGap(8, Short.MAX_VALUE)));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(bundle.getString("CHANNEL"));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText(bundle.getString("PASSCODE"));
        this.jLabel1.setToolTipText("<html>\n\u3053\u306e\u30d1\u30b9\u30b3\u30fc\u30c9\uff08\u82f1\u6570\u5b57\u5217\uff09\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u5b66\u751f\u306e\u307f\u304b\u3089\u306e\u6295\u7a3f\u3092\u53d7\u4ed8\u307e\u3059<br>\n\u8ab0\u3067\u3082\u6295\u7a3f\u53ef\u80fd\u306b\u3059\u308b\u306b\u306f any \u3092\u8a2d\u5b9a\u3057\u307e\u3059\n</html>");
        this.commentsTextArea.setColumns(20);
        this.commentsTextArea.setLineWrap(true);
        this.commentsTextArea.setRows(5);
        this.commentsTextArea.setToolTipText("<html>\u3053\u306e\u6b04\u306b\u8a18\u5165\u3057\u305f\u6307\u793a\u3084\u8cea\u554f\u306f\u3001\u5b66\u751f\u5074\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u8868\u793a\u3055\u308c\u307e\u3059\u3002<br>\n\u6587\u5b57\u6570\u306f\u534a\u89d2\u3067\u7d04250\u6587\u5b57\uff08\u5168\u89d2\u3067\u7d0480\u6587\u5b57\uff09\u307e\u3067\u3002\n</html>\n");
        this.commentsTextArea.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.readFileButton.setText("...");
        this.readFileButton.setToolTipText("<html>\n\u3053\u306e\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u958b\u304f\u3068<br>\n\u30d5\u30a1\u30a4\u30eb\u306e\u5404\u884c\u304c\u5de6\u6b04\u306b\u5165\u529b\u3055\u308c\u307e\u3059\n</html>");
        this.readFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.readFileButtonActionPerformed(evt);
            }
        });
        this.lineNumberSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lineNumberSpinner.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u306e\u4f55\u884c\u76ee\u3092\u5de6\u6b04\u306b\u5165\u529b\u3059\u308b\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059");
        this.lineNumberSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TMController.this.lineNumberSpinnerStateChanged(evt);
            }
        });
        this.enableHttpCheckBox.setText(bundle.getString("ENABLE_WEB_ACCESS"));
        this.enableHttpCheckBox.setToolTipText("<html>\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u308b\u3068\u3001\u3053\u306e\u30d1\u30bd\u30b3\u30f3\u306b\u5b66\u751f\u304c\u30a6\u30a7\u30d6\u30d6\u30e9\u30a6\u30b6\u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3001<br>\n\u6295\u7968\u7d50\u679c\u306a\u3069\u3092\u53c2\u7167\u3067\u304d\u308b\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002<br>\n\u5177\u4f53\u7684\u306a\u30a2\u30af\u30bb\u30b9\u65b9\u6cd5\u306f\u30de\u30cb\u30e5\u30a2\u30eb\u3092\u53c2\u7167\u306e\u3053\u3068\u3002</html>");
        this.enableHttpCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.enableHttpCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(12, 12, 12).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2, false).add(1, this.commentsTextArea).add(jPanel1Layout.createSequentialGroup().add(this.startToggleButton, -2, 143, -2).addPreferredGap(1).add(this.jLabel2, -2, 80, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jLabel1, -2, 78, -2))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.lineNumberSpinner, -2, 87, -2).add(this.readFileButton).add(this.passcodeTextField, -2, 72, -2))).add(jPanel1Layout.createSequentialGroup().add(this.displayVotingResutsButton, -2, 258, -2).addPreferredGap(0).add(this.resetVoteButton))).addContainerGap(-1, Short.MAX_VALUE)).add(jPanel1Layout.createSequentialGroup().add(this.displayMessagesButton, -2, 258, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.enableHttpCheckBox).add(30, 30, 30)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.startToggleButton, -2, 60, -2).add(this.jLabel2))).add(jPanel1Layout.createSequentialGroup().add(21, 21, 21).add(jPanel1Layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.passcodeTextField, -2, -1, -2))))).addPreferredGap(1).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.readFileButton).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.lineNumberSpinner, -2, 25, -2)).add(this.commentsTextArea, -2, 0, Short.MAX_VALUE)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.displayMessagesButton, -2, 39, -2).add(this.enableHttpCheckBox)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.displayVotingResutsButton, -2, 40, -2).add(this.resetVoteButton, -2, 41, -2)).addContainerGap()));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.logTextPane.setEditable(false);
        this.logTextPane.setToolTipText("<html>\u6295\u7a3f\u306e\u72b6\u6cc1\u306e\u8a18\u9332\u304c\u8868\u793a\u3055\u308c\u307e\u3059<br>\n\u5185\u5bb9\u3092\u4fdd\u5b58\u3059\u308b\u306b\u306f File \u30e1\u30cb\u30e5\u30fc\u304b\u3089 Save log \u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\n</html>");
        this.jScrollPane1.setViewportView(this.logTextPane);
        this.jMenu1.setText(bundle.getString("FILE"));
        this.saveLogMenuItem.setText(bundle.getString("SAVE LOG"));
        this.saveLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.saveLogMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveLogMenuItem);
        this.exitMenuItem.setText(bundle.getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.copyMenu.setText(bundle.getString("EDIT"));
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setText(bundle.getString("CUT"));
        this.cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.copyMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText(bundle.getString("COPY"));
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.copyMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setText(bundle.getString("PASTE"));
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.copyMenu.add(this.pasteMenuItem);
        this.copyLogMenuItem.setText(bundle.getString("COPY LOG"));
        this.copyLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.copyLogMenuItemActionPerformed(evt);
            }
        });
        this.copyMenu.add(this.copyLogMenuItem);
        this.jMenuBar1.add(this.copyMenu);
        this.settingsMenu.setText(bundle.getString("SETTINGS"));
        this.broadcastMenuItem.setText(bundle.getString("BROADCAST"));
        this.broadcastMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.broadcastMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.broadcastMenuItem);
        this.jMenuBar1.add(this.settingsMenu);
        this.helpMenu.setText(bundle.getString("HELP"));
        this.helpMenuItem.setText(bundle.getString("HELP"));
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setText(bundle.getString("ABOUT"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMController.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jScrollPane1).add(this.jPanel1, -1, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jScrollPane1, -1, 173, Short.MAX_VALUE)));
        this.pack();
    }

    private void resetVoteButtonActionPerformed(ActionEvent evt) {
        this.appendLogWithTimestamp("#\tRESET VOTE COUNT\n");
        this.resetChoices();
    }

    private void startToggleButtonActionPerformed(ActionEvent evt) {
        if (this.broadcasterIsTerminating) {
            this.startToggleButton.setSelected(false);
            this.startToggleButton.setForeground(Color.BLACK);
            return;
        }
        if (!this.receiverIsRunning) {
            this.startBroadcast();
            this.receiver.setMyPasscode(this.passcodeTextField.getText().trim());
            this.receiver.setReceiverPort(3100 + this.serverChannel);
            this.receiver.startReceiver();
            this.receiverIsRunning = true;
            this.startToggleButton.setForeground(Color.RED);
            this.startToggleButton.setText(ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("RUNNING"));
            this.appendLogWithTimestamp("#\tSTART LISTENING\n");
        } else {
            this.stopBroadcast();
            this.receiver.terminateReceiver();
            this.receiverIsRunning = false;
            this.startToggleButton.setForeground(Color.BLACK);
            this.startToggleButton.setText(ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("START"));
            this.appendLogWithTimestamp("#\tSTOP LISTENING\n");
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.confirmToSaveDialogue() < 0) {
            return;
        }
        this.stopBroadcast();
        this.receiver.terminateReceiver();
        if (this.httpserver != null) {
            this.httpserver.stopServer();
        }
        this.savePreferences();
        System.exit(0);
    }

    private void copyLogMenuItemActionPerformed(ActionEvent evt) {
        this.logTextPane.copy();
    }

    private void saveLogMenuItemActionPerformed(ActionEvent evt) {
        this.saveLogFile();
    }

    private void displayVotingResutsButtonActionPerformed(ActionEvent evt) {
        if (this.votingSummaryDialog == null) {
            this.votingSummaryDialog = new TMVotingSummary((Frame)this, false);
        }
        this.votingSummaryDialog.setVisible(true);
    }

    private void displayMessagesButtonActionPerformed(ActionEvent evt) {
        if (this.messageDialog == null) {
            this.messageDialog = new TMMessages((Frame)this, false);
        }
        this.messageDialog.updateTable();
        this.messageDialog.setVisible(true);
    }

    private void passcodeTextFieldActionPerformed(ActionEvent evt) {
        this.appendLogWithTimestamp("#\tSET PASSCODE " + this.passcodeTextField.getText().trim() + "\n");
        if (this.receiver != null) {
            this.receiver.setMyPasscode(this.passcodeTextField.getText().trim());
        }
    }

    private void channelARadioButtonActionPerformed(ActionEvent evt) {
        this.appendLogWithTimestamp("#\tSELECT CHANNEL A\n");
        this.serverChannel = 0;
    }

    private void channelBRadioButtonActionPerformed(ActionEvent evt) {
        this.appendLogWithTimestamp("#\tSELECT CHANNEL B\n");
        this.serverChannel = 1;
    }

    private void channelCRadioButtonActionPerformed(ActionEvent evt) {
        this.appendLogWithTimestamp("#\tSELECT CHANNEL C\n");
        this.serverChannel = 2;
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        TMAboutDialog about = new TMAboutDialog((Frame)this, false);
        about.setVisible(true);
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        TMHelpDialog help = new TMHelpDialog((Frame)this, false);
        help.setVisible(true);
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.commentsTextArea.cut();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.commentsTextArea.copy();
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.commentsTextArea.paste();
    }

    private void lineNumberSpinnerStateChanged(ChangeEvent evt) {
        this.setCommentsTextArea();
    }

    private void readFileButtonActionPerformed(ActionEvent evt) {
        this.openCommentFile();
    }

    private void broadcastMenuItemActionPerformed(ActionEvent evt) {
        TMBcasAddrSettingDialog bcas = new TMBcasAddrSettingDialog((Frame)this, false);
        bcas.setBroadcastAddressToTextField(this.broadcastAddress);
        bcas.setVisible(true);
    }

    private void enableHttpCheckBoxActionPerformed(ActionEvent evt) {
        if (this.enableHttpCheckBox.isSelected()) {
            if (this.httpserver == null) {
                this.httpserver = new TMHttpServer(this, 3080);
                this.appendLogWithTimestamp("#\tSTART HTTPD\n");
            }
        } else if (this.httpserver != null) {
            this.httpserver.stopServer();
            this.httpserver = null;
            this.appendLogWithTimestamp("#\tSTOP HTTPD\n");
        }
    }

    private int saveLogFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooser.showSaveDialog(this) == 0) {
            File outputFile = fileChooser.getSelectedFile();
            if (outputFile.exists() && !this.canOverwriteFile(outputFile.getName())) {
                return -1;
            }
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8"));
                writer.write(this.logTextPane.getText());
                writer.close();
            }
            catch (IOException ioe) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private int confirmToSaveDialogue() {
        if (this.receiver.hasMessage()) {
            int rc = JOptionPane.showConfirmDialog(new JPanel(), ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("DO YOU WANT TO SAVE FEEDBACK FROM STUDENTS?"));
            if (rc == 0) {
                return this.saveLogFile();
            }
            if (rc == 2) {
                return -1;
            }
        }
        return 0;
    }

    public void savePreferences() {
        this.prefs.put("PASSCODE", this.passcodeTextField.getText());
        this.prefs.putInt("CHANNEL", this.serverChannel);
        this.prefs.putByteArray("BROADCAST", this.broadcastAddress);
        Rectangle fbound = this.getBounds();
        this.prefs.putInt("WIN_LOC_X", fbound.x);
        this.prefs.putInt("WIN_LOC_Y", fbound.y);
    }

    public void restorePreferences() {
        this.serverChannel = this.prefs.getInt("CHANNEL", 0);
        switch (this.serverChannel) {
            case 0: {
                this.channelARadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.channelBRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.channelCRadioButton.setSelected(true);
                break;
            }
            default: {
                this.serverChannel = 0;
                this.channelARadioButton.setSelected(true);
            }
        }
        this.broadcastAddress = this.prefs.getByteArray("BROADCAST", this.broadcastAddress);
        this.passcodeTextField.setText(this.prefs.get("PASSCODE", "any"));
        int x = this.prefs.getInt("WIN_LOC_X", 10);
        int y = this.prefs.getInt("WIN_LOC_Y", 10);
        this.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChoices() {
        HashMap<String, Integer> hashMap = this.choices;
        synchronized (hashMap) {
            this.choices.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void votedTo(String userid, int choice) {
        HashMap<String, Integer> hashMap = this.choices;
        synchronized (hashMap) {
            if (choice >= 0 && choice <= 9) {
                this.choices.remove(userid);
                this.choices.put(userid, choice);
            }
        }
    }

    public void countVotes() {
        for (int c = 0; c < 10; ++c) {
            this.nchoices[c] = 0;
        }
        Set<String> set = this.choices.keySet();
        for (String userid : set) {
            int c = this.choices.get(userid);
            if (c < 0 || c > 9) continue;
            int n = c;
            this.nchoices[n] = this.nchoices[n] + 1;
        }
    }

    public String getVoteCountInJSON() {
        boolean firstElement = true;
        this.countVotes();
        StringBuilder strBuf = new StringBuilder("");
        strBuf.append("[");
        for (int i = 0; i <= 9; ++i) {
            if (firstElement) {
                firstElement = false;
            } else {
                strBuf.append(",");
            }
            strBuf.append("{");
            strBuf.append("\"item\":" + i + ",");
            strBuf.append("\"count\":" + this.nchoices[i]);
            strBuf.append("}");
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    public boolean isFaculty() {
        return true;
    }

    public void appendLog(String str) {
        Document doc = this.logTextPane.getDocument();
        try {
            doc.insertString(doc.getLength(), str, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendLogWithTimestamp(String msg) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        this.appendLog(dateFormat.format(date) + "\t" + msg);
    }

    public boolean canOverwriteFile(String fn) {
        int rc = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("FILE") + " \"" + fn + "\" " + ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("EXIST. DO YOU WANT TO OVERWRITE IT?"), "WARNING", 2, 2);
        return rc == 0;
    }

    public void changeBroadcastAddress(byte[] bcas) {
        this.broadcastAddress[0] = bcas[0];
        this.broadcastAddress[1] = bcas[1];
        this.broadcastAddress[2] = bcas[2];
        this.broadcastAddress[3] = bcas[3];
    }

    public void receiverTerminated() {
        this.receiverIsRunning = false;
        this.startToggleButton.setSelected(false);
        this.startToggleButton.setText("Start");
    }

    public void startBroadcast() {
        if (this.broadcaster != null && this.broadcaster.isAlive()) {
            return;
        }
        this.broadcaster = new BroadcastThread();
        this.broadcaster.start();
    }

    public void stopBroadcast() {
        if (this.broadcaster != null && this.broadcaster.isAlive()) {
            this.broadcasterIsTerminating = true;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.broadcaster = null;
        }
    }

    public String getCommentsInJSON() {
        String comments = this.commentsTextArea.getText();
        comments = comments.replaceAll("\"", "&quot;");
        comments = comments.replaceAll("[\r\n]", "<br>");
        StringBuilder strBuf = new StringBuilder("");
        strBuf.append("{");
        strBuf.append("\"comment\":\"" + comments + "\"");
        strBuf.append("}");
        return strBuf.toString();
    }

    public String getMessageInJSON_Id(int id) {
        return this.receiver.getMessageInJSON_Id(id);
    }

    public String getMessagesInJSON(int nmsg) {
        return this.receiver.getMessagesInJSON(nmsg);
    }

    public List<List<String>> getMessages(int nmsg) {
        return this.receiver.getMessages(nmsg);
    }

    public List<List<String>> getNewMessages() {
        return this.receiver.getNewMessages();
    }

    public void generateKeyPair() {
        try {
            KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
            keygen.initialize(512);
            this.rsaKeyPair = keygen.generateKeyPair();
            this.publicKey = (RSAPublicKey)this.rsaKeyPair.getPublic();
            this.privateKey = (RSAPrivateKey)this.rsaKeyPair.getPrivate();
        }
        catch (NoSuchAlgorithmException e) {
            this.rsaKeyPair = null;
            this.publicKey = null;
            this.privateKey = null;
        }
    }

    private static void hexDump(byte[] dump) {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        System.out.println(hexDump.encode(dump));
    }

    private void openCommentFile() {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Plain text", "txt");
        fileChooser.addChoosableFileFilter(filter);
        if (fileChooser.showOpenDialog(this) == 0) {
            File commentFile = fileChooser.getSelectedFile();
            this.commentList.clear();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commentFile), "UTF-8"));
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line.length() > 140) {
                        line = line.substring(0, 140);
                    }
                    this.commentList.add(line);
                }
                reader.close();
            }
            catch (IOException ioe) {
                this.commentsTextArea.setText("cannot open file: " + commentFile.getName());
            }
        }
        this.lineNumberSpinner.setValue(0);
        this.setCommentsTextArea();
    }

    private void setCommentsTextArea() {
        int n = (Integer)this.lineNumberSpinner.getValue();
        if (this.commentList != null && this.commentList.size() > 0) {
            if (n < 1) {
                n = 1;
                this.lineNumberSpinner.setValue(n);
            } else if (n > this.commentList.size()) {
                n = this.commentList.size();
                this.lineNumberSpinner.setValue(n);
            }
            String comment = this.commentList.get(n - 1);
            this.commentsTextArea.setText(comment);
        } else {
            this.lineNumberSpinner.setValue(0);
        }
    }

    class BroadcastThread
    extends Thread {
        private DatagramSocket dsock;

        @Override
        public void run() {
            try {
                this.dsock = new DatagramSocket();
                this.dsock.setBroadcast(true);
            }
            catch (SocketException ex) {
                TMController.this.broadcaster = null;
                return;
            }
            byte[] sendData = new byte[1024];
            DatagramPacket pkt = new DatagramPacket(sendData, sendData.length);
            try {
                pkt.setAddress(InetAddress.getByAddress(TMController.this.broadcastAddress));
            }
            catch (UnknownHostException ex) {
                this.dsock.close();
                TMController.this.broadcaster = null;
                return;
            }
            pkt.setPort(3100 + TMController.this.serverChannel);
            byte[] pubkeyMod = null;
            byte[] pubkeyExp = null;
            if (TMController.this.publicKey != null) {
                pubkeyMod = TMController.this.publicKey.getModulus().toByteArray();
                pubkeyExp = TMController.this.publicKey.getPublicExponent().toByteArray();
            }
            try {
                while (true) {
                    int i;
                    if (TMController.this.broadcasterIsTerminating) {
                        TMController.this.broadcasterIsTerminating = false;
                        this.dsock.close();
                        return;
                    }
                    String comment = TMController.this.commentsTextArea.getText();
                    if (comment.getBytes("UTF-8").length > 255) {
                        int k = 0;
                        int ell = comment.length() - 1;
                        do {
                            String sh;
                            if ((sh = comment.substring(0, (k + ell) / 2)).getBytes("UTF-8").length <= 255) {
                                k = (k + ell) / 2;
                                continue;
                            }
                            ell = (k + ell) / 2;
                        } while (ell - k > 1);
                        comment = comment.substring(0, k);
                    }
                    byte[] commentData = comment.getBytes("UTF-8");
                    int bp = 0;
                    sendData[bp] = (byte)commentData.length;
                    ++bp;
                    for (i = 0; i < commentData.length && bp < 1024; ++bp, ++i) {
                        sendData[bp] = commentData[i];
                    }
                    if (pubkeyMod != null && pubkeyExp != null) {
                        sendData[bp] = (byte)pubkeyMod.length;
                        ++bp;
                        for (i = 0; i < pubkeyMod.length && bp < 1024; ++bp, ++i) {
                            sendData[bp] = pubkeyMod[i];
                        }
                        sendData[bp] = (byte)pubkeyExp.length;
                        ++bp;
                        for (i = 0; i < pubkeyExp.length && bp < 1024; ++bp, ++i) {
                            sendData[bp] = pubkeyExp[i];
                        }
                    }
                    while (bp < 1024) {
                        sendData[bp] = 0;
                        ++bp;
                    }
                    pkt.setData(sendData);
                    this.dsock.send(pkt);
                    Thread.sleep(5000L);
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.dsock.close();
            TMController.this.broadcaster = null;
        }
    }
}

