/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import turtlemessenger.TMController;

public class TMHttpServer {
    TMController controller = null;
    HttpServer server = null;
    ExecutorService executor;

    TMHttpServer(TMController parent, int port) {
        this.controller = parent;
        this.executor = Executors.newCachedThreadPool();
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.server.createContext("/", new TMFileHandler());
            this.server.createContext("/msg", new TMMessageHandler());
            this.server.createContext("/cmt", new TMCommentsHandler());
            this.server.createContext("/vote", new TMVoteHandler());
            this.server.setExecutor(this.executor);
            this.server.start();
        }
        catch (IOException ex) {
            this.server = null;
        }
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.stop(0);
            this.executor.shutdown();
        }
    }

    private class TMVoteHandler
    implements HttpHandler {
        private TMVoteHandler() {
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            String method = ex.getRequestMethod();
            if (method.equalsIgnoreCase("GET")) {
                OutputStream os = ex.getResponseBody();
                ex.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                ex.getResponseHeaders().add("Cache-Control", "no-cache,must-revalidate");
                byte[] data = TMHttpServer.this.controller.getVoteCountInJSON().getBytes("UTF-8");
                ex.sendResponseHeaders(200, data.length);
                os.write(data);
                os.close();
            }
        }
    }

    private class TMCommentsHandler
    implements HttpHandler {
        private TMCommentsHandler() {
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            String method = ex.getRequestMethod();
            if (method.equalsIgnoreCase("GET")) {
                OutputStream os = ex.getResponseBody();
                ex.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                ex.getResponseHeaders().add("Cache-Control", "no-cache,must-revalidate");
                byte[] data = TMHttpServer.this.controller.getCommentsInJSON().getBytes("UTF-8");
                ex.sendResponseHeaders(200, data.length);
                os.write(data);
                os.close();
            }
        }
    }

    private class TMMessageHandler
    implements HttpHandler {
        private TMMessageHandler() {
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            String method = ex.getRequestMethod();
            if (method.equalsIgnoreCase("GET")) {
                byte[] data;
                OutputStream os = ex.getResponseBody();
                String uri = ex.getRequestURI().toString();
                ex.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                ex.getResponseHeaders().add("Cache-Control", "no-cache,must-revalidate");
                if (uri.endsWith("/msg") || uri.endsWith("/msg/")) {
                    data = TMHttpServer.this.controller.getMessagesInJSON(100).getBytes("UTF-8");
                } else {
                    String[] cols = uri.split("/");
                    int id = Integer.parseInt(cols[cols.length - 1]);
                    data = TMHttpServer.this.controller.getMessageInJSON_Id(id).getBytes("UTF-8");
                }
                ex.sendResponseHeaders(200, data.length);
                os.write(data);
                os.close();
            }
        }
    }

    private class TMFileHandler
    implements HttpHandler {
        private TMFileHandler() {
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            String method = ex.getRequestMethod();
            if (method.equalsIgnoreCase("GET")) {
                int len;
                OutputStream os = ex.getResponseBody();
                String uri = ex.getRequestURI().toString();
                if (uri.equals("/")) {
                    uri = uri + "index.html";
                }
                if (uri.endsWith(".html")) {
                    ex.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
                } else if (uri.endsWith(".png")) {
                    ex.getResponseHeaders().add("Content-Type", "image/png");
                } else if (uri.endsWith(".css")) {
                    ex.getResponseHeaders().add("Content-Type", "text/css");
                } else if (uri.endsWith(".js")) {
                    ex.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                } else {
                    ex.sendResponseHeaders(404, 0L);
                    os.close();
                    return;
                }
                URL location = this.getClass().getResource("html" + uri);
                InputStream fin = location.openStream();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((len = fin.read(buffer)) >= 0) {
                    bout.write(buffer, 0, len);
                }
                fin.close();
                bout.close();
                byte[] data = bout.toByteArray();
                ex.sendResponseHeaders(200, data.length);
                os.write(data);
                os.close();
            }
        }
    }
}

