/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;
import turtlemessenger.TMController;

public class TMMessages
extends JDialog {
    TMController controller;
    private UpdateThread thread;
    private JCheckBox autoUpdateCheckBox;
    private JButton doneButton;
    private JButton enlargeButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JCheckBox largeFontCheckBox;
    private JTable messageTable;
    private JButton updateButton;

    public TMMessages(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.controller = (TMController)parent;
        this.setLocationRelativeTo(parent);
        this.thread = null;
        JTableHeader tabHeader = this.messageTable.getTableHeader();
        tabHeader.setFont(new Font("SansSerif", 0, 14));
        TableColumnModel tcm = this.messageTable.getColumnModel();
        MultiLineTableCellRenderer cellRenderer = new MultiLineTableCellRenderer();
        tcm.getColumn(0).setCellRenderer(cellRenderer);
        tcm.getColumn(1).setCellRenderer(cellRenderer);
        tcm.getColumn(2).setCellRenderer(cellRenderer);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.doneButton = new JButton();
        this.updateButton = new JButton();
        this.largeFontCheckBox = new JCheckBox();
        this.autoUpdateCheckBox = new JCheckBox();
        this.enlargeButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.messageTable = new JTable();
        this.setTitle("List of received messages");
        this.setMinimumSize(new Dimension(550, 200));
        ResourceBundle bundle = ResourceBundle.getBundle("turtlemessenger/TMBundle");
        this.doneButton.setText(bundle.getString("DONE"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMMessages.this.doneButtonActionPerformed(evt);
            }
        });
        this.updateButton.setText(bundle.getString("UPDATE"));
        this.updateButton.setToolTipText("\u6700\u65b0\u306e\u6295\u7a3f\u5185\u5bb9\u306b\u66f4\u65b0\u3057\u307e\u3059");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMMessages.this.updateButtonActionPerformed(evt);
            }
        });
        this.largeFontCheckBox.setText(bundle.getString("LARGE FONT"));
        this.largeFontCheckBox.setToolTipText("\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u308b\u3068\u3001\u5927\u304d\u3081\u306e\u30d5\u30a9\u30f3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059");
        this.largeFontCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMMessages.this.largeFontCheckBoxActionPerformed(evt);
            }
        });
        this.autoUpdateCheckBox.setText(bundle.getString("AUTO UPDATE"));
        this.autoUpdateCheckBox.setToolTipText("\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u308b\u3068\u3001\u6295\u7a3f\u5185\u5bb9\u304c10\u79d2\u304a\u304d\u306b\u66f4\u65b0\u3055\u308c\u307e\u3059");
        this.autoUpdateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMMessages.this.autoUpdateCheckBoxActionPerformed(evt);
            }
        });
        this.enlargeButton.setText(bundle.getString("ENLARGE"));
        this.enlargeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMMessages.this.enlargeButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(28, Short.MAX_VALUE).add(this.autoUpdateCheckBox).addPreferredGap(0).add(this.largeFontCheckBox).addPreferredGap(1).add(this.enlargeButton, -2, 123, -2).addPreferredGap(0).add(this.updateButton).addPreferredGap(0).add(this.doneButton, -2, 87, -2).add(20, 20, 20)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(3).add(this.doneButton).add(this.updateButton).add(this.largeFontCheckBox).add(this.autoUpdateCheckBox).add(this.enlargeButton)).addContainerGap()));
        this.messageTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Time", "Nickname", "Message"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.messageTable.setAutoCreateRowSorter(true);
        this.messageTable.setRowHeight(32);
        this.messageTable.setShowHorizontalLines(false);
        this.messageTable.setShowVerticalLines(false);
        this.messageTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.messageTable);
        this.messageTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.messageTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.messageTable.getColumnModel().getColumn(2).setPreferredWidth(400);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jScrollPane2, -1, 463, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.updateTable();
    }

    private void largeFontCheckBoxActionPerformed(ActionEvent evt) {
        TableColumnModel tcm = this.messageTable.getColumnModel();
        if (this.largeFontCheckBox.isSelected()) {
            ((MultiLineTableCellRenderer)tcm.getColumn(0).getCellRenderer()).enlargeFont(true);
            ((MultiLineTableCellRenderer)tcm.getColumn(1).getCellRenderer()).enlargeFont(true);
            ((MultiLineTableCellRenderer)tcm.getColumn(2).getCellRenderer()).enlargeFont(true);
        } else {
            ((MultiLineTableCellRenderer)tcm.getColumn(0).getCellRenderer()).enlargeFont(false);
            ((MultiLineTableCellRenderer)tcm.getColumn(1).getCellRenderer()).enlargeFont(false);
            ((MultiLineTableCellRenderer)tcm.getColumn(2).getCellRenderer()).enlargeFont(false);
        }
        this.messageTable.repaint();
    }

    private void autoUpdateCheckBoxActionPerformed(ActionEvent evt) {
        if (this.autoUpdateCheckBox.isSelected()) {
            if (this.thread == null) {
                this.thread = new UpdateThread();
                this.thread.start();
            }
        } else {
            try {
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupt();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    private void enlargeButtonActionPerformed(ActionEvent evt) {
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setBounds(bounds);
    }

    public synchronized void updateTable() {
        List<List<String>> msgList = this.controller.getNewMessages();
        for (int i = 0; i < msgList.size(); ++i) {
            List<String> row = msgList.get(i);
            ((DefaultTableModel)this.messageTable.getModel()).insertRow(0, new Object[]{row.get(0), row.get(1), row.get(2)});
        }
    }

    class UpdateThread
    extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    TMMessages.this.updateTable();
                    UpdateThread.sleep(10000L);
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    public class MultiLineTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();
        private Font font;
        private Font largeFont;
        private Font smallFont;

        public MultiLineTableCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
            this.largeFont = new Font("SansSerif", 0, 36);
            this.font = this.smallFont = new Font("SansSerif", 0, 14);
        }

        public void enlargeFont(boolean yn) {
            this.font = yn ? this.largeFont : this.smallFont;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setFont(this.font);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
            }
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.adjustRowHeight(table, row, column);
            return this;
        }

        private void adjustRowHeight(JTable table, int row, int column) {
            int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
            this.setSize(new Dimension(cWidth, 1000));
            int prefH = this.getPreferredSize().height;
            while (this.rowColHeight.size() <= row) {
                this.rowColHeight.add(new ArrayList(column));
            }
            List<Integer> colHeights = this.rowColHeight.get(row);
            while (colHeights.size() <= column) {
                colHeights.add(0);
            }
            colHeights.set(column, prefH);
            int maxH = prefH;
            for (Integer colHeight : colHeights) {
                if (colHeight <= maxH) continue;
                maxH = colHeight;
            }
            if (table.getRowHeight(row) != maxH) {
                table.setRowHeight(row, maxH);
            }
        }
    }
}

