/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import turtlemessenger.TMController;

public class TMReceiver {
    private TMController controller;
    private ServerSocket serverSock;
    private int serverPort;
    private final int BUFFSIZE = 8192;
    private String myPasscode;
    private List<FeedbackMessage> clientMessages;
    ReceiverThread receiver;
    private boolean receiverIsTerminating;
    private int lastReadPosition;

    TMReceiver(TMController parent, int port) {
        this.controller = parent;
        this.serverPort = port;
        this.myPasscode = "";
        this.clientMessages = new ArrayList<FeedbackMessage>();
        this.receiver = null;
        this.receiverIsTerminating = false;
        this.lastReadPosition = 0;
    }

    public String messageAt(int i, boolean privacyMode) {
        if (i < 0 || i >= this.clientMessages.size()) {
            return null;
        }
        FeedbackMessage fm = this.clientMessages.get(i);
        StringBuilder strBuf = new StringBuilder("");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        strBuf.append(dateFormat.format(fm.time) + "\t");
        if (!privacyMode) {
            strBuf.append(fm.userid + "\t");
            strBuf.append(fm.hostname + "\t");
        }
        strBuf.append(fm.nickname + "\t");
        strBuf.append(fm.choice + "\t");
        strBuf.append(fm.message + "\t");
        strBuf.append(fm.error + "\t");
        strBuf.append("\n");
        return strBuf.toString();
    }

    private static String escapeHTML(String str) {
        StringBuffer strBuf = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char c4;
            char c3;
            char c2;
            char c1 = str.charAt(i);
            if (i < str.length() - 3) {
                c2 = str.charAt(i + 1);
                c3 = str.charAt(i + 2);
                c4 = str.charAt(i + 3);
            } else {
                c3 = c4 = c1;
                c2 = c4;
            }
            if (!(c1 != '<' || c2 != 'b' && c2 != 'B' || c3 != 'r' && c3 != 'R' || c4 != '>')) {
                strBuf.append(c1);
                strBuf.append(c2);
                strBuf.append(c3);
                strBuf.append(c4);
                i += 3;
                continue;
            }
            if (c1 == '\"' || c1 == '<' || c1 == '>') {
                strBuf.append("&#" + c1 + ";");
                continue;
            }
            strBuf.append(c1);
        }
        return strBuf.toString();
    }

    public String getMessageInJSON_Id(int id) {
        StringBuilder strBuf = new StringBuilder("");
        try {
            FeedbackMessage fm = this.clientMessages.get(id);
            strBuf.append("{");
            strBuf.append("\"id\":" + id + ",");
            String[] ds = fm.time.toString().split(" ");
            String timeStr = ds[3];
            strBuf.append("\"time\":\"" + timeStr + "\",");
            strBuf.append("\"nickname\":\"" + TMReceiver.escapeHTML(fm.nickname) + "\",");
            strBuf.append("\"message\":\"" + TMReceiver.escapeHTML(fm.message) + "\",");
            strBuf.append("\"error\":\"" + TMReceiver.escapeHTML(fm.error) + "\"");
            strBuf.append("}");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return strBuf.toString();
    }

    public String getMessagesInJSON(int nmsg) {
        boolean firstElement = true;
        StringBuilder strBuf = new StringBuilder("");
        int n = this.clientMessages.size();
        if (nmsg <= 0) {
            nmsg = Integer.MAX_VALUE;
        }
        strBuf.append("[");
        int i = n - 1;
        for (int cnt = 0; i >= 0 && cnt < nmsg; --i, ++cnt) {
            FeedbackMessage fm = this.clientMessages.get(i);
            if (fm.message.length() <= 0 && fm.error.length() <= 0) continue;
            if (firstElement) {
                firstElement = false;
            } else {
                strBuf.append(",");
            }
            strBuf.append(this.getMessageInJSON_Id(i));
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    private String combineMsgAndErr(String msg, String err) {
        msg = msg.replaceAll("<br>", "\n");
        err = err.replaceAll("<br>", "\n");
        if (msg.length() > 0 && err.length() > 0) {
            return msg + "\n" + err;
        }
        if (msg.length() > 0) {
            return msg;
        }
        return err;
    }

    public List<List<String>> getMessages(int nmsg) {
        ArrayList<List<String>> msgList = new ArrayList<List<String>>();
        int n = this.clientMessages.size();
        if (nmsg <= 0) {
            nmsg = Integer.MAX_VALUE;
        }
        int i = n - 1;
        for (int cnt = 0; i >= 0 && cnt < nmsg; --i, ++cnt) {
            FeedbackMessage fm = this.clientMessages.get(i);
            if (fm.message.length() <= 0 && fm.error.length() <= 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            String[] ds = fm.time.toString().split(" ");
            String timeStr = ds[3];
            row.add(timeStr);
            row.add(fm.nickname);
            row.add(this.combineMsgAndErr(fm.message, fm.error));
            msgList.add(row);
        }
        return msgList;
    }

    public List<List<String>> getNewMessages() {
        ArrayList<List<String>> msgList = new ArrayList<List<String>>();
        int n = this.clientMessages.size();
        for (int i = this.lastReadPosition; i < n; ++i) {
            FeedbackMessage fm = this.clientMessages.get(i);
            if (fm.message.length() <= 0 && fm.error.length() <= 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            String[] ds = fm.time.toString().split(" ");
            String timeStr = ds[3];
            row.add(timeStr);
            row.add(fm.nickname);
            row.add(this.combineMsgAndErr(fm.message, fm.error));
            msgList.add(row);
        }
        this.lastReadPosition = n;
        return msgList;
    }

    public void setMyPasscode(String s) {
        this.myPasscode = s.trim();
    }

    public void setReceiverPort(int port) {
        this.serverPort = port;
    }

    public void terminateReceiver() {
        if (this.receiver == null) {
            return;
        }
        this.receiverIsTerminating = true;
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.receiverIsTerminating);
        this.receiver = null;
    }

    public boolean hasMessage() {
        return this.clientMessages.size() > 0;
    }

    public void startReceiver() {
        if (this.receiver != null && this.receiver.isAlive()) {
            return;
        }
        this.receiverIsTerminating = false;
        this.receiver = new ReceiverThread();
        this.receiver.start();
    }

    private int byte2int(byte c) {
        int r = 0;
        if (c >= 48 && c <= 57) {
            r = c - 48;
        } else if (c >= 97 && c <= 102) {
            r = c - 97 + 10;
        } else if (c >= 65 && c <= 70) {
            r = c - 65 + 10;
        }
        return r;
    }

    public byte[] decodeHexByte(String hex) {
        int d0 = 0;
        int d1 = 0;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] bytes = hex.getBytes();
        int cnt = 0;
        for (byte b : bytes) {
            if (b == 32) continue;
            if (cnt % 2 == 0) {
                d1 = this.byte2int(b);
            } else {
                d0 = this.byte2int(b);
                bao.write(d1 * 16 + d0);
            }
            ++cnt;
        }
        return bao.toByteArray();
    }

    public String decryptShortMessage(String hex) {
        byte[] data = this.decodeHexByte(hex);
        RSAPrivateKey key = this.controller.privateKey;
        byte[] decrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            decrypted = cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (NoSuchPaddingException e) {
        }
        catch (BadPaddingException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (IllegalBlockSizeException e) {
            // empty catch block
        }
        try {
            if (decrypted != null) {
                return new String(decrypted, "UTF-8");
            }
            return "?";
        }
        catch (UnsupportedEncodingException ex) {
            return "?";
        }
    }

    public class ReceiverThread
    extends Thread {
        ReceiverThread() {
        }

        @Override
        public void run() {
            String regx = "^(.+?)=(.*)$";
            Pattern pat = Pattern.compile(regx);
            try {
                TMReceiver.this.serverSock = new ServerSocket();
                TMReceiver.this.serverSock.setReuseAddress(true);
                TMReceiver.this.serverSock.setSoTimeout(10);
                TMReceiver.this.serverSock.bind(new InetSocketAddress(TMReceiver.this.serverPort));
                byte[] receiveBuf = new byte[8192];
                while (true) {
                    String line;
                    int status = 0;
                    int choice = 0;
                    String passcode = "";
                    String message = "";
                    String errmsg = "";
                    String nickname = "";
                    String userid = "";
                    String hostname = "";
                    Socket clientSock = null;
                    try {
                        clientSock = TMReceiver.this.serverSock.accept();
                    }
                    catch (SocketTimeoutException e) {
                        if (!TMReceiver.this.receiverIsTerminating) continue;
                        TMReceiver.this.serverSock.close();
                        TMReceiver.this.controller.receiverTerminated();
                        TMReceiver.this.receiverIsTerminating = false;
                        return;
                    }
                    SocketAddress clientAddress = clientSock.getRemoteSocketAddress();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(clientSock.getInputStream(), "utf-8"));
                    OutputStreamWriter writer = new OutputStreamWriter(clientSock.getOutputStream(), "utf-8");
                    while ((line = reader.readLine()) != null) {
                        Matcher mat = pat.matcher(line);
                        if (!mat.find()) continue;
                        String key = mat.group(1);
                        String value = mat.group(2);
                        if (key.equals("passcode")) {
                            passcode = TMReceiver.this.decryptShortMessage(value);
                            if (TMReceiver.this.myPasscode.length() == 0 || TMReceiver.this.myPasscode.equalsIgnoreCase("any") || TMReceiver.this.myPasscode.equals("*")) {
                                status = 200;
                                continue;
                            }
                            if (passcode.equals(TMReceiver.this.myPasscode)) {
                                status = 200;
                                continue;
                            }
                            status = 300;
                            continue;
                        }
                        if (key.equals("choice")) {
                            choice = Integer.valueOf(value);
                            continue;
                        }
                        if (key.equals("message")) {
                            message = value;
                            continue;
                        }
                        if (key.equals("nickname")) {
                            nickname = value;
                            continue;
                        }
                        if (key.equals("userid")) {
                            userid = TMReceiver.this.decryptShortMessage(value);
                            continue;
                        }
                        if (key.equals("hostname")) {
                            hostname = TMReceiver.this.decryptShortMessage(value);
                            continue;
                        }
                        if (!key.equals("errmsg")) continue;
                        errmsg = value;
                    }
                    if (status == 200) {
                        writer.write(ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("MESSAGE ACCEPTED") + "\r\n");
                        FeedbackMessage fm = new FeedbackMessage(hostname, userid, nickname, choice, message, errmsg);
                        TMReceiver.this.clientMessages.add(fm);
                        TMReceiver.this.controller.appendLog(TMReceiver.this.messageAt(TMReceiver.this.clientMessages.size() - 1, false));
                        TMReceiver.this.controller.votedTo(userid, choice);
                    } else {
                        writer.write(ResourceBundle.getBundle("turtlemessenger/TMBundle").getString("CANNOT SEND YOUR FEEDBACK") + "\r\n");
                    }
                    writer.flush();
                    clientSock.shutdownOutput();
                    clientSock.close();
                }
            }
            catch (IOException ex) {
                TMReceiver.this.controller.appendLogWithTimestamp("#\tI/O ERROR\n");
                Logger.getLogger(TMReceiver.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    TMReceiver.this.serverSock.close();
                }
                catch (IOException ex2) {
                    TMReceiver.this.controller.appendLogWithTimestamp("#\tSOCKET ERROR\n");
                }
                TMReceiver.this.controller.receiverTerminated();
                TMReceiver.this.receiverIsTerminating = false;
                return;
            }
        }
    }

    public class FeedbackMessage {
        public Date time;
        public int choice;
        public String message;
        public String error;
        public String nickname;
        public String userid;
        public String hostname;

        FeedbackMessage(String host, String uid, String handle, int c, String msg, String err) {
            this.choice = c;
            this.message = msg;
            this.error = err;
            this.userid = uid;
            this.nickname = handle;
            this.hostname = host;
            this.time = new Date();
        }
    }
}

