/*
 * Decompiled with CFR 0.152.
 */
package turtlemessenger;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import turtlemessenger.TMController;

public class TMVotingSummary
extends JDialog {
    private TMController controller;
    private PlottingCanvas canvas;
    private int[] nchoices;
    private UpdateThread thread;
    private int width;
    private int height;
    private JButton doneButton;
    private JButton enlargeButton;
    private JPanel graphPanel;
    private JPanel jPanel1;

    public TMVotingSummary(Frame parent, boolean modal) {
        super(parent, modal);
        this.controller = (TMController)parent;
        this.initComponents();
        this.canvas = new PlottingCanvas();
        this.graphPanel.add(this.canvas);
        this.nchoices = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.nchoices[i] = 0;
        }
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TMVotingSummary.this.doneButtonActionPerformed(null);
            }
        });
        this.thread = new UpdateThread();
        this.thread.start();
    }

    public void updateNumbers() {
        this.controller.countVotes();
        for (int i = 0; i < 10; ++i) {
            this.nchoices[i] = this.controller.nchoices[i];
        }
    }

    private void initComponents() {
        this.graphPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.doneButton = new JButton();
        this.enlargeButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Voting results");
        this.setMinimumSize(new Dimension(400, 400));
        this.graphPanel.setToolTipText("\u6295\u7968\u6570\u306e\u5272\u5408\u304c\u68d2\u30b0\u30e9\u30d5\u3067\u8868\u793a\u3055\u308c\u307e\u3059");
        this.graphPanel.setOpaque(false);
        this.graphPanel.setPreferredSize(new Dimension(432, 350));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(1).add(0, 413, Short.MAX_VALUE));
        ResourceBundle bundle = ResourceBundle.getBundle("turtlemessenger/TMBundle");
        this.doneButton.setText(bundle.getString("DONE"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMVotingSummary.this.doneButtonActionPerformed(evt);
            }
        });
        this.enlargeButton.setText(bundle.getString("ENLARGE"));
        this.enlargeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMVotingSummary.this.enlargeButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(376, Short.MAX_VALUE).add(this.enlargeButton, -2, 127, -2).add(18, 18, 18).add(this.doneButton).add(23, 23, 23)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(3).add(this.doneButton).add(this.enlargeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.graphPanel, -1, 621, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.graphPanel, -1, 413, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void enlargeButtonActionPerformed(ActionEvent evt) {
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setBounds(bounds);
    }

    class PlottingCanvas
    extends Canvas {
        private Font bfont;
        private Font sfont;
        private int prevHeight = 0;
        private Color brown = new Color(156, 93, 82);

        PlottingCanvas() {
        }

        private void drawStringRight(String str, int x, int y, Graphics g, Font font) {
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(str);
            g.drawString(str, x - w, y);
        }

        @Override
        public void paint(Graphics g) {
            TMVotingSummary.this.width = TMVotingSummary.this.graphPanel.getWidth();
            TMVotingSummary.this.height = TMVotingSummary.this.graphPanel.getHeight();
            this.setBounds(0, 0, TMVotingSummary.this.width, TMVotingSummary.this.height);
            this.setBackground(Color.white);
            if (TMVotingSummary.this.height != this.prevHeight) {
                this.bfont = new Font("SansSerif", 1, (int)((double)TMVotingSummary.this.height / 15.0));
                this.sfont = new Font("SansSerif", 0, (int)((double)TMVotingSummary.this.height / 20.0));
                this.prevHeight = TMVotingSummary.this.height;
            }
            g.setColor(Color.BLACK);
            g.setFont(this.bfont);
            double yofs = ((double)TMVotingSummary.this.height / 11.0 - (double)TMVotingSummary.this.height / 15.0) * 0.5;
            g.drawString("TOTAL", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 1.0 / 11.0 - yofs));
            g.drawString("1/YES", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 2.0 / 11.0 - yofs));
            g.drawString("2/NO", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 3.0 / 11.0 - yofs));
            g.drawString("3", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 4.0 / 11.0 - yofs));
            g.drawString("4", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 5.0 / 11.0 - yofs));
            g.drawString("5", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 6.0 / 11.0 - yofs));
            g.drawString("6", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 7.0 / 11.0 - yofs));
            g.drawString("7", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 8.0 / 11.0 - yofs));
            g.drawString("8", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 9.0 / 11.0 - yofs));
            g.drawString("9", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 10.0 / 11.0 - yofs));
            g.drawString("0 / ?", (int)((double)TMVotingSummary.this.width * 0.05), (int)((double)TMVotingSummary.this.height * 11.0 / 11.0 - yofs));
            g.setFont(this.sfont);
            g.drawString("0%", (int)((double)TMVotingSummary.this.width * 0.34), (int)((double)TMVotingSummary.this.height * 1.0 / 11.0 - yofs));
            g.drawString("50%", (int)((double)TMVotingSummary.this.width * 0.62), (int)((double)TMVotingSummary.this.height * 1.0 / 11.0 - yofs));
            g.drawString("100%", (int)((double)TMVotingSummary.this.width * 0.9), (int)((double)TMVotingSummary.this.height * 1.0 / 11.0 - yofs));
            float tot = 0.0f;
            for (int i = 0; i < 10; ++i) {
                tot += (float)TMVotingSummary.this.nchoices[i];
            }
            g.setColor(Color.RED);
            this.drawStringRight(Integer.toString((int)tot), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 1.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[1]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 2.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[2]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 3.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[3]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 4.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[4]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 5.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[5]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 6.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[6]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 7.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[7]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 8.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[8]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 9.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[9]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 10.0 / 11.0 - yofs), g, this.bfont);
            this.drawStringRight(Integer.toString(TMVotingSummary.this.nchoices[0]), (int)((double)TMVotingSummary.this.width * 0.33), (int)((double)TMVotingSummary.this.height * 11.0 / 11.0 - yofs), g, this.bfont);
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect((int)((double)TMVotingSummary.this.width * 0.35), (int)((double)TMVotingSummary.this.height / 11.0), (int)((double)TMVotingSummary.this.width * 0.6), (int)((double)(TMVotingSummary.this.height * 10) / 11.0));
            g.setColor(Color.DARK_GRAY);
            for (double x = (double)TMVotingSummary.this.width * 0.35; x < (double)TMVotingSummary.this.width * 0.95 + 1.0; x += (double)TMVotingSummary.this.width * 0.6 / 10.0) {
                g.drawLine((int)x, (int)((double)TMVotingSummary.this.height / 11.0), (int)x, TMVotingSummary.this.height);
            }
            Color[] colors = new Color[]{this.brown, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.GRAY, Color.LIGHT_GRAY, Color.BLACK};
            int cnt = 0;
            for (double y = (double)TMVotingSummary.this.height / 11.0; y < (double)TMVotingSummary.this.height && cnt < 10; y += (double)TMVotingSummary.this.height / 11.0, ++cnt) {
                double barlen = 0.0;
                if ((double)tot > 0.0) {
                    int choice = cnt <= 8 ? cnt + 1 : 0;
                    barlen = (double)((float)TMVotingSummary.this.nchoices[choice] / tot * (float)TMVotingSummary.this.width) * 0.6;
                }
                g.setColor(colors[cnt]);
                g.fill3DRect((int)((double)TMVotingSummary.this.width * 0.35), (int)(y + yofs), (int)barlen, (int)((double)TMVotingSummary.this.height / 15.0), true);
            }
        }
    }

    class UpdateThread
    extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    TMVotingSummary.this.updateNumbers();
                    TMVotingSummary.this.width = TMVotingSummary.this.graphPanel.getWidth();
                    TMVotingSummary.this.height = TMVotingSummary.this.graphPanel.getHeight();
                    TMVotingSummary.this.canvas.setBounds(0, 0, TMVotingSummary.this.width, TMVotingSummary.this.height);
                    TMVotingSummary.this.canvas.repaint();
                    UpdateThread.sleep(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

