/*
 * Copyright (C) 2013 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package turtlemessenger;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */
public class TMAboutDialog extends javax.swing.JDialog {

    /**
     * Creates new form TEAboutDialog
     */
    public TMAboutDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        String version = getClass().getPackage().getImplementationVersion() ;
        builtDatejLabel.setText("build " + version) ;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        mainTitleLabel = new javax.swing.JLabel();
        builtDatejLabel = new javax.swing.JLabel();
        copyrightLabel = new javax.swing.JLabel();
        turtleHeadLabel = new javax.swing.JLabel();
        uriButton = new javax.swing.JButton();
        subTitlejLabel2 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("About TurtleMessenger");

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        mainTitleLabel.setFont(new java.awt.Font("Lucida Grande", 1, 20)); // NOI18N
        mainTitleLabel.setText("TurtleMessenger");

        builtDatejLabel.setText("Build 20140719a");

        copyrightLabel.setText("Copyright (c) 2013-2014 Yoshinori Hayakawa. All Rights Reserved.");

        turtleHeadLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/turtlemessenger/images/turtle-head.png"))); // NOI18N

        uriButton.setForeground(new java.awt.Color(0, 0, 204));
        uriButton.setText("http://seaotter.cite.tohoku.ac.jp");
        uriButton.setBorder(null);
        uriButton.setBorderPainted(false);
        uriButton.setContentAreaFilled(false);
        uriButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        uriButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        uriButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                uriButtonActionPerformed(evt);
            }
        });

        subTitlejLabel2.setText("A simple cummunication tool for ICL");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(layout.createSequentialGroup()
                        .add(39, 39, 39)
                        .add(turtleHeadLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(mainTitleLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 191, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(builtDatejLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 117, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(13, 13, 13))
                            .add(layout.createSequentialGroup()
                                .add(subTitlejLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 241, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(0, 0, Short.MAX_VALUE))))
                    .add(layout.createSequentialGroup()
                        .add(30, 30, 30)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(layout.createSequentialGroup()
                                .add(uriButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 246, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(100, 100, 100)
                                .add(okButton))
                            .add(copyrightLabel))))
                .addContainerGap(23, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(18, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(mainTitleLabel)
                            .add(builtDatejLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 24, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(subTitlejLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 24, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(turtleHeadLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 61, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(copyrightLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(okButton)
                    .add(uriButton))
                .add(0, 5, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose() ; 
    }//GEN-LAST:event_okButtonActionPerformed

    private void uriButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_uriButtonActionPerformed
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("http://seaotter.cite.tohoku.ac.jp"));
            } catch (IOException e) { 
                ; 
            } catch (URISyntaxException ex) {
                ;
            }
        }  
    }//GEN-LAST:event_uriButtonActionPerformed

    /**
     * @param args the command line arguments
     */
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel builtDatejLabel;
    private javax.swing.JLabel copyrightLabel;
    private javax.swing.JLabel mainTitleLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel subTitlejLabel2;
    private javax.swing.JLabel turtleHeadLabel;
    private javax.swing.JButton uriButton;
    // End of variables declaration//GEN-END:variables
}
