/*
 * Copyright (C) 2014 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package turtlemessenger;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */


public class TMBcasAddrSettingDialog extends javax.swing.JDialog {

    /**
     * Creates new form TMBcasAddrSettingDialog
     */
    
    byte[] broadcastAddress ;
    TMController controller ;
    
    public TMBcasAddrSettingDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        controller = (TMController) parent ;
        broadcastAddress = new byte[4] ;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        addressDigit0TextField = new javax.swing.JTextField();
        addressDigit1TextField = new javax.swing.JTextField();
        addressDigit2TextField = new javax.swing.JTextField();
        addressDigit3TextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setAlwaysOnTop(true);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtlemessenger/TMBundle"); // NOI18N
        jLabel1.setText(bundle.getString("BROADCASTADDRESS")); // NOI18N
        jLabel1.setToolTipText("<html>\n複数のインターフェースを持つマシンの場合、学生用ＰＣが接続されているサブネット<br>\nのブロードキャストアドレスを以下の欄に指定しなければなりません。<br>\n例えば、192 . 168 . 0 . 255 のような形式になります。<br>\n<br>\nインターフェースがひとつの場合は 255 . 255 . 255 . 255 （デフォルト値）を設定します。<br>\n</html>");

        addressDigit0TextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        addressDigit0TextField.setText("255");

        addressDigit1TextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        addressDigit1TextField.setText("255");

        addressDigit2TextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        addressDigit2TextField.setText("255");

        addressDigit3TextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        addressDigit3TextField.setText("255");

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 0, 18)); // NOI18N
        jLabel2.setText(" . ");

        jLabel3.setFont(new java.awt.Font("Lucida Grande", 0, 18)); // NOI18N
        jLabel3.setText(" . ");

        jLabel4.setFont(new java.awt.Font("Lucida Grande", 0, 18)); // NOI18N
        jLabel4.setText(" . ");

        jLabel5.setText(bundle.getString("TYPICALBCASADDR")); // NOI18N

        cancelButton.setText(bundle.getString("CANCEL")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText(bundle.getString("OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jLabel5, javax.swing.GroupLayout.PREFERRED_SIZE, 286, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(47, 47, 47))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(cancelButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(okButton)
                        .addGap(42, 42, 42))))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(41, 41, 41)
                        .addComponent(addressDigit0TextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(2, 2, 2)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(addressDigit1TextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3)
                        .addGap(1, 1, 1)
                        .addComponent(addressDigit2TextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel4)
                        .addGap(2, 2, 2)
                        .addComponent(addressDigit3TextField, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(29, 29, 29)
                        .addComponent(jLabel1)))
                .addContainerGap(62, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(39, 39, 39)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(addressDigit0TextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(addressDigit1TextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(addressDigit2TextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(addressDigit3TextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4))
                .addGap(18, 18, 18)
                .addComponent(jLabel5)
                .addGap(32, 32, 32)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap(16, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        setBroadcastAddress() ;
        dispose() ; 
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        dispose() ; 
    }//GEN-LAST:event_cancelButtonActionPerformed

    byte getDigit8(String str) {
        try {
            Integer.parseInt(str);
        } catch (NumberFormatException nfex) {
            return (byte) 255 ;
        }
        int n = Integer.valueOf(str) ;
        if (n<0) n=255 ;
        else if (n>255) n=255 ;
        return (byte) n ;
    }
    
    private void setBroadcastAddress() {
        broadcastAddress[0] = getDigit8(addressDigit0TextField.getText()) ;
        broadcastAddress[1] = getDigit8(addressDigit1TextField.getText()) ;
        broadcastAddress[2] = getDigit8(addressDigit2TextField.getText()) ;
        broadcastAddress[3] = getDigit8(addressDigit3TextField.getText()) ; 
        controller.changeBroadcastAddress(broadcastAddress) ;
    }

    public void setBroadcastAddressToTextField(byte[] bcas) {
        addressDigit0TextField.setText(String.valueOf((int) (bcas[0]&0xff) ));
        addressDigit1TextField.setText(String.valueOf((int) (bcas[1]&0xff) ));
        addressDigit2TextField.setText(String.valueOf((int) (bcas[2]&0xff) ));
        addressDigit3TextField.setText(String.valueOf((int) (bcas[3]&0xff) ));
    }
     
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField addressDigit0TextField;
    private javax.swing.JTextField addressDigit1TextField;
    private javax.swing.JTextField addressDigit2TextField;
    private javax.swing.JTextField addressDigit3TextField;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
}
