/* TurtleMessenger.js */
/* Yoshinori Hayakawa */
/* CITE, Tohoku university */
/* April 17, 2015  */


var voteCountData = null;

var httpObj = null;
var httpRequesting = false;
var httpRetryCnt = 0;

function createXMLHttpRequest(cbFunc) {
    var XMLhttpObject = null;
    try {
        XMLhttpObject = new XMLHttpRequest();
    }
    catch (e) {
        try {
            XMLhttpObject = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (e) {
            try {
                XMLhttpObject = new ActiveXObject("Microsoft.XMLHTTP");
            }
            catch (e) {
                return null;
            }
        }
    }
    if (XMLhttpObject)
        XMLhttpObject.onreadystatechange = cbFunc;
    return XMLhttpObject;
}

function loadTMData() {
    var data_path = "/";

    if (httpObj == null) {
        httpObj = createXMLHttpRequest(null);
    }

    if (httpRequesting) {
        httpRetryCnt++;
        if (httpRetryCnt > 100) {
            httpRequesting = false;
            return;
        } else {
            setTimeout(loadTMData(), 10);
        }
    }
    else if (httpObj) {
        data_path = "/vote";
        if (window.navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
            // alert("firefox") ;
            httpObj.onload =  httpObj.onerror = httpObj.onabort = function() {
                    httpCallback();
            };
        } else {
            httpObj.onreadystatechange = function() {
                if (httpObj.readyState == 4)
                    httpCallback();
                else 
                    httpRequesting = false;
            };
        }
        httpRequesting = true;
        httpRetryCnt = 0;
        httpObj.open("GET", data_path, false);
        httpObj.send(null);
    }
}

function httpCallback() {
    // if (httpObj.readyState == 4 && httpObj.status == 200) {
    if (httpObj.status == 200) {
        voteCountData = eval("(" + httpObj.responseText + ")");
        updateVoteCount();        
    }
    httpRequesting = false;
    // dumpData(type); /* for debug */
}



function removeChildNodesOf(node) {
    for (child in node.childNodes) {
        node.removeChild(child);
    }
}


function updateVoteCount() {
    var total = 0 ;
    for (var i = 0; i < voteCountData.length; i = i + 1) {
        total = total + voteCountData[i].count;
    }
    
    var ntotal = document.getElementById("ntotal") ;
    ntotal.innerHTML = String(total) ;
    
    //                      0        1       2     3        4        5       6     7        8      9 
    var chartColor = Array('black', 'brown','red','darkorange','gold','green','blue','purple','grey','lightgrey' ) ;
    
    for (var i = 0; i < voteCountData.length; i = i + 1) {
        var item = voteCountData[i].item;
        var count = voteCountData[i].count;
        var ncount = document.getElementById("ncount" + String(item)) ;
        var bar = document.getElementById("bar" + String(item)) ;
        ncount.innerHTML = String(count) ;
        ncount.style.color = chartColor[item] ;
        if (item==9) bar.style.color="darkgrey" ;
        else bar.style.color="lightgrey" ;
        // bar.style.color="darkblue" ;
        bar.style.backgroundColor=chartColor[item] ;
        // bar.style.backgroundColor="lightgreen" ;
        bar.style.display="block" ;
        bar.style.position="relative" ;
        if (count>0) {
            bar.innerHTML=String(Math.floor(count/total*100.0)) + "%" ;
        } else {
            bar.innerHTML="" ;
        }
        if (total>0) {
            bar.style.width=String(count/total*100) + "%" ;
        } else {
            bar.style.width="0%" ;
        }
    }
}


function startFetching() {
    loadTMData(); /* voting results */ 
    setTimeout("startFetching()", 2000); /* interval: 2 sec */
}
