/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;

public class TEDirListDialog
extends JDialog {
    File targetFile;
    private JTextArea directoryNameTextArea;
    private JTable fileListTable;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JButton okButton;

    public TEDirListDialog(Frame parent, boolean modal, File file) {
        super(parent, modal);
        this.initComponents();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.targetFile = file;
        this.fileListTable.setShowGrid(false);
        this.fileListTable.setIntercellSpacing(new Dimension(0, 0));
        this.fileListTable.setFillsViewportHeight(true);
        JTableHeader tabHeader = this.fileListTable.getTableHeader();
        tabHeader.setFont(new Font("SansSerif", 1, 12));
        TableColumnModel tcm = this.fileListTable.getColumnModel();
        FileTableCellRenderer cellRenderer = new FileTableCellRenderer();
        tcm.getColumn(0).setCellRenderer(cellRenderer);
        tcm.getColumn(1).setCellRenderer(cellRenderer);
        this.generateFileTable();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.directoryNameTextArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.fileListTable = new JTable();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("CONTENTS OF WORKING DIRECTORY"));
        this.setAlwaysOnTop(true);
        this.jLabel1.setText(bundle.getString("CURRENT DIRECTORY:"));
        this.directoryNameTextArea.setEditable(false);
        this.directoryNameTextArea.setColumns(20);
        this.directoryNameTextArea.setLineWrap(true);
        this.directoryNameTextArea.setRows(5);
        this.directoryNameTextArea.setWrapStyleWord(true);
        this.fileListTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Last modified"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fileListTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.fileListTable);
        this.fileListTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.fileListTable.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEDirListDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.okButton).add(37, 37, 37)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.okButton).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, this.directoryNameTextArea).add(2, this.jScrollPane2).add(layout.createSequentialGroup().add(this.jLabel1).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.directoryNameTextArea, -2, 35, -2).addPreferredGap(1).add(this.jScrollPane2, -1, 276, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void generateFileTable() {
        this.directoryNameTextArea.setText(this.targetFile.getParent());
        File dir = new File(this.targetFile.getParent());
        File[] files = dir.listFiles();
        Arrays.sort(files, new fileNameComparator());
        DefaultListModel fileListModel = new DefaultListModel();
        SimpleDateFormat simple = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        for (int i = 0; i < files.length; ++i) {
            String lastModified;
            String filename;
            if (files[i].getName().charAt(0) == '.') continue;
            if (files[i].isDirectory()) {
                filename = files[i].getName() + "/";
                lastModified = "";
            } else {
                filename = files[i].getName();
                long lm = files[i].lastModified();
                lastModified = simple.format(new Date(lm));
            }
            ((DefaultTableModel)this.fileListTable.getModel()).insertRow(0, new Object[]{filename, lastModified});
        }
        this.fileListTable.setAutoCreateRowSorter(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    class fileNameComparator
    implements Comparator {
        fileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            String fn1 = ((File)o1).getName();
            String fn2 = ((File)o2).getName();
            return fn2.compareTo(fn1);
        }
    }

    public class FileTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private Font font;

        public FileTableCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
            this.font = new Font("SansSerif", 0, 12);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                if (value.toString().equals(TEDirListDialog.this.targetFile.getName())) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLACK);
                }
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

