/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TEHelpWindow
extends JFrame {
    TEMainWindow mainWin;
    String homeUri;
    String prevUri;
    List<String> history;
    int backwdCnt;
    boolean tracingBack;
    private JButton backButton;
    private JEditorPane helpPane;
    private JButton homeButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JButton okButton;
    private JButton setButton;
    private JTextField uriTextField;

    public TEHelpWindow(TEMainWindow win) {
        this.initComponents();
        this.mainWin = win;
        this.setLocationRelativeTo(win);
        this.helpPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.helpPane.setFont(new Font("SansSerif", 0, 12));
        this.helpPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String url = e.getURL().toString();
                TEHelpWindow.this.accessUri(url, true);
            }
        });
        this.history = new ArrayList<String>();
        this.backwdCnt = 0;
        this.tracingBack = false;
        this.homeUri = this.prevUri = this.mainWin.helpURI;
        this.uriTextField.setText(this.homeUri);
        this.accessUri(this.homeUri, true);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.helpPane = new JEditorPane();
        this.uriTextField = new JTextField();
        this.setButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.homeButton = new JButton();
        this.backButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("TURTLEEDIT HELP"));
        this.helpPane.setEditable(false);
        this.jScrollPane2.setViewportView(this.helpPane);
        this.uriTextField.setText("jTextField1");
        this.setButton.setText(bundle.getString("SET"));
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEHelpWindow.this.setButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("URI");
        this.homeButton.setText(bundle.getString("HOME"));
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEHelpWindow.this.homeButtonActionPerformed(evt);
            }
        });
        this.backButton.setText(bundle.getString("BACK"));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEHelpWindow.this.backButtonActionPerformed(evt);
            }
        });
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEHelpWindow.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.homeButton).addPreferredGap(0).add(this.backButton).addPreferredGap(0).add(this.okButton).add(22, 22, 22)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().add(0, 8, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(3).add(this.homeButton).add(this.backButton).add(this.okButton))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(this.jLabel1).addPreferredGap(0).add(this.uriTextField).addPreferredGap(0).add(this.setButton).add(69, 69, 69)).add(2, this.jScrollPane2, -1, 651, Short.MAX_VALUE).add(2, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.uriTextField, -2, -1, -2).add(this.setButton).add(this.jLabel1)).addPreferredGap(0).add(this.jScrollPane2, -1, 566, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void accessUri(String uri, boolean viaHyperLink) {
        try {
            this.helpPane.setPage(uri);
        }
        catch (IOException ex) {
            return;
        }
        if (this.tracingBack && viaHyperLink) {
            this.history.add(this.prevUri);
            this.tracingBack = false;
            this.backwdCnt = 0;
        }
        if (!this.tracingBack) {
            this.history.add(uri);
        }
        this.prevUri = uri;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        String uri;
        ++this.backwdCnt;
        if (this.history.size() - this.backwdCnt - 1 >= 0) {
            uri = this.history.get(this.history.size() - this.backwdCnt - 1);
        } else {
            uri = this.history.get(0);
            this.backwdCnt = this.history.size();
        }
        this.tracingBack = true;
        this.accessUri(uri, false);
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        this.accessUri(this.homeUri, true);
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        String uri;
        this.homeUri = uri = this.uriTextField.getText();
        this.mainWin.setHelpURI(uri);
    }
}

