/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TESettingDialog
extends JDialog {
    public ArrayList presets;
    TEMainWindow mainWindow;
    String charCode;
    String preferredFontName;
    int preferredFontSize;
    private ButtonGroup characterSetButtonGroup;
    private JTextField compileCommandTextField;
    private JRadioButton eucjpRadioButton;
    private JTextField execCommandTextField;
    private JTextField execPathTextField;
    private JComboBox fontComboBox;
    private JPanel fontPanel;
    private JComboBox fontSizeComboBox;
    private JCheckBox interpreterModeCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox presetComboBox;
    private JButton settingsCancelButton;
    private JButton settingsOKButton;
    private JRadioButton sjisRadioButton;
    private JCheckBox tfAutoLaunchCheckBox;
    private JButton tfSearchButton;
    private JTextField turtleFieldPathTextField;
    private JRadioButton utf8RadioButton;

    public TESettingDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mainWindow = (TEMainWindow)parent;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.initPresets();
        this.setPresetsComboBox();
        this.initFontComboBox();
    }

    public void initPresets() {
        this.presets = new ArrayList();
        this.presets.add(new PresetSetting("---", "", "", false));
        this.presets.add(new PresetSetting("C", "cc %f -lm", "./a.out", false));
        this.presets.add(new PresetSetting("C++", "c++ %f -lm", "./a.out", false));
        this.presets.add(new PresetSetting("Java", "javac %f", "java %b", false));
        this.presets.add(new PresetSetting("Ruby", "", "ruby %f", true));
        this.presets.add(new PresetSetting("Python", "", "python -u %f", true));
        this.presets.add(new PresetSetting("LaTeX(DVI)", "platex %f", "pxdvi %b", false));
        this.presets.add(new PresetSetting("LaTeX(PDF)", "platex %f", "bash -c dvipdfmx%s%b.dvi&&acroread%s%b.pdf", false));
    }

    private void initComponents() {
        this.characterSetButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.compileCommandTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.execCommandTextField = new JTextField();
        this.execPathTextField = new JTextField();
        this.settingsCancelButton = new JButton();
        this.settingsOKButton = new JButton();
        this.presetComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.fontPanel = new JPanel();
        this.fontComboBox = new JComboBox();
        this.fontSizeComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel11 = new JLabel();
        this.turtleFieldPathTextField = new JTextField();
        this.tfAutoLaunchCheckBox = new JCheckBox();
        this.tfSearchButton = new JButton();
        this.interpreterModeCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.sjisRadioButton = new JRadioButton();
        this.eucjpRadioButton = new JRadioButton();
        this.utf8RadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("SETTING FOR COMPILATION AND EXECUTION"));
        this.setAlwaysOnTop(true);
        this.setPreferredSize(new Dimension(650, 490));
        this.setResizable(false);
        this.jLabel1.setText(bundle.getString("COMPILE COMMAND"));
        this.compileCommandTextField.setText("gcc");
        this.jLabel2.setText(bundle.getString("COMMAND FOR EXECUTION"));
        this.jLabel4.setText(bundle.getString("ADDITIONAL EXEC PATH"));
        this.jLabel5.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel5.setText("%f :");
        this.jLabel6.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText(bundle.getString("FILE NAME"));
        this.jLabel7.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel7.setText("%b :");
        this.jLabel8.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText(bundle.getString("BASE NAME"));
        this.jLabel9.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel9.setText(" %d :");
        this.jLabel10.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel10.setHorizontalAlignment(2);
        this.jLabel10.setText(bundle.getString("DIRECTORY"));
        this.execCommandTextField.setText("a.out");
        this.execPathTextField.setText("/opt/local/bin");
        this.settingsCancelButton.setText(bundle.getString("CANCEL"));
        this.settingsCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.settingsCancelButtonActionPerformed(evt);
            }
        });
        this.settingsOKButton.setText(bundle.getString("OK"));
        this.settingsOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.settingsOKButtonActionPerformed(evt);
            }
        });
        this.presetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.presetComboBoxActionPerformed(evt);
            }
        });
        this.fontPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("PREFERRED FONT")));
        this.fontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.fontComboBoxActionPerformed(evt);
            }
        });
        this.fontSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"12", "14", "16", "18", "24"}));
        this.fontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.fontSizeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout fontPanelLayout = new GroupLayout(this.fontPanel);
        this.fontPanel.setLayout(fontPanelLayout);
        fontPanelLayout.setHorizontalGroup(fontPanelLayout.createParallelGroup(1).add(fontPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.fontComboBox, -2, 170, -2).addPreferredGap(0).add(this.fontSizeComboBox, -2, -1, -2).addContainerGap()));
        fontPanelLayout.setVerticalGroup(fontPanelLayout.createParallelGroup(1).add(fontPanelLayout.createSequentialGroup().addContainerGap().add(fontPanelLayout.createParallelGroup(3).add(this.fontComboBox, -2, -1, -2).add(this.fontSizeComboBox, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.fontPanel, -2, -1, -2).add(12, 12, 12)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().add(this.fontPanel, -2, -1, -2).add(0, 0, Short.MAX_VALUE)));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(bundle.getString("PRESET CONFIGURATIONS"));
        this.jLabel11.setHorizontalAlignment(11);
        this.jLabel11.setText(bundle.getString("PATH TO TURTLE FIELD"));
        this.turtleFieldPathTextField.setText("/opt/local/bin/tfield-linux");
        this.tfAutoLaunchCheckBox.setText(bundle.getString("AUTO LAUNCH"));
        this.tfSearchButton.setText("...");
        this.tfSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.tfSearchButtonActionPerformed(evt);
            }
        });
        this.interpreterModeCheckBox.setText(bundle.getString("INTERPRETER"));
        this.interpreterModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESettingDialog.this.interpreterModeCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("CHARACTER CODE"), 1, 0));
        this.characterSetButtonGroup.add(this.sjisRadioButton);
        this.sjisRadioButton.setText("Shift_JIS");
        this.characterSetButtonGroup.add(this.eucjpRadioButton);
        this.eucjpRadioButton.setText("EUC-JP");
        this.characterSetButtonGroup.add(this.utf8RadioButton);
        this.utf8RadioButton.setSelected(true);
        this.utf8RadioButton.setText("UTF-8");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(this.utf8RadioButton).addPreferredGap(0).add(this.eucjpRadioButton).addPreferredGap(1).add(this.sjisRadioButton).addContainerGap(21, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.utf8RadioButton).add(this.eucjpRadioButton).add(this.sjisRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(19, 19, 19).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2)).add(layout.createSequentialGroup().add(58, 58, 58).add(this.jLabel11, -2, 167, -2)).add(layout.createSequentialGroup().add(427, 427, 427).add(this.tfAutoLaunchCheckBox)))).add(layout.createSequentialGroup().add(19, 19, 19).add(layout.createParallelGroup(1).add(2, this.jLabel4, -2, 150, -2).add(layout.createParallelGroup(1, false).add(this.jLabel2, -1, 158, Short.MAX_VALUE).add(this.jLabel1, -1, -1, Short.MAX_VALUE))).add(18, 18, 18).add(layout.createParallelGroup(1).add(2, this.compileCommandTextField, -2, 406, -2).add(2, this.execCommandTextField, -2, 406, -2).add(2, this.execPathTextField, -2, 402, -2).add(2, layout.createSequentialGroup().add(this.turtleFieldPathTextField, -2, 291, -2).addPreferredGap(0).add(this.tfSearchButton, -2, 43, -2)).add(2, layout.createSequentialGroup().add(this.jLabel3, -2, 135, -2).add(41, 41, 41).add(this.presetComboBox, -2, 150, -2)))).add(layout.createSequentialGroup().add(407, 407, 407).add(this.settingsCancelButton).add(18, 18, 18).add(this.settingsOKButton)).add(layout.createSequentialGroup().add(145, 145, 145).add(this.jLabel5).addPreferredGap(0).add(this.jLabel6, -2, 85, -2).add(18, 18, 18).add(this.jLabel7).addPreferredGap(0).add(this.jLabel8, -2, 134, -2).addPreferredGap(1).add(this.jLabel9).addPreferredGap(0).add(this.jLabel10, -2, 99, -2))).add(0, 19, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.interpreterModeCheckBox).add(48, 48, 48)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(this.interpreterModeCheckBox).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel1, -2, 16, -2).add(this.compileCommandTextField, -2, -1, -2)).add(12, 12, 12).add(layout.createParallelGroup(3).add(this.jLabel2, -2, 28, -2).add(this.execCommandTextField, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel5).add(this.jLabel6).add(this.jLabel7).add(this.jLabel8).add(this.jLabel9).add(this.jLabel10, -2, 15, -2)).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.execPathTextField, -2, -1, -2).add(this.jLabel4)).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.presetComboBox, -2, -1, -2).add(this.jLabel3)).add(17, 17, 17).add(layout.createParallelGroup(3).add(this.jLabel11).add(this.tfSearchButton).add(this.turtleFieldPathTextField, -2, -1, -2)).addPreferredGap(0).add(this.tfAutoLaunchCheckBox).add(20, 20, 20).add(layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(this.jPanel1, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add(layout.createParallelGroup(1).add(this.settingsOKButton).add(this.settingsCancelButton)).addContainerGap(49, Short.MAX_VALUE)));
        this.pack();
    }

    private void settingsCancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void settingsOKButtonActionPerformed(ActionEvent evt) {
        this.mainWindow.setInterpreterMode(this.interpreterModeCheckBox.isSelected());
        this.mainWindow.setCompileCommand(this.compileCommandTextField.getText());
        this.mainWindow.setExecCommand(this.execCommandTextField.getText());
        this.mainWindow.setExecPath(this.execPathTextField.getText());
        this.mainWindow.setCharCode(this.selectedCharCode());
        this.mainWindow.setPreferredFont(this.preferredFontName, this.preferredFontSize);
        this.mainWindow.setTurtleField(this.turtleFieldPathTextField.getText(), this.tfAutoLaunchCheckBox.isSelected());
        this.mainWindow.savePreferences();
        this.dispose();
    }

    private void presetComboBoxActionPerformed(ActionEvent evt) {
        int index = this.presetComboBox.getSelectedIndex();
        if (index > 0 && index < this.presets.size()) {
            PresetSetting p = (PresetSetting)this.presets.get(index);
            this.compileCommandTextField.setText(p.compileCommand);
            this.execCommandTextField.setText(p.execCommand);
            this.interpreterModeCheckBox.setSelected(p.isInterpreter);
            this.compileCommandTextField.setEnabled(p.isInterpreter == false);
        }
    }

    private void fontComboBoxActionPerformed(ActionEvent evt) {
        this.preferredFontName = (String)this.fontComboBox.getSelectedItem();
    }

    private void tfSearchButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooser.showOpenDialog(this) == 0) {
            File tfFile = fileChooser.getSelectedFile();
            try {
                this.turtleFieldPathTextField.setText(tfFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void fontSizeComboBoxActionPerformed(ActionEvent evt) {
        this.preferredFontSize = Integer.valueOf((String)this.fontSizeComboBox.getSelectedItem());
    }

    private void interpreterModeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.interpreterModeCheckBox.isSelected()) {
            this.compileCommandTextField.setEnabled(false);
        } else {
            this.compileCommandTextField.setEnabled(true);
        }
    }

    public void initFontComboBox() {
        int i;
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> jaFontNames = new ArrayList<String>();
        for (i = 0; i < fonts.length; ++i) {
            Font testFont = new Font(fonts[i], 0, 14);
            if (!testFont.canDisplay('\u3042')) continue;
            jaFontNames.add(fonts[i]);
        }
        for (i = 0; i < jaFontNames.size(); ++i) {
            this.fontComboBox.addItem(jaFontNames.get(i));
        }
    }

    public void setPreferredFontName(String s) {
        this.preferredFontName = s;
        boolean found = false;
        for (int i = 0; i < this.fontComboBox.getItemCount(); ++i) {
            if (!this.fontComboBox.getItemAt(i).equals(s)) continue;
            this.fontComboBox.setSelectedIndex(i);
            return;
        }
        if (!found) {
            this.fontComboBox.insertItemAt(s, 0);
            this.fontComboBox.setSelectedIndex(0);
        }
    }

    public void setPreferredFontSize(int size) {
        this.preferredFontSize = size;
        boolean found = false;
        for (int i = 0; i < this.fontSizeComboBox.getItemCount(); ++i) {
            if (Integer.valueOf((String)this.fontSizeComboBox.getItemAt(i)) != size) continue;
            this.fontSizeComboBox.setSelectedIndex(i);
            return;
        }
        if (!found) {
            this.fontSizeComboBox.setSelectedIndex(1);
        }
    }

    public void setCharCodeRadioButton(String code) {
        if (code.equalsIgnoreCase("UTF-8")) {
            this.utf8RadioButton.setSelected(true);
        } else if (code.equalsIgnoreCase("EUC_JP")) {
            this.eucjpRadioButton.setSelected(true);
        } else if (code.equalsIgnoreCase("Shift_JIS")) {
            this.sjisRadioButton.setSelected(true);
        }
    }

    public String selectedCharCode() {
        if (this.utf8RadioButton.isSelected()) {
            return "UTF-8";
        }
        if (this.eucjpRadioButton.isSelected()) {
            return "EUC_JP";
        }
        if (this.sjisRadioButton.isSelected()) {
            return "Shift_JIS";
        }
        return "UTF-8";
    }

    public void setCompileCommandTextField(String s) {
        this.compileCommandTextField.setText(s);
    }

    public void setExecCommandTextField(String s) {
        this.execCommandTextField.setText(s);
    }

    public void setExecPathTextField(String s) {
        this.execPathTextField.setText(s);
    }

    public void setPresetsComboBox() {
        this.presetComboBox.removeAllItems();
        for (int i = 0; i < this.presets.size(); ++i) {
            PresetSetting p = (PresetSetting)this.presets.get(i);
            this.presetComboBox.addItem(p.name);
        }
    }

    public void setTurtleFieldPathName(String path) {
        this.turtleFieldPathTextField.setText(path);
    }

    public void setTurtleFieldAutoLaunch(boolean mode) {
        this.tfAutoLaunchCheckBox.setSelected(mode);
    }

    public void setInterpreterMode(boolean mode) {
        this.interpreterModeCheckBox.setSelected(mode);
        this.compileCommandTextField.setEnabled(!mode);
    }

    public class PresetSetting {
        String name;
        String compileCommand;
        String execCommand;
        Boolean isInterpreter;

        public PresetSetting(String nm, String ccmd, String ecmd, Boolean imode) {
            this.name = nm;
            this.compileCommand = ccmd;
            this.execCommand = ecmd;
            this.isInterpreter = imode;
        }
    }
}

