/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import turtleedit.TEMainWindow;

public class TEConsolePane
extends JTextPane {
    public long lastFocusedTime = 0L;
    ReadOutThread readThr = null;
    OutputStreamWriter outWriter = null;
    String charCode = "UTF-8";
    DummyDocumentFilter dmyDocFilter;
    Process runningProcess = null;
    boolean silentMode;
    boolean terminateRdr;
    boolean runningRdr = false;
    private final Object swingIsReadyLock = new Object();
    boolean swingIsReady = false;
    TEMainWindow controller = null;
    public int TAB_WIDTH = 36;

    TEConsolePane() {
        this.setEditorKit(new ConsoleEditorKit());
        this.setCaret(new ConsoleCaret());
        this.getCaret().setVisible(true);
        Font consolefont = new Font("Monospaced", 0, 12);
        this.setFont(consolefont);
        Canvas dummyCanvas = new Canvas();
        FontMetrics fm = dummyCanvas.getFontMetrics(consolefont);
        this.TAB_WIDTH = (int)((double)fm.stringWidth("0") * 4.0);
        this.setEditable(true);
        Document doc = this.getDocument();
        this.dmyDocFilter = new DummyDocumentFilter();
        ((AbstractDocument)doc).setDocumentFilter(this.dmyDocFilter);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent fe) {
                TEConsolePane.this.lastFocusedTime = System.currentTimeMillis();
            }

            @Override
            public void focusGained(FocusEvent fe) {
                TEConsolePane.this.lastFocusedTime = System.currentTimeMillis();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(68, 2), "none");
        this.getInputMap().put(KeyStroke.getKeyStroke(69, 2), "none");
        this.initKeyListener();
    }

    public void setController(TEMainWindow win) {
        this.controller = win;
    }

    private void invokeDummyEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TEConsolePane.this.swingIsReadyLock;
                synchronized (object) {
                    TEConsolePane.this.swingIsReady = true;
                }
            }
        });
    }

    private void initKeyListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ev) {
            }

            @Override
            public void keyReleased(KeyEvent ev) {
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                char c = ev.getKeyChar();
                if (TEConsolePane.this.outWriter != null) {
                    try {
                        if (c == '\u0004' || c == '\b') {
                            TEConsolePane.this.outWriter.write(c);
                            TEConsolePane.this.outWriter.flush();
                        }
                        if (c == '\u0005') {
                            TEConsolePane.this.outWriter.flush();
                            TEConsolePane.this.outWriter.close();
                            TEConsolePane.this.outWriter = null;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.addKeyListener(keyListener);
    }

    public synchronized void clearAndSetText(String text) {
        this.dmyDocFilter.setMutable(true);
        this.setText(text);
        this.dmyDocFilter.setMutable(false);
    }

    public synchronized void appendText(String text) {
        Document doc = this.getDocument();
        this.dmyDocFilter.setMutable(true);
        try {
            doc.insertString(doc.getLength(), text, null);
            this.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.dmyDocFilter.setMutable(false);
    }

    public void handleProcess(Process proc, String code, boolean sflag) {
        this.runningProcess = proc;
        this.charCode = code;
        this.silentMode = sflag;
        this.readThr = new ReadOutThread(proc);
        this.terminateRdr = false;
        try {
            this.outWriter = new OutputStreamWriter(proc.getOutputStream(), this.charCode);
        }
        catch (UnsupportedEncodingException ex) {
            this.outWriter = new OutputStreamWriter(proc.getOutputStream());
        }
        this.readThr.start();
        this.runningRdr = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateRunningThread() {
        if (this.readThr != null && this.readThr.isAlive()) {
            this.silentMode = true;
            this.terminateRdr = true;
        }
        Object object = this.swingIsReadyLock;
        synchronized (object) {
            this.swingIsReady = true;
        }
        while (this.runningRdr) {
            try {
                Thread.sleep(0L, 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runningProcess = null;
        this.outWriter = null;
    }

    public void writeStringToRunningProcess(String text, boolean closeFlag) {
        if (this.outWriter != null) {
            try {
                this.outWriter.write(text, 0, text.length());
                if (closeFlag) {
                    this.outWriter.close();
                    this.outWriter = null;
                } else {
                    this.outWriter.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ConsoleParagraphView
    extends ParagraphView {
        public ConsoleParagraphView(Element e) {
            super(e);
        }

        @Override
        public float nextTabStop(float x, int tabOffset) {
            TabSet tabs = this.getTabSet();
            if (tabs == null) {
                return this.getTabBase() + (float)(((int)((x - this.getTabBase()) / (float)TEConsolePane.this.TAB_WIDTH) + 1) * TEConsolePane.this.TAB_WIDTH);
            }
            return super.nextTabStop(x, tabOffset);
        }
    }

    class ConsoleViewFactory
    implements ViewFactory {
        ConsoleViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ConsoleParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class ConsoleEditorKit
    extends StyledEditorKit {
        ConsoleEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new ConsoleViewFactory();
        }
    }

    class ConsoleCaret
    extends DefaultCaret {
        ConsoleCaret() {
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (r == null) {
                return;
            }
            this.x = r.x;
            this.y = r.y;
            this.height = r.height;
            if (this.width <= 0) {
                this.width = this.getComponent().getWidth();
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            char dotChar;
            JTextComponent comp = this.getComponent();
            if (comp == null) {
                return;
            }
            int dot = this.getDot();
            Rectangle r = null;
            try {
                r = comp.modelToView(dot);
                if (r == null) {
                    return;
                }
                dotChar = comp.getText(dot, 1).charAt(0);
            }
            catch (BadLocationException e) {
                return;
            }
            if (this.x != r.x || this.y != r.y) {
                this.repaint();
                this.x = r.x;
                this.y = r.y;
                this.height = r.height;
            }
            if (dotChar == '\n') {
                if (this.isVisible()) {
                    g.setColor(Color.RED);
                    g.fillRect(r.x, r.y, this.width, r.height);
                }
                this.width = r.height / 2;
                return;
            }
            if (dotChar == '\t') {
                try {
                    Rectangle nextr = comp.modelToView(dot + 1);
                    if (r.y == nextr.y && r.x < nextr.x) {
                        this.width = nextr.x - r.x;
                        if (this.isVisible()) {
                            g.setColor(Color.PINK);
                            g.fillRect(r.x, r.y, this.width, r.height);
                        }
                        return;
                    }
                    dotChar = ' ';
                }
                catch (BadLocationException e) {
                    dotChar = ' ';
                }
            }
            this.width = g.getFontMetrics().charWidth(dotChar);
            if (this.isVisible()) {
                g.setColor(Color.RED);
                g.drawRect(r.x, r.y, this.width - 1, r.height - 1);
            }
        }
    }

    class DummyDocumentFilter
    extends DocumentFilter {
        boolean mutable = false;

        DummyDocumentFilter() {
        }

        @Override
        public synchronized void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (TEConsolePane.this.outWriter != null || this.mutable) {
                super.insertString(fb, offset, string, attr);
            } else {
                super.insertString(fb, offset, "", attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attrs) throws BadLocationException {
            if (TEConsolePane.this.outWriter != null) {
                try {
                    TEConsolePane.this.outWriter.write(string);
                    TEConsolePane.this.outWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                super.replace(fb, offset, length, string, attrs);
            } else if (this.mutable) {
                super.replace(fb, offset, length, string, attrs);
            } else {
                super.replace(fb, offset, 0, "", attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (TEConsolePane.this.outWriter != null || this.mutable) {
                super.remove(fb, offset, length);
            } else {
                super.remove(fb, offset, 0);
            }
        }

        public void setMutable(boolean flag) {
            this.mutable = flag;
        }
    }

    class ReadOutThread
    extends Thread {
        private static final int MAX_LENGTH = 0x100000;
        private static final int CBUFLEN = 256;
        private InputStreamReader rdr;
        private Process assocProc;
        private int length;

        public ReadOutThread(Process proc) {
            try {
                this.rdr = new InputStreamReader(proc.getInputStream(), TEConsolePane.this.charCode);
            }
            catch (UnsupportedEncodingException ex) {
                this.rdr = new InputStreamReader(proc.getInputStream());
            }
            this.assocProc = proc;
            this.length = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Document doc = TEConsolePane.this.getDocument();
            int c = 0;
            int tick = 1;
            char[] cbuf = new char[256];
            try {
                while (!TEConsolePane.this.terminateRdr) {
                    if (!this.rdr.ready()) {
                        try {
                            this.assocProc.exitValue();
                            break;
                        }
                        catch (IllegalThreadStateException e) {
                            ReadOutThread.sleep(0L, 1000);
                            continue;
                        }
                    }
                    c = this.rdr.read(cbuf, 0, 256);
                    if (c <= 0) break;
                    if (this.length < 0x100000) {
                        Object e = TEConsolePane.this.swingIsReadyLock;
                        synchronized (e) {
                            TEConsolePane.this.swingIsReady = false;
                        }
                        TEConsolePane.this.invokeDummyEvent();
                        int n = tick = tick / 2 > 0 ? tick / 2 : 1;
                        while (!TEConsolePane.this.swingIsReady) {
                            ReadOutThread.sleep(tick);
                            if ((tick *= 2) <= 160) continue;
                            tick = 160;
                        }
                        this.length += c;
                        if (c == 256) {
                            TEConsolePane.this.appendText(String.valueOf(cbuf));
                            continue;
                        }
                        for (int i = 0; i < c; ++i) {
                            TEConsolePane.this.appendText(String.valueOf(cbuf[i]));
                        }
                        continue;
                    }
                    TEConsolePane.this.appendText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("TOO MUCH OUTPUT"));
                    break;
                }
            }
            catch (IOException i) {
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            try {
                this.rdr.close();
                if (TEConsolePane.this.outWriter != null) {
                    TEConsolePane.this.outWriter.close();
                }
            }
            catch (IOException i) {
                // empty catch block
            }
            TEConsolePane.this.outWriter = null;
            try {
                int code = -1;
                try {
                    code = this.assocProc.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    this.assocProc.destroy();
                }
                ReadOutThread.sleep(0L, 1000);
                if (!TEConsolePane.this.silentMode) {
                    if (code == 0) {
                        TEConsolePane.this.appendText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("TERMINATED NORMALLY"));
                    } else {
                        TEConsolePane.this.appendText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("EXITED WITH CODE") + code + "\n");
                    }
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                TEConsolePane.this.setCaretPosition(doc.getLength());
            }
            TEConsolePane.this.runningRdr = false;
            if (TEConsolePane.this.controller != null) {
                TEConsolePane.this.controller.processWasDone();
            }
        }
    }
}

