/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jdesktop.layout.GroupLayout;

public class TEHelpDialog
extends JDialog {
    private JEditorPane helpEditorPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton okButton;

    public TEHelpDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.helpEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.helpEditorPane.setFont(new Font("SansSerif", 0, 14));
        this.helpEditorPane.setContentType("text/html; charset=UTF-8");
        Locale loc = Locale.getDefault();
        URL uri = loc.getCountry().equalsIgnoreCase("JP") ? this.getClass().getResource("html/help-ja.html") : this.getClass().getResource("html/help-en.html");
        try {
            this.helpEditorPane.setPage(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.helpEditorPane.addHyperlinkListener(new Hyperactive());
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.helpEditorPane = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.helpEditorPane.setEditable(false);
        this.helpEditorPane.setMinimumSize(new Dimension(400, 300));
        this.jScrollPane1.setViewportView(this.helpEditorPane);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEHelpDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.okButton).add(20, 20, 20)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.okButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(this.jScrollPane1, -1, 695, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jScrollPane1, -1, 465, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanel1, -1, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.browse(e.getURL().toURI());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

