/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TEReplaceDialog
extends JDialog {
    String regexString;
    String replaceString;
    TEMainWindow mainWindow;
    boolean dotAllFlag;
    private JButton CancelButton;
    private JButton OkButton;
    private JCheckBox dotAllCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea regexTextArea;
    private JTextArea replaceToTextArea;

    public TEReplaceDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.mainWindow = (TEMainWindow)parent;
        this.dotAllFlag = false;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        TEReplaceDialog.installEscapeCloseOperation(this);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "com.spodding.tackline.dispatch:WINDOW_CLOSING");
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.regexTextArea = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.replaceToTextArea = new JTextArea();
        this.CancelButton = new JButton();
        this.OkButton = new JButton();
        this.dotAllCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("REPLACE"));
        this.jLabel1.setText(bundle.getString("REGULAR EXPRESSION:"));
        this.regexTextArea.setColumns(20);
        this.regexTextArea.setLineWrap(true);
        this.regexTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.regexTextArea);
        this.jLabel2.setText(bundle.getString("REPLACE TO"));
        this.replaceToTextArea.setColumns(20);
        this.replaceToTextArea.setLineWrap(true);
        this.replaceToTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.replaceToTextArea);
        this.CancelButton.setText(bundle.getString("CANCEL"));
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEReplaceDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.OkButton.setText(bundle.getString("OK"));
        this.OkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEReplaceDialog.this.OkButtonActionPerformed(evt);
            }
        });
        this.dotAllCheckBox.setText(bundle.getString("DOT ALL"));
        this.dotAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEReplaceDialog.this.dotAllCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Lucida Grande", 0, 10));
        this.jLabel3.setText(bundle.getString("NTH_MATCHED_GROUP"));
        this.jLabel3.setHorizontalTextPosition(4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().addContainerGap().add(this.jScrollPane2)).add(layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1)).add(1, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.CancelButton).add(18, 18, 18).add(this.OkButton)).add(1, layout.createSequentialGroup().add(16, 16, 16).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jLabel1, -1, 262, Short.MAX_VALUE).addPreferredGap(0).add(this.dotAllCheckBox)).add(layout.createSequentialGroup().add(this.jLabel2, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add(this.jLabel3, -2, 157, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(11, 11, 11).add(layout.createParallelGroup(3).add(this.jLabel1).add(this.dotAllCheckBox)).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel3, -2, 16, -2)).addPreferredGap(0).add(this.jScrollPane2, -2, 84, -2).addPreferredGap(0, 18, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.CancelButton).add(this.OkButton)).add(18, 18, 18)));
        this.pack();
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.regexString = this.regexTextArea.getText();
        this.replaceString = this.replaceToTextArea.getText();
        if (!this.isCorrectRegex(this.regexString)) {
            return;
        }
        this.dotAllFlag = this.dotAllCheckBox.isSelected();
        this.mainWindow.performReplacement(this.regexString, this.replaceString, this.dotAllFlag);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void dotAllCheckBoxActionPerformed(ActionEvent evt) {
    }

    private boolean isCorrectRegex(String str) {
        if (str.length() == 0) {
            return false;
        }
        try {
            Pattern pattern = Pattern.compile(str);
        }
        catch (PatternSyntaxException e) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("ERROR FOUND IN THE REGULAR EXPRESSION"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2);
            return false;
        }
        return true;
    }
}

