/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.UndoManager;

public class TEEditorPane
extends JEditorPane {
    public long lastFocusedTime = 0L;
    private UndoManager undoMgr = new UndoManager();
    private boolean contentIsModified = false;
    private final String TAB = "    ";
    private int findIndex;
    private String lastFoundStr;
    private boolean lastTimeIgnoreCase;
    private Font lineNumFont;
    private int lineNumFontDescent;
    public short LINE_NUMBER_WIDTH = (short)30;
    public int TAB_WIDTH = 36;
    public int prevPairedParenthesesPosition = -1;
    public int nextPairedParenthesesPosition = -1;

    TEEditorPane() {
        this.setContentType("text/plain");
        this.setEditorKit(new NumberedEditorKit());
        this.setCaret(new EditorCaret());
        this.getCaret().setBlinkRate(800);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                boolean prevChar = false;
                boolean nextChar = false;
                int dot = e.getDot();
                TEEditorPane.this.checkPairOfParentheses(dot);
            }
        });
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFont(new Font("Monospaced", 0, 14));
        this.lineNumFont = new Font("Monospaced", 0, 14);
        this.findIndex = 0;
        this.lastTimeIgnoreCase = false;
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent ev) {
                TEEditorPane.this.undoMgr.addEdit(ev.getEdit());
                TEEditorPane.this.contentIsModified = true;
            }
        });
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                TEEditorPane.this.contentIsModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                TEEditorPane.this.contentIsModified = true;
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent fe) {
                TEEditorPane.this.lastFocusedTime = System.currentTimeMillis();
            }

            @Override
            public void focusGained(FocusEvent fe) {
                TEEditorPane.this.lastFocusedTime = System.currentTimeMillis();
            }
        });
        PopupMenuMouseListener popup = new PopupMenuMouseListener();
        this.addMouseListener(popup);
    }

    public void setTextFont(Font font) {
        this.setFont(font);
        Canvas dummyCanvas = new Canvas();
        FontMetrics fm = dummyCanvas.getFontMetrics(font);
        this.TAB_WIDTH = (int)((double)fm.stringWidth("0") * 4.0);
    }

    public void setLineNumFont(Font font) {
        this.lineNumFont = font;
        Canvas dummyCanvas = new Canvas();
        FontMetrics fm = dummyCanvas.getFontMetrics(font);
        int width = fm.stringWidth("0");
        this.lineNumFontDescent = fm.getDescent();
        this.LINE_NUMBER_WIDTH = (short)((double)width * 4.0 * 1.15);
    }

    public void resetUndoManager() {
        this.undoMgr.discardAllEdits();
    }

    public void undo() {
        if (this.undoMgr.canUndo()) {
            this.undoMgr.undo();
        }
    }

    public void redo() {
        if (this.undoMgr.canRedo()) {
            this.undoMgr.redo();
        }
    }

    public void pasteString(String str) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        Document doc = this.getDocument();
        try {
            if (end - start > 0) {
                doc.remove(start, end);
                doc.insertString(start, str, null);
            } else {
                doc.insertString(this.getCaretPosition(), str, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void contentIsSaved() {
        this.contentIsModified = false;
    }

    public boolean isContentModified() {
        return this.contentIsModified;
    }

    private boolean isMatchedStringInDocument(Document doc, int index, String str, boolean ignoreCase) {
        try {
            String match = doc.getText(index, str.length());
            if (ignoreCase ? str.equalsIgnoreCase(match) : str.equals(match)) {
                DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
                this.getHighlighter().addHighlight(index, index + str.length(), highlightPainter);
                this.findIndex = index;
                this.lastFoundStr = str;
                this.lastTimeIgnoreCase = ignoreCase;
                return true;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean matchAndHilightString(String str, boolean ignoreCase, boolean searchInReverseDirection) {
        Document doc = this.getDocument();
        if (!searchInReverseDirection) {
            for (int i = this.findIndex; i <= doc.getLength() - str.length(); ++i) {
                if (!this.isMatchedStringInDocument(doc, i, str, ignoreCase)) continue;
                this.setCaretPosition(i + str.length());
                return true;
            }
        } else {
            for (int i = this.findIndex; i >= 0; --i) {
                if (!this.isMatchedStringInDocument(doc, i, str, ignoreCase)) continue;
                this.setCaretPosition(i);
                return true;
            }
        }
        this.lastFoundStr = "";
        this.lastTimeIgnoreCase = ignoreCase;
        this.removeHighlight();
        return false;
    }

    public void removeHighlight() {
        this.getHighlighter().removeAllHighlights();
    }

    public boolean findString(String findStr, boolean ignoreCase) {
        this.findIndex = 0;
        this.removeHighlight();
        return this.matchAndHilightString(findStr, ignoreCase, false);
    }

    public boolean findNextString() {
        boolean found = false;
        this.removeHighlight();
        if (this.lastFoundStr == null || this.lastFoundStr.length() == 0) {
            return false;
        }
        this.findIndex += this.lastFoundStr.length();
        if (this.findIndex > this.getDocument().getLength() - this.lastFoundStr.length()) {
            this.findIndex = 0;
        } else {
            String str = this.lastFoundStr;
            found = this.matchAndHilightString(this.lastFoundStr, this.lastTimeIgnoreCase, false);
            if (found) {
                return true;
            }
            this.findIndex = 0;
            this.lastFoundStr = str;
        }
        return this.matchAndHilightString(this.lastFoundStr, this.lastTimeIgnoreCase, false);
    }

    public boolean findPreviousString() {
        this.removeHighlight();
        if (this.lastFoundStr == null || this.lastFoundStr.length() == 0) {
            return false;
        }
        this.findIndex -= this.lastFoundStr.length();
        if (this.findIndex < 0) {
            this.findIndex = this.getDocument().getLength() - this.lastFoundStr.length();
        } else {
            String str = this.lastFoundStr;
            boolean found = this.matchAndHilightString(this.lastFoundStr, this.lastTimeIgnoreCase, true);
            if (found) {
                return true;
            }
            this.lastFoundStr = str;
            this.findIndex = this.getDocument().getLength() - this.lastFoundStr.length();
        }
        return this.matchAndHilightString(this.lastFoundStr, this.lastTimeIgnoreCase, true);
    }

    public void checkPairOfParentheses(int pos) {
        char c2;
        char c;
        int i;
        Document doc = this.getDocument();
        String text = "";
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return;
        }
        Stack<Character> stack = new Stack<Character>();
        boolean toBeRepainted = false;
        boolean unbalanced = false;
        if (pos > 0 && (text.charAt(pos - 1) == ')' || text.charAt(pos - 1) == '}' || text.charAt(pos - 1) == ']')) {
            for (i = pos - 1; i >= 0; --i) {
                c = text.charAt(i);
                switch (c) {
                    case ')': 
                    case ']': 
                    case '}': {
                        stack.push(Character.valueOf(c));
                        break;
                    }
                    case '(': 
                    case '[': 
                    case '{': {
                        c2 = ((Character)stack.pop()).charValue();
                        if (!(c2 == ')' && c != '(' || c2 == '}' && c != '{') && (c2 != ']' || c == '[')) break;
                        unbalanced = true;
                    }
                }
                if (unbalanced) {
                    this.prevPairedParenthesesPosition = -1;
                    break;
                }
                if (!stack.empty()) continue;
                this.prevPairedParenthesesPosition = i;
                toBeRepainted = true;
                break;
            }
            if (!stack.empty()) {
                if (this.prevPairedParenthesesPosition >= 0) {
                    toBeRepainted = true;
                }
                this.prevPairedParenthesesPosition = -1;
            }
        } else {
            if (this.prevPairedParenthesesPosition >= 0) {
                toBeRepainted = true;
            }
            this.prevPairedParenthesesPosition = -1;
        }
        if (text.length() > pos && (text.charAt(pos) == '(' || text.charAt(pos) == '{' || text.charAt(pos) == '[')) {
            unbalanced = false;
            stack.clear();
            for (i = pos; i < text.length(); ++i) {
                c = text.charAt(i);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        stack.push(Character.valueOf(c));
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        c2 = ((Character)stack.pop()).charValue();
                        if (!(c2 == '(' && c != ')' || c2 == '{' && c != '}') && (c2 != '[' || c == ']')) break;
                        unbalanced = true;
                    }
                }
                if (unbalanced) {
                    this.nextPairedParenthesesPosition = -1;
                    break;
                }
                if (!stack.empty()) continue;
                this.nextPairedParenthesesPosition = i;
                toBeRepainted = true;
                break;
            }
            if (!stack.empty()) {
                if (this.nextPairedParenthesesPosition >= 0) {
                    toBeRepainted = true;
                }
                this.nextPairedParenthesesPosition = -1;
            }
        } else {
            if (this.nextPairedParenthesesPosition >= 0) {
                toBeRepainted = true;
            }
            this.nextPairedParenthesesPosition = -1;
        }
        if (toBeRepainted) {
            this.repaint();
        }
    }

    class PopupMenuMouseListener
    implements MouseListener {
        PopupMenuMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mousePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void mousePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JComponent c = (JComponent)e.getSource();
                this.showPopup(c, e.getX(), e.getY());
                e.consume();
            }
        }

        protected void showPopup(JComponent c, int x, int y) {
            JPopupMenu pmenu = new JPopupMenu();
            ActionMap am = c.getActionMap();
            Action cut = am.get("cut-to-clipboard");
            this.addMenu(pmenu, ResourceBundle.getBundle("turtleedit/TEBandle").getString("CUT"), cut, 88, KeyStroke.getKeyStroke(88, 128));
            Action copy = am.get("copy-to-clipboard");
            this.addMenu(pmenu, ResourceBundle.getBundle("turtleedit/TEBandle").getString("COPY"), copy, 67, KeyStroke.getKeyStroke(67, 128));
            Action paste = am.get("paste-from-clipboard");
            this.addMenu(pmenu, ResourceBundle.getBundle("turtleedit/TEBandle").getString("PASTE"), paste, 86, KeyStroke.getKeyStroke(86, 128));
            pmenu.show(c, x, y);
        }

        protected void addMenu(JPopupMenu pmenu, String text, Action action, int mnemonic, KeyStroke ks) {
            if (action != null) {
                JMenuItem mi = pmenu.add(action);
                if (text != null) {
                    mi.setText(text);
                }
                if (mnemonic != 0) {
                    mi.setMnemonic(mnemonic);
                }
                if (ks != null) {
                    mi.setAccelerator(ks);
                }
            }
        }
    }

    class EditorCaret
    extends DefaultCaret {
        EditorCaret() {
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (r == null) {
                return;
            }
            this.x = r.x;
            this.y = r.y;
            this.height = r.height;
            if (this.width <= 0) {
                this.width = this.getComponent().getWidth();
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            JTextComponent comp = this.getComponent();
            if (comp == null) {
                return;
            }
            int dot = this.getDot();
            Rectangle r = null;
            try {
                r = comp.modelToView(dot);
                if (r == null) {
                    return;
                }
            }
            catch (BadLocationException e) {
                return;
            }
            if (this.x != r.x || this.y != r.y) {
                this.repaint();
                this.x = r.x;
                this.y = r.y;
                this.height = r.height;
            }
            this.width = 2;
            if (this.isVisible()) {
                g.setColor(Color.GRAY);
                g.fillRect(r.x, r.y, this.width, r.height);
            }
        }
    }

    class TELabelView
    extends LabelView {
        private final Color pen_col;
        private final BasicStroke dashed;
        private final BasicStroke solid;

        public TELabelView(Element elem) {
            super(elem);
            this.pen_col = new Color(255, 200, 0);
            this.dashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f}, 0.0f);
            this.solid = new BasicStroke(2.0f);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            this.paintCustomLine(g, a);
            super.paint(g, a);
        }

        private void paintCustomLine(Graphics g, Shape a) {
            Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            int x0 = rect.x;
            int y0 = rect.y;
            int height = rect.height;
            Color defaultColor = g.getColor();
            Graphics2D g2 = (Graphics2D)g;
            char prevChar = '\u0000';
            if (this.getStartOffset() > 0) {
                prevChar = this.getText(this.getStartOffset() - 1, this.getStartOffset()).toString().charAt(0);
            }
            String text = this.getText(this.getStartOffset(), this.getEndOffset()).toString();
            FontMetrics fm = g.getFontMetrics();
            int space = 0;
            for (int i = 0; i < text.length(); ++i) {
                int x = x0 + space;
                int y = y0;
                char c = text.charAt(i);
                int width = fm.charWidth(c);
                try {
                    if (String.valueOf(c).getBytes("UTF-8").length >= 2) {
                        g2.setStroke(this.dashed);
                        g2.setPaint(this.pen_col);
                        g2.drawRect(x + 0, y - 1, width - 2, height - 1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (this.getStartOffset() + i == TEEditorPane.this.prevPairedParenthesesPosition || this.getStartOffset() + i == TEEditorPane.this.nextPairedParenthesesPosition) {
                    g2.setStroke(this.solid);
                    g2.setPaint(this.pen_col);
                    g2.drawRect(x + 0, y, width, height - 1);
                }
                if (c == '\t') {
                    if (prevChar == '\t') {
                        g2.setStroke(this.dashed);
                        g2.setPaint(this.pen_col);
                        g2.drawLine(x, y, x, y + height);
                    }
                    space += (int)this.getTabExpander().nextTabStop(x, i) - x;
                } else if (c == '\n') {
                    g2.setPaint(this.pen_col);
                    int h = rect.height;
                    int[] xc = new int[]{x + 4, x + 10, x + 7};
                    int[] yc = new int[]{y + h / 2, y + h / 2, y + h / 2 + 5};
                    g2.fillPolygon(xc, yc, 3);
                } else if (c >= ' ') {
                    space += width;
                }
                prevChar = c;
            }
            g.setColor(defaultColor);
        }
    }

    class NumberedParagraphView
    extends ParagraphView {
        private final Color pen_col;

        public NumberedParagraphView(Element e) {
            super(e);
            this.pen_col = new Color(255, 200, 0);
            short top = 0;
            short left = 0;
            short bottom = 0;
            short right = 0;
            this.setInsets(top, left, bottom, right);
        }

        @Override
        protected void setInsets(short top, short left, short bottom, short right) {
            super.setInsets((short)(top + 1), (short)(left + TEEditorPane.this.LINE_NUMBER_WIDTH), (short)(bottom + 1), right);
        }

        @Override
        protected short getTopInset() {
            return 1;
        }

        @Override
        protected short getBottomInset() {
            return 1;
        }

        @Override
        protected short getLeftInset() {
            return TEEditorPane.this.LINE_NUMBER_WIDTH;
        }

        @Override
        public void paintChild(Graphics g, Rectangle r, int n) {
            super.paintChild(g, r, n);
            int previousLineCount = this.getPreviousLineCount();
            int x = r.x - this.getLeftInset();
            int y = r.y + r.height - TEEditorPane.this.lineNumFontDescent;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setFont(TEEditorPane.this.lineNumFont);
            g2.setColor(Color.blue);
            if (n == 0) {
                g2.drawString(String.format("%04d", (previousLineCount + 1) % 10000), x, y);
            } else {
                g2.drawString(String.format("   >", new Object[0]), x, y);
            }
        }

        public int getPreviousLineCount() {
            int lineCount = 0;
            View parent = this.getParent();
            int count = parent.getViewCount();
            for (int i = 0; i < count && parent.getView(i) != this; ++i) {
                ++lineCount;
            }
            return lineCount;
        }

        @Override
        public float nextTabStop(float x, int tabOffset) {
            TabSet tabs = this.getTabSet();
            if (tabs == null) {
                return this.getTabBase() + (float)(((int)((x - this.getTabBase()) / (float)TEEditorPane.this.TAB_WIDTH) + 1) * TEEditorPane.this.TAB_WIDTH);
            }
            return super.nextTabStop(x, tabOffset);
        }
    }

    class NumberedViewFactory
    implements ViewFactory {
        NumberedViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new TELabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new NumberedParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class NumberedEditorKit
    extends StyledEditorKit {
        NumberedEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new NumberedViewFactory();
        }
    }
}

