/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TEExecCommandDialog
extends JDialog {
    private boolean plungePipe = true;
    TEMainWindow mainWindow;
    ArrayList<String> commandHistory;
    KeyListener textFieldKeyListener;
    int currentIndex = 0;
    private JButton cancelButton;
    private JTextField commandLineTextField;
    private JButton executeButton;
    private JCheckBox plungeTextCheckBox;

    public TEExecCommandDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.mainWindow = (TEMainWindow)parent;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.commandHistory = new ArrayList();
        this.textFieldKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ev) {
                int keyCode = ev.getKeyCode();
                if (TEExecCommandDialog.this.commandHistory.size() <= 0) {
                    return;
                }
                switch (keyCode) {
                    case 40: {
                        ++TEExecCommandDialog.this.currentIndex;
                        if (TEExecCommandDialog.this.currentIndex > TEExecCommandDialog.this.commandHistory.size() - 1) {
                            TEExecCommandDialog.this.currentIndex = TEExecCommandDialog.this.commandHistory.size() - 1;
                        }
                        TEExecCommandDialog.this.commandLineTextField.setText(TEExecCommandDialog.this.commandHistory.get(TEExecCommandDialog.this.currentIndex));
                        break;
                    }
                    case 38: {
                        --TEExecCommandDialog.this.currentIndex;
                        if (TEExecCommandDialog.this.currentIndex < 0) {
                            TEExecCommandDialog.this.currentIndex = 0;
                        }
                        TEExecCommandDialog.this.commandLineTextField.setText(TEExecCommandDialog.this.commandHistory.get(TEExecCommandDialog.this.currentIndex));
                        break;
                    }
                    case 37: {
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ev) {
            }

            @Override
            public void keyTyped(KeyEvent ev) {
            }
        };
        this.commandLineTextField.addKeyListener(this.textFieldKeyListener);
        TEExecCommandDialog.installEscapeCloseOperation(this);
        this.getRootPane().setDefaultButton(this.executeButton);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "com.spodding.tackline.dispatch:WINDOW_CLOSING");
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing);
    }

    private void initComponents() {
        this.commandLineTextField = new JTextField();
        this.cancelButton = new JButton();
        this.executeButton = new JButton();
        this.plungeTextCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("EXEC COMMAND"));
        this.setResizable(false);
        this.commandLineTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEExecCommandDialog.this.commandLineTextFieldActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEExecCommandDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.executeButton.setText(bundle.getString("EXECUTE"));
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEExecCommandDialog.this.executeButtonActionPerformed(evt);
            }
        });
        this.plungeTextCheckBox.setSelected(true);
        this.plungeTextCheckBox.setText(bundle.getString("PLUNGE TEXT"));
        this.plungeTextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEExecCommandDialog.this.plungeTextCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(2, false).add(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.plungeTextCheckBox).add(102, 102, 102).add(this.cancelButton).addPreferredGap(0).add(this.executeButton, -2, 99, -2)).add(1, layout.createSequentialGroup().add(19, 19, 19).add(this.commandLineTextField, -2, 514, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(this.commandLineTextField, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.executeButton).add(this.plungeTextCheckBox)).addContainerGap(23, Short.MAX_VALUE)));
        this.pack();
    }

    private void plungeTextCheckBoxActionPerformed(ActionEvent evt) {
        this.plungePipe = !this.plungePipe;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.mainWindow.killRunningProcess(true);
        this.setVisible(false);
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        String line = this.commandLineTextField.getText();
        if (line.length() > 0) {
            this.mainWindow.execCommandLine(this.commandLineTextField.getText(), this.plungePipe);
            this.commandHistory.add(line);
            this.currentIndex = this.commandHistory.size() - 1;
        }
    }

    private void commandLineTextFieldActionPerformed(ActionEvent evt) {
        this.executeButtonActionPerformed(null);
    }
}

