/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ResourceBundle;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TEResponseDialog
extends JDialog {
    private static final int MAXCHARS = 140;
    private static final int MAXERRMSG = 1024;
    private static final int PORT_BROADCAST = 3100;
    private static final int PORT_SUBMISSION = 3100;
    private static final int BROADCAST_MESSAGE_LENGTH = 1024;
    private static final int RSA_KEY_LENGTH = 512;
    private static final int LISTENER_MAX_RETRY_COUNT = 30;
    private static final int LISTENER_TIMEOUT_MS = 1000;
    private final Object SERVER_ADDRESS_LOCK;
    private InetAddress serverAddress;
    private DatagramSocket listenerSocket = null;
    private ListenerThread listener;
    private boolean terminatingListener = false;
    private int channelNumber;
    private TEMainWindow mainWindow;
    public RSAPublicKey publicKey;
    private JCheckBox attachCompileErrorCheckBox;
    private JRadioButton channelARadioButton;
    private JRadioButton channelBRadioButton;
    private ButtonGroup channelButtonGroup;
    private JRadioButton channelCRadioButton;
    private JLabel channelLabel;
    private JLabel choiceLabel;
    private JButton closeButton;
    private JTextArea commentsTextArea;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton10;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    private JRadioButton jRadioButton9;
    private JLabel messageLabel;
    private JTextArea messageTextArea;
    private JLabel nicknameLabel;
    private JTextField nicknameTextField;
    private ButtonGroup numberButtonGroup;
    private JLabel passcodeLabel;
    private JTextField passcodeTextField;
    private JButton submitButton;
    private JButton webButton;

    public TEResponseDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.mainWindow = (TEMainWindow)parent;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.submitButton.setEnabled(false);
        this.SERVER_ADDRESS_LOCK = new Object();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TEResponseDialog.this.closeButtonActionPerformed(null);
            }
        });
        this.serverAddress = null;
        this.publicKey = null;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.numberButtonGroup = new ButtonGroup();
        this.channelButtonGroup = new ButtonGroup();
        this.submitButton = new JButton();
        this.closeButton = new JButton();
        this.nicknameTextField = new JTextField();
        this.nicknameLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jRadioButton8 = new JRadioButton();
        this.jRadioButton9 = new JRadioButton();
        this.jRadioButton10 = new JRadioButton();
        this.choiceLabel = new JLabel();
        this.passcodeLabel = new JLabel();
        this.messageTextArea = new JTextArea();
        this.passcodeTextField = new JTextField();
        this.channelLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.channelCRadioButton = new JRadioButton();
        this.channelBRadioButton = new JRadioButton();
        this.channelARadioButton = new JRadioButton();
        this.commentsTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.webButton = new JButton();
        this.attachCompileErrorCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("FEEDBACK"));
        this.submitButton.setText(bundle.getString("SUBMIT"));
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText(bundle.getString("CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.nicknameTextField.setText("nickname");
        this.nicknameLabel.setHorizontalAlignment(11);
        this.nicknameLabel.setText(bundle.getString("NICKNAME"));
        this.messageLabel.setHorizontalAlignment(11);
        this.messageLabel.setText(bundle.getString("MESSAGE"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.numberButtonGroup.add(this.jRadioButton1);
        this.jRadioButton1.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton1.setMnemonic('1');
        this.jRadioButton1.setText("1/YES");
        this.numberButtonGroup.add(this.jRadioButton2);
        this.jRadioButton2.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton2.setMnemonic('2');
        this.jRadioButton2.setText("2/NO");
        this.numberButtonGroup.add(this.jRadioButton3);
        this.jRadioButton3.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton3.setMnemonic('3');
        this.jRadioButton3.setText("3");
        this.numberButtonGroup.add(this.jRadioButton4);
        this.jRadioButton4.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton4.setMnemonic('4');
        this.jRadioButton4.setText("4");
        this.numberButtonGroup.add(this.jRadioButton5);
        this.jRadioButton5.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton5.setMnemonic('5');
        this.jRadioButton5.setText("5");
        this.numberButtonGroup.add(this.jRadioButton6);
        this.jRadioButton6.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton6.setMnemonic('6');
        this.jRadioButton6.setText("6");
        this.numberButtonGroup.add(this.jRadioButton7);
        this.jRadioButton7.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton7.setMnemonic('7');
        this.jRadioButton7.setText("7");
        this.numberButtonGroup.add(this.jRadioButton8);
        this.jRadioButton8.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton8.setMnemonic('8');
        this.jRadioButton8.setText("8");
        this.numberButtonGroup.add(this.jRadioButton9);
        this.jRadioButton9.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton9.setMnemonic('9');
        this.jRadioButton9.setText("9");
        this.numberButtonGroup.add(this.jRadioButton10);
        this.jRadioButton10.setFont(new Font("Lucida Grande", 1, 14));
        this.jRadioButton10.setMnemonic('0');
        this.jRadioButton10.setSelected(true);
        this.jRadioButton10.setText("0/?");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(1).add(this.jRadioButton1).add(this.jRadioButton6)).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(12, 12, 12).add(this.jRadioButton7)).add(jPanel1Layout.createSequentialGroup().addPreferredGap(0).add(this.jRadioButton2))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jRadioButton3).addPreferredGap(0).add(this.jRadioButton4)).add(jPanel1Layout.createSequentialGroup().add(this.jRadioButton8).addPreferredGap(0).add(this.jRadioButton9))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.jRadioButton10).add(this.jRadioButton5)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButton1, this.jRadioButton10, this.jRadioButton2, this.jRadioButton3, this.jRadioButton4, this.jRadioButton5, this.jRadioButton6, this.jRadioButton7, this.jRadioButton8, this.jRadioButton9}, 1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jRadioButton1).add(this.jRadioButton2).add(this.jRadioButton3).add(this.jRadioButton4).add(this.jRadioButton5)).addPreferredGap(1).add(jPanel1Layout.createParallelGroup(3).add(this.jRadioButton6).add(this.jRadioButton7).add(this.jRadioButton8).add(this.jRadioButton9).add(this.jRadioButton10)).addContainerGap(-1, Short.MAX_VALUE)));
        this.choiceLabel.setHorizontalAlignment(11);
        this.choiceLabel.setText(bundle.getString("CHOICE"));
        this.passcodeLabel.setHorizontalAlignment(11);
        this.passcodeLabel.setText(bundle.getString("PASSCODE"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(5);
        this.messageTextArea.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.passcodeTextField.setText("0000");
        this.channelLabel.setHorizontalAlignment(11);
        this.channelLabel.setText(bundle.getString("CHANNEL"));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.channelButtonGroup.add(this.channelCRadioButton);
        this.channelCRadioButton.setText("C");
        this.channelCRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.channelCRadioButtonActionPerformed(evt);
            }
        });
        this.channelButtonGroup.add(this.channelBRadioButton);
        this.channelBRadioButton.setText("B");
        this.channelBRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.channelBRadioButtonActionPerformed(evt);
            }
        });
        this.channelButtonGroup.add(this.channelARadioButton);
        this.channelARadioButton.setSelected(true);
        this.channelARadioButton.setText("A");
        this.channelARadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.channelARadioButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().add(14, 14, 14).add(this.channelARadioButton).add(18, 18, 18).add(this.channelBRadioButton).add(20, 20, 20).add(this.channelCRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.channelCRadioButton).add(this.channelBRadioButton).add(this.channelARadioButton)).addContainerGap()));
        this.commentsTextArea.setEditable(false);
        this.commentsTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.commentsTextArea.setColumns(20);
        this.commentsTextArea.setLineWrap(true);
        this.commentsTextArea.setRows(5);
        this.commentsTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText(bundle.getString("INSTRUCTION"));
        this.webButton.setIcon(new ImageIcon(this.getClass().getResource("/turtleedit/images/globe.png")));
        this.webButton.setBorder(null);
        this.webButton.setBorderPainted(false);
        this.webButton.setContentAreaFilled(false);
        this.webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEResponseDialog.this.webButtonActionPerformed(evt);
            }
        });
        this.attachCompileErrorCheckBox.setText(bundle.getString("ATTACH ERROR MESSAGE"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1, false).add(this.channelLabel, -1, -1, Short.MAX_VALUE).add(this.jLabel1, -1, 81, Short.MAX_VALUE).add(this.nicknameLabel, -1, -1, Short.MAX_VALUE).add(this.messageLabel, -1, -1, Short.MAX_VALUE).add(this.choiceLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.webButton, -2, 56, -2).add(layout.createSequentialGroup().add(1, 1, 1).add(layout.createParallelGroup(2, false).add(layout.createSequentialGroup().add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(58, 58, 58).add(this.passcodeLabel, -2, 80, -2).addPreferredGap(0).add(this.passcodeTextField, -2, 118, -2)).add(layout.createSequentialGroup().add(this.closeButton, -2, 102, -2).add(18, 18, 18).add(this.submitButton, -2, 106, -2)).add(1, this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, this.messageTextArea).add(1, this.commentsTextArea)))).addContainerGap(18, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.nicknameTextField, -2, 142, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.attachCompileErrorCheckBox).add(35, 35, 35)))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(29, 29, 29).add(this.channelLabel).add(5, 5, 5)).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(layout.createSequentialGroup().add(6, 6, 6).add(layout.createParallelGroup(3).add(this.passcodeLabel).add(this.passcodeTextField, -2, -1, -2)))))).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(this.commentsTextArea, -2, 67, -2)).add(layout.createSequentialGroup().add(33, 33, 33).add(this.jLabel1))).add(18, 18, 18).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.nicknameTextField, -2, -1, -2).add(this.nicknameLabel)).add(this.attachCompileErrorCheckBox)).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(11, 11, 11).add(this.messageTextArea, -2, 66, -2)).add(layout.createSequentialGroup().add(29, 29, 29).add(this.messageLabel))).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(this.jPanel1, -2, -1, -2)).add(layout.createSequentialGroup().add(36, 36, 36).add(this.choiceLabel))).add(18, 18, 18).add(layout.createParallelGroup(1).add(this.webButton, -2, 23, -2).add(this.closeButton).add(this.submitButton)).add(17, 17, Short.MAX_VALUE)));
        this.pack();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.mainWindow.setNicknamePasscodeAndChannel(this.nicknameTextField.getText().trim(), this.passcodeTextField.getText().trim(), this.channelNumber);
        this.submitFeedback();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.forceToTerminateListener();
        this.setVisible(false);
    }

    private void channelARadioButtonActionPerformed(ActionEvent evt) {
        this.channelNumber = 0;
        this.restartListener();
    }

    private void channelBRadioButtonActionPerformed(ActionEvent evt) {
        this.channelNumber = 1;
        this.restartListener();
    }

    private void channelCRadioButtonActionPerformed(ActionEvent evt) {
        this.channelNumber = 2;
        this.restartListener();
    }

    private void webButtonActionPerformed(ActionEvent evt) {
        if (this.serverAddress == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("CANNOT FIND SERVER"), "WARNING", 2);
            return;
        }
        String url = "http://" + this.serverAddress.getHostAddress() + ":3080/index.html";
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public void startListener() {
        if (this.listener != null || this.terminatingListener) {
            return;
        }
        this.terminatingListener = false;
        this.listener = new ListenerThread();
        this.listener.start();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void restartListener() {
        this.submitButton.setEnabled(false);
        this.forceToTerminateListener();
        if (this.openListenerSocket()) {
            this.startListener();
            this.submitButton.setEnabled(true);
        }
    }

    private void forceToTerminateListener() {
        if (this.listener != null && this.listener.isAlive()) {
            this.terminatingListener = true;
            while (this.terminatingListener) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setNicknamePasscodeAndChannel(String nickname, String passcode, int channel) {
        this.nicknameTextField.setText(nickname);
        this.passcodeTextField.setText(passcode);
        this.channelNumber = channel;
        switch (channel) {
            case 0: {
                this.channelARadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.channelBRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.channelCRadioButton.setSelected(true);
                break;
            }
        }
    }

    public String selectedNumber() {
        ButtonModel model = this.numberButtonGroup.getSelection();
        return String.valueOf(model.getMnemonic() - 48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitFeedback() {
        StringBuilder server_msg = new StringBuilder("");
        boolean gotResponse = false;
        if (this.serverAddress == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("CANNOT FIND SERVER"), "WARNING", 2);
            return false;
        }
        try {
            String line;
            BufferedReader reader;
            OutputStreamWriter writer;
            Socket socket;
            Object object = this.SERVER_ADDRESS_LOCK;
            synchronized (object) {
                socket = new Socket(this.serverAddress, 3100 + this.channelNumber);
                writer = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
                reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "utf-8"));
            }
            String passcode = this.passcodeTextField.getText().trim();
            if (passcode.length() > 8) {
                passcode = passcode.substring(0, 8);
            }
            writer.write("passcode=" + this.encryptShortMessage(passcode) + "\r\n");
            String nickname = this.nicknameTextField.getText().trim();
            if (nickname.length() > 16) {
                nickname = nickname.substring(0, 16);
            }
            writer.write("nickname=" + nickname.replaceAll("[\t\r\n\"]", "") + "\r\n");
            writer.write("userid=" + this.encryptShortMessage(System.getProperty("user.name")) + "\r\n");
            String localHostName = "unknown";
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
                localHostName = localMachine.getHostName();
            }
            catch (UnknownHostException localMachine) {
                // empty catch block
            }
            writer.write("hostname=" + this.encryptShortMessage(localHostName) + "\r\n");
            writer.write("choice=" + this.selectedNumber() + "\r\n");
            String message = this.messageTextArea.getText().trim();
            message = message.replaceAll("\t", " ");
            message = message.replaceAll("[\r\n]", "<br>");
            if (message.length() > 140) {
                message = message.substring(0, 139);
            }
            writer.write("message=" + message + "\r\n");
            if (this.attachCompileErrorCheckBox.isSelected()) {
                String compileErrors = this.mainWindow.checkCompileError();
                compileErrors = compileErrors.replaceAll("\t", " ");
                if ((compileErrors = compileErrors.replaceAll("[\r\n]", "<br>")).length() > 1024) {
                    compileErrors = compileErrors.substring(0, 1023);
                }
                writer.write("errmsg=" + compileErrors + "\r\n");
            }
            writer.write("\r\n");
            writer.flush();
            socket.shutdownOutput();
            while ((line = reader.readLine()) != null) {
                server_msg.append(line);
                gotResponse = true;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("COMMUNICATION ERROR"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2);
            this.serverAddress = null;
            return false;
        }
        if (!gotResponse) {
            server_msg.append("COMMUNICATION ERROR");
        }
        JOptionPane.showMessageDialog(this, server_msg.toString(), ResourceBundle.getBundle("turtleedit/TEBandle").getString("INFORMATION"), 1);
        return true;
    }

    public void regeneratePublicKey(byte[] byteMod, byte[] byteExp) {
        BigInteger modules = new BigInteger(byteMod);
        BigInteger publicExponent = new BigInteger(byteExp);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modules, publicExponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException ex) {
            this.publicKey = null;
        }
        catch (InvalidKeySpecException ex) {
            this.publicKey = null;
        }
    }

    public String byte2hex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toHexString((b & 0xF0) >> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    public String encryptShortMessage(String str) {
        if (this.publicKey == null) {
            return str;
        }
        byte[] data = str.getBytes();
        while (data.length > 52) {
            str = str.substring(0, str.length() / 2);
            data = str.getBytes();
        }
        byte[] encrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, this.publicKey);
            encrypted = cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        return this.byte2hex(encrypted);
    }

    public boolean openListenerSocket() {
        DatagramSocket socket;
        if (this.listener != null) {
            return true;
        }
        try {
            socket = new DatagramSocket(3100 + this.channelNumber);
        }
        catch (SocketException ex) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("PORT IS ALREADY IN USE"), "WARNING", 2);
            return false;
        }
        this.listenerSocket = socket;
        return true;
    }

    class ListenerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] receiveData = new byte[1024];
            int retry_counter = 0;
            while (true) {
                if (TEResponseDialog.this.terminatingListener) {
                    TEResponseDialog.this.listenerSocket.close();
                    TEResponseDialog.this.listener = null;
                    TEResponseDialog.this.terminatingListener = false;
                    return;
                }
                DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                try {
                    TEResponseDialog.this.listenerSocket.setSoTimeout(1000);
                    TEResponseDialog.this.listenerSocket.receive(receivePacket);
                }
                catch (UnsupportedEncodingException ex) {
                    continue;
                }
                catch (IOException ex) {
                    if (TEResponseDialog.this.serverAddress != null && ++retry_counter < 30) continue;
                    if (TEResponseDialog.this.serverAddress != null) {
                        Object object = TEResponseDialog.this.SERVER_ADDRESS_LOCK;
                        synchronized (object) {
                            TEResponseDialog.this.serverAddress = null;
                        }
                    }
                    TEResponseDialog.this.publicKey = null;
                    TEResponseDialog.this.submitButton.setEnabled(false);
                    continue;
                }
                retry_counter = 0;
                Object ex = TEResponseDialog.this.SERVER_ADDRESS_LOCK;
                synchronized (ex) {
                    if (TEResponseDialog.this.serverAddress == null) {
                        TEResponseDialog.this.serverAddress = receivePacket.getAddress();
                    } else {
                        InetAddress addr = receivePacket.getAddress();
                        if (!addr.equals(TEResponseDialog.this.serverAddress)) {
                            TEResponseDialog.this.serverAddress = addr;
                            TEResponseDialog.this.publicKey = null;
                        }
                    }
                }
                try {
                    int k = 0;
                    byte[] msg = new byte[receiveData[k] & 0xFF];
                    ++k;
                    for (int i = 0; i < msg.length && k < 1024; ++i, ++k) {
                        msg[i] = receiveData[k];
                    }
                    TEResponseDialog.this.commentsTextArea.setText(new String(msg, "UTF-8"));
                    if (TEResponseDialog.this.publicKey == null) {
                        byte[] byteMod = new byte[receiveData[k] & 0xFF];
                        ++k;
                        for (int i = 0; i < byteMod.length && k < 1024; ++i, ++k) {
                            byteMod[i] = receiveData[k];
                        }
                        byte[] byteExp = new byte[receiveData[k] & 0xFF];
                        ++k;
                        for (int i = 0; i < byteExp.length && k < 1024; ++i, ++k) {
                            byteExp[i] = receiveData[k];
                        }
                        TEResponseDialog.this.regeneratePublicKey(byteMod, byteExp);
                    }
                    TEResponseDialog.this.submitButton.setEnabled(true);
                }
                catch (UnsupportedEncodingException k) {
                    // empty catch block
                }
                try {
                    ListenerThread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    TEResponseDialog.this.terminatingListener = true;
                    continue;
                }
                break;
            }
        }
    }
}

