/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEAboutDialog;
import turtleedit.TEConsolePane;
import turtleedit.TECountDialog;
import turtleedit.TEDirListDialog;
import turtleedit.TEEditorPane;
import turtleedit.TEExecCommandDialog;
import turtleedit.TEFilterDialog;
import turtleedit.TEFindDialog;
import turtleedit.TEHelpDialog;
import turtleedit.TEReplaceDialog;
import turtleedit.TEResponseDialog;
import turtleedit.TESettingDialog;
import turtleedit.TESortDialog;
import turtleedit.TETrDialog;
import turtleedit.TEUniqDialog;
import turtleedit.TFLauncher;

public class TEMainWindow
extends JFrame {
    private File workingFile = null;
    private Boolean workingFileIsSet;
    private Boolean contentIsSaved;
    private Boolean startCompiling;
    private Boolean compileWasDoneNormally;
    public Boolean interpreterMode;
    public String compileCommand;
    public String execCommand;
    public String execPath;
    public String helpURI;
    public String charCode;
    public String preferredFontName;
    public int preferredFontSize;
    public String passcodeForFeedback;
    public String nicknameForFeedback;
    public int channelForFeedback;
    public String turtleFieldPathName;
    public boolean turtleFieldAutoLaunch;
    TFLauncher tfLauncher;
    private Preferences prefs;
    private Process runningProcess;
    private String foundString;
    private TEFilterDialog filterDialog;
    private TEReplaceDialog replaceDialog;
    private TEFindDialog findDialog;
    private TEResponseDialog feedbackDialog;
    private TEExecCommandDialog execCommandDialog;
    private TESortDialog sortDialog;
    private TECountDialog countDialog;
    private TEUniqDialog uniqDialog;
    private TETrDialog trDialog;
    private JMenuItem aboutMenuItem;
    private JButton breakButton;
    private JMenuItem breakMenuItem;
    private JButton compileButton;
    private JMenuItem compileMenuItem;
    private JTextPane consolePane;
    private JMenuItem copyMenuItem;
    private JMenuItem countMenuItem;
    private JMenuItem cutMenuItem;
    private JEditorPane editPane;
    private JMenuItem execCommandMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem feedbackMenuItem;
    private Box.Filler filler1;
    private JMenu filterMenu;
    private JMenuItem findMenuItem;
    private JMenuItem findNextMenuItem;
    private JMenuItem findPreviousMenuItem;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JButton pwdButton;
    private JMenuItem regExFilterMenuItem;
    private JMenuItem regExReplaceMenuItem;
    private JButton runButton;
    private JMenuItem runMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem saveOutputsMenuItem;
    private JMenuItem settingsMenuItem;
    private JMenuItem sortMenuItem;
    private JMenuItem swapBuffersMenuItem;
    private JSplitPane terminalSplitPane;
    private JMenuItem translationMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem uniqMenuItem;
    private JMenuItem webHelpMenuItem;

    public TEMainWindow() {
        this.initComponents();
        this.workingFileIsSet = false;
        this.contentIsSaved = false;
        this.startCompiling = false;
        this.compileWasDoneNormally = false;
        this.runningProcess = null;
        this.filterDialog = null;
        this.replaceDialog = null;
        this.findDialog = null;
        this.feedbackDialog = null;
        this.execCommandDialog = null;
        this.sortDialog = null;
        this.countDialog = null;
        this.uniqDialog = null;
        this.trDialog = null;
        this.tfLauncher = null;
        this.turtleFieldAutoLaunch = false;
        this.turtleFieldPathName = "";
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.restorePreferences();
        this.restoreWindowLocationAndSize();
        this.setMonospacedFont();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TEMainWindow.this.exitMenuItemActionPerformed(null);
            }
        });
        this.tfLauncher = new TFLauncher(this);
    }

    private void initComponents() {
        this.jMenu4 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.compileButton = new JButton();
        this.runButton = new JButton();
        this.breakButton = new JButton();
        this.pwdButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(100, 46), new Dimension(100, 46), new Dimension(100, 46));
        this.terminalSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.editPane = new TEEditorPane();
        this.jScrollPane3 = new JScrollPane();
        this.consolePane = new TEConsolePane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.saveOutputsMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.findMenuItem = new JMenuItem();
        this.findNextMenuItem = new JMenuItem();
        this.findPreviousMenuItem = new JMenuItem();
        this.filterMenu = new JMenu();
        this.regExFilterMenuItem = new JMenuItem();
        this.regExReplaceMenuItem = new JMenuItem();
        this.sortMenuItem = new JMenuItem();
        this.uniqMenuItem = new JMenuItem();
        this.countMenuItem = new JMenuItem();
        this.translationMenuItem = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.execCommandMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.swapBuffersMenuItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.compileMenuItem = new JMenuItem();
        this.runMenuItem = new JMenuItem();
        this.breakMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.settingsMenuItem = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.webHelpMenuItem = new JMenuItem();
        this.feedbackMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jMenu4.setText("jMenu4");
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem2.setText("jMenuItem2");
        this.setDefaultCloseOperation(3);
        this.setTitle("TurtleEdit");
        this.setMinimumSize(new Dimension(500, 300));
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.compileButton.setText(bundle.getString("COMPILE"));
        this.compileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.compileButtonActionPerformed(evt);
            }
        });
        this.runButton.setText(bundle.getString("RUN"));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.runButtonActionPerformed(evt);
            }
        });
        this.breakButton.setText(bundle.getString("BREAK"));
        this.breakButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.breakButtonActionPerformed(evt);
            }
        });
        this.pwdButton.setText(bundle.getString("CURRENT DIRECTORY"));
        this.pwdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.pwdButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.compileButton, -2, 102, -2).addPreferredGap(0).add(this.runButton, -2, 93, -2).addPreferredGap(0).add(this.breakButton).addPreferredGap(0).add(this.filler1, -2, 72, -2).addPreferredGap(1, -1, Short.MAX_VALUE).add(this.pwdButton, -2, 176, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(2).add(this.pwdButton, -2, 46, -2).add(jPanel1Layout.createParallelGroup(3).add(this.compileButton, -2, 46, -2).add(this.runButton, -2, 46, -2).add(this.breakButton, -2, 46, -2)).add(this.filler1, -2, -1, -2)).addContainerGap()));
        this.terminalSplitPane.setDividerLocation(300);
        this.terminalSplitPane.setOrientation(0);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.editPane.setFont(new Font("Monaco", 0, 14));
        this.jScrollPane1.setViewportView(this.editPane);
        this.terminalSplitPane.setTopComponent(this.jScrollPane1);
        this.consolePane.setFont(new Font("Monaco", 0, 12));
        this.jScrollPane3.setViewportView(this.consolePane);
        this.terminalSplitPane.setBottomComponent(this.jScrollPane3);
        this.jMenu1.setText(bundle.getString("FILE"));
        this.newMenuItem.setText(bundle.getString("NEW"));
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.newMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.newMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setText(bundle.getString("OPEN"));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setText(bundle.getString("SAVE"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(bundle.getString("SAVE AS..."));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveAsMenuItem);
        this.saveOutputsMenuItem.setText(bundle.getString("SAVE OUTPUTS"));
        this.saveOutputsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.saveOutputsMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveOutputsMenuItem);
        this.jMenu1.add(this.jSeparator1);
        this.exitMenuItem.setText(bundle.getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText(bundle.getString("EDIT"));
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.setText(bundle.getString("UNDO"));
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.undoMenuItem);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setText(bundle.getString("CUT"));
        this.cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText(bundle.getString("COPY"));
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setText(bundle.getString("PASTE"));
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.pasteMenuItem);
        this.jMenu2.add(this.jSeparator2);
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findMenuItem.setText(bundle.getString("FIND"));
        this.findMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.findMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.findMenuItem);
        this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.findNextMenuItem.setText(bundle.getString("FIND NEXT"));
        this.findNextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.findNextMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.findNextMenuItem);
        this.findPreviousMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        this.findPreviousMenuItem.setText(bundle.getString("FIND PREVIOUS"));
        this.findPreviousMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.findPreviousMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.findPreviousMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.filterMenu.setText(bundle.getString("FILTER"));
        this.regExFilterMenuItem.setText(bundle.getString("REGEX FILTER"));
        this.regExFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.regExFilterMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.regExFilterMenuItem);
        this.regExReplaceMenuItem.setText(bundle.getString("REPLACE"));
        this.regExReplaceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.regExReplaceMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.regExReplaceMenuItem);
        this.sortMenuItem.setText("Sort");
        this.sortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.sortMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.sortMenuItem);
        this.uniqMenuItem.setText("Uniq");
        this.uniqMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.uniqMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.uniqMenuItem);
        this.countMenuItem.setText("Count");
        this.countMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.countMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.countMenuItem);
        this.translationMenuItem.setText("Tr");
        this.translationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.translationMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.translationMenuItem);
        this.filterMenu.add(this.jSeparator6);
        this.execCommandMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        this.execCommandMenuItem.setText(bundle.getString("EXEC COMMAND"));
        this.execCommandMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.execCommandMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.execCommandMenuItem);
        this.filterMenu.add(this.jSeparator5);
        this.swapBuffersMenuItem.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        this.swapBuffersMenuItem.setText(bundle.getString("SWAP BUFFERS"));
        this.swapBuffersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.swapBuffersMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.swapBuffersMenuItem);
        this.jMenuBar1.add(this.filterMenu);
        this.jMenu3.setText(bundle.getString("RUN"));
        this.compileMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.compileMenuItem.setText(bundle.getString("CHECK & COMPILE"));
        this.compileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.compileMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.compileMenuItem);
        this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.runMenuItem.setText(bundle.getString("RUN"));
        this.runMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.runMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.runMenuItem);
        this.breakMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.breakMenuItem.setText(bundle.getString("BREAK"));
        this.breakMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.breakMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.breakMenuItem);
        this.jMenu3.add(this.jSeparator4);
        this.settingsMenuItem.setText(bundle.getString("SETTINGS"));
        this.settingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.settingsMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.settingsMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu5.setText(bundle.getString("HELP"));
        this.webHelpMenuItem.setText(bundle.getString("OPEN WEB PAGE"));
        this.webHelpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.webHelpMenuItemActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.webHelpMenuItem);
        this.feedbackMenuItem.setText(bundle.getString("FEEDBACK"));
        this.feedbackMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.feedbackMenuItemActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.feedbackMenuItem);
        this.aboutMenuItem.setText(bundle.getString("ABOUT TURTLEEDIT..."));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEMainWindow.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.jMenu5);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(this.terminalSplitPane, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.terminalSplitPane, -1, 404, Short.MAX_VALUE)));
        this.pack();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        if (this.confirmToSaveDialogue() == 0) {
            return;
        }
        this.editPane.selectAll();
        this.editPane.replaceSelection("");
        ((TEEditorPane)this.editPane).resetUndoManager();
        this.workingFileIsSet = false;
        this.contentIsSaved = false;
        this.setWindowTitle();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.confirmToSaveDialogue() == 0) {
            return;
        }
        if (this.workingFile != null) {
            this.prefs.put("WORKING_DIR", this.workingFile.getParent());
        }
        this.saveWindowLocationAndSize();
        this.killRunningProcess(false);
        System.exit(0);
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        String str;
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard cb = kit.getSystemClipboard();
        try {
            str = (String)cb.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        ((TEEditorPane)this.editPane).pasteString(str);
    }

    private void compileMenuItemActionPerformed(ActionEvent evt) {
        this.compileWorkingFile();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        if (this.confirmToSaveDialogue() == 0) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(this.initialDirectoryToOpen());
        FileNameExtensionFilter filter1 = new FileNameExtensionFilter(ResourceBundle.getBundle("turtleedit/TEBandle").getString("PROGRAMMING"), "c", "cpp", "java", "rb", "py", "js", "php", "pl", "bas", "lua", "scala", "clj", "groovy");
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter(ResourceBundle.getBundle("turtleedit/TEBandle").getString("WRITING"), "txt", "tex", "htm", "html");
        fileChooser.addChoosableFileFilter(filter2);
        fileChooser.addChoosableFileFilter(filter1);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.workingFile = fileChooser.getSelectedFile();
            this.workingFileIsSet = true;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.workingFile), this.charCode));
                while (reader.ready()) {
                    stringBuilder.append(reader.readLine() + "\n");
                }
                reader.close();
                this.editPane.setText(stringBuilder.toString());
                this.contentIsSaved = false;
                ((TEEditorPane)this.editPane).contentIsSaved();
            }
            catch (IOException ioe) {
                ((TEConsolePane)this.consolePane).clearAndSetText("Error: cannot open " + this.workingFile.getName());
            }
        }
        this.setWindowTitle();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.initialDirectoryToOpen());
        if (fileChooser.showSaveDialog(this) == 0) {
            this.workingFile = fileChooser.getSelectedFile();
            if (!this.isFileNameOK(this.workingFile.getName())) {
                return;
            }
            if (this.workingFile.exists() && !this.canOverwriteFile(this.workingFile.getName())) {
                return;
            }
            this.workingFileIsSet = true;
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.workingFile), this.charCode));
                writer.write(this.editPane.getText());
                writer.close();
                this.workingFile = fileChooser.getSelectedFile();
                this.contentIsSaved = true;
                ((TEEditorPane)this.editPane).contentIsSaved();
            }
            catch (IOException ioe) {
                ((TEConsolePane)this.consolePane).clearAndSetText("Error: cannot save data to " + this.workingFile.getName() + "\n");
            }
        }
        this.setWindowTitle();
    }

    private void findMenuItemActionPerformed(ActionEvent evt) {
        if (this.findDialog == null) {
            this.findDialog = new TEFindDialog((Frame)this, true);
        }
        this.findDialog.setVisible(true);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (!this.workingFileIsSet.booleanValue()) {
            JFileChooser fileChooser = new JFileChooser(this.initialDirectoryToOpen());
            if (fileChooser.showSaveDialog(this) == 0) {
                this.workingFile = fileChooser.getSelectedFile();
                if (!this.isFileNameOK(this.workingFile.getName())) {
                    return;
                }
                if (this.workingFile.exists() && !this.canOverwriteFile(this.workingFile.getName())) {
                    return;
                }
            } else {
                return;
            }
            this.workingFileIsSet = true;
            this.setWindowTitle();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.workingFile), this.charCode));
            writer.write(this.editPane.getText());
            writer.close();
            this.contentIsSaved = true;
            ((TEEditorPane)this.editPane).contentIsSaved();
        }
        catch (IOException ioe) {
            ((TEConsolePane)this.consolePane).clearAndSetText("Error: cannot save file\u00a5n");
        }
        this.setWindowTitle();
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.editPane.cut();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        if (((TEEditorPane)this.editPane).lastFocusedTime > ((TEConsolePane)this.consolePane).lastFocusedTime) {
            this.editPane.copy();
        } else {
            this.consolePane.copy();
        }
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        ((TEEditorPane)this.editPane).undo();
    }

    private void settingsMenuItemActionPerformed(ActionEvent evt) {
        TESettingDialog setting = new TESettingDialog((Frame)this, true);
        setting.setInterpreterMode(this.interpreterMode);
        setting.setCompileCommandTextField(this.compileCommand);
        setting.setExecCommandTextField(this.execCommand);
        setting.setExecPathTextField(this.execPath);
        setting.setCharCodeRadioButton(this.charCode);
        setting.setPreferredFontName(this.preferredFontName);
        setting.setPreferredFontSize(this.preferredFontSize);
        setting.setTurtleFieldPathName(this.turtleFieldPathName);
        setting.setTurtleFieldAutoLaunch(this.turtleFieldAutoLaunch);
        setting.setVisible(true);
    }

    private void compileButtonActionPerformed(ActionEvent evt) {
        this.compileMenuItemActionPerformed(null);
    }

    private void runMenuItemActionPerformed(ActionEvent evt) {
        this.execCompiledCommand();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.runMenuItemActionPerformed(null);
    }

    private void breakButtonActionPerformed(ActionEvent evt) {
        this.killRunningProcess(false);
    }

    private void findNextMenuItemActionPerformed(ActionEvent evt) {
        this.findNextString();
    }

    private void pwdButtonActionPerformed(ActionEvent evt) {
        if (!this.workingFileIsSet.booleanValue()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("FILE IS NOT OPENED."), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2);
            return;
        }
        TEDirListDialog dirList = new TEDirListDialog((Frame)this, true, this.workingFile);
        dirList.setVisible(true);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        TEAboutDialog about = new TEAboutDialog((Frame)this, true);
        about.setVisible(true);
    }

    private void webHelpMenuItemActionPerformed(ActionEvent evt) {
        TEHelpDialog help = new TEHelpDialog((Frame)this, false);
        help.setVisible(true);
    }

    private void saveOutputsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.initialDirectoryToOpen());
        if (fileChooser.showSaveDialog(this) == 0) {
            File outputFile = fileChooser.getSelectedFile();
            if (!this.isFileNameOK(outputFile.getName())) {
                return;
            }
            if (outputFile.exists() && !this.canOverwriteFile(outputFile.getName())) {
                return;
            }
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.charCode));
                writer.write(this.consolePane.getText());
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void breakMenuItemActionPerformed(ActionEvent evt) {
        this.breakButtonActionPerformed(null);
    }

    private void feedbackMenuItemActionPerformed(ActionEvent evt) {
        if (this.feedbackDialog == null) {
            this.feedbackDialog = new TEResponseDialog((Frame)this, false);
        }
        this.feedbackDialog.setNicknamePasscodeAndChannel(this.nicknameForFeedback, this.passcodeForFeedback, this.channelForFeedback);
        if (this.feedbackDialog.openListenerSocket()) {
            this.feedbackDialog.startListener();
            this.feedbackDialog.setVisible(true);
        }
    }

    private void regExFilterMenuItemActionPerformed(ActionEvent evt) {
        if (this.filterDialog == null) {
            this.filterDialog = new TEFilterDialog((Frame)this, false);
        }
        this.filterDialog.setVisible(true);
    }

    private void regExReplaceMenuItemActionPerformed(ActionEvent evt) {
        if (this.replaceDialog == null) {
            this.replaceDialog = new TEReplaceDialog((Frame)this, false);
        }
        this.replaceDialog.setVisible(true);
    }

    private void swapBuffersMenuItemActionPerformed(ActionEvent evt) {
        String buffer = this.editPane.getText();
        this.editPane.selectAll();
        this.editPane.setText(this.consolePane.getText());
        ((TEConsolePane)this.consolePane).clearAndSetText(buffer);
    }

    private void uniqMenuItemActionPerformed(ActionEvent evt) {
        if (this.uniqDialog == null) {
            this.uniqDialog = new TEUniqDialog((Frame)this, false);
        }
        this.uniqDialog.setVisible(true);
    }

    private void sortMenuItemActionPerformed(ActionEvent evt) {
        if (this.sortDialog == null) {
            this.sortDialog = new TESortDialog((Frame)this, false);
        }
        this.sortDialog.setVisible(true);
    }

    private void execCommandMenuItemActionPerformed(ActionEvent evt) {
        if (this.execCommandDialog == null) {
            this.execCommandDialog = new TEExecCommandDialog((Frame)this, false);
        }
        this.execCommandDialog.setVisible(true);
    }

    private void countMenuItemActionPerformed(ActionEvent evt) {
        if (this.countDialog == null) {
            this.countDialog = new TECountDialog((Frame)this, false);
        }
        this.countDialog.setVisible(true);
    }

    private void translationMenuItemActionPerformed(ActionEvent evt) {
        if (this.trDialog == null) {
            this.trDialog = new TETrDialog((Frame)this, false);
        }
        this.trDialog.setVisible(true);
    }

    private void findPreviousMenuItemActionPerformed(ActionEvent evt) {
        this.findPreviousString();
    }

    private void setWindowTitle() {
        if (this.workingFileIsSet.booleanValue()) {
            this.setTitle("TurtleEdit: " + this.workingFile.getName());
        } else {
            this.setTitle("TurtleEdit");
        }
    }

    private int confirmToSaveDialogue() {
        if (((TEEditorPane)this.editPane).isContentModified()) {
            int rc = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("DO YOU WANT TO SAVE THE CHANGES YOU MADE ?"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("CONFIRMATION MESSAGE"), 1);
            if (rc == 0) {
                this.saveMenuItemActionPerformed(null);
            } else if (rc == 2) {
                return 0;
            }
        }
        return 1;
    }

    public String initialDirectoryToOpen() {
        if (this.workingFile == null) {
            String lastWorkingDir = this.prefs.get("WORKING_DIR", "");
            if (lastWorkingDir.length() > 0) {
                File workingDir = new File(lastWorkingDir);
                if (workingDir.exists()) {
                    try {
                        return workingDir.getCanonicalPath().replaceAll("\\\\", "\\\\\\\\");
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return this.workingFile.getParent().replaceAll("\\\\", "\\\\\\\\");
    }

    public boolean isFileNameOK(String fn) {
        if (fn.contains(" ") || fn.contains("\u3000")) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("FILE NAME") + " \"" + fn + "\" " + ResourceBundle.getBundle("turtleedit/TEBandle").getString("CONTAINS WHITE SPACE"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2);
            return false;
        }
        return true;
    }

    public boolean canOverwriteFile(String fn) {
        int rc = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("FILE") + " \"" + fn + "\" " + ResourceBundle.getBundle("turtleedit/TEBandle").getString("EXIST. DO YOU WANT TO OVERWRITE IT ?"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2, 2);
        return rc == 0;
    }

    public void findString(String str, boolean ignoreCase) {
        this.foundString = null;
        if (!((TEEditorPane)this.editPane).findString(str, ignoreCase)) {
            JOptionPane.showMessageDialog(this, "\"" + str + "\"" + ResourceBundle.getBundle("turtleedit/TEBandle").getString("NOT FOUND"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("MESSAGE"), 1);
        } else {
            this.foundString = str;
        }
    }

    public void findNextString() {
        if (this.foundString != null && !((TEEditorPane)this.editPane).findNextString()) {
            JOptionPane.showMessageDialog(this, "\"" + this.foundString + "\" not found.", ResourceBundle.getBundle("turtleedit/TEBandle").getString("MESSAGE"), 1);
        }
    }

    public void findPreviousString() {
        if (this.foundString != null && !((TEEditorPane)this.editPane).findPreviousString()) {
            JOptionPane.showMessageDialog(this, "\"" + this.foundString + "\" not found.", ResourceBundle.getBundle("turtleedit/TEBandle").getString("MESSAGE"), 1);
        }
    }

    private void restoreWindowLocationAndSize() {
        int x = this.prefs.getInt("WIN_LOC_X", 10);
        int y = this.prefs.getInt("WIN_LOC_Y", 10);
        int width = this.prefs.getInt("WIN_WIDTH", 570);
        int height = this.prefs.getInt("WIN_HEIGHT", 600);
        this.setLocation(x, y);
        this.setSize(width, height);
    }

    private void saveWindowLocationAndSize() {
        Rectangle fbound = this.getBounds();
        this.prefs.putInt("WIN_LOC_X", fbound.x);
        this.prefs.putInt("WIN_LOC_Y", fbound.y);
        this.prefs.putInt("WIN_WIDTH", fbound.width);
        this.prefs.putInt("WIN_HEIGHT", fbound.height);
    }

    public void savePreferences() {
        if (this.interpreterMode.booleanValue()) {
            this.prefs.put("INTERPRETER_MODE", "YES");
        } else {
            this.prefs.put("INTERPRETER_MODE", "NO");
        }
        this.prefs.put("COMPILE_COMMAND", this.compileCommand);
        this.prefs.put("EXEC_COMMAND", this.execCommand);
        this.prefs.put("EXEC_PATH", this.execPath);
        this.prefs.put("HELP_URI", this.helpURI);
        this.prefs.put("CHAR_CODE", this.charCode);
        this.prefs.put("PREFERRED_FONT_NAME", this.preferredFontName);
        this.prefs.put("PREFERRED_FONT_SIZE", String.valueOf(this.preferredFontSize));
        this.prefs.put("TF_PATH_NAME", this.turtleFieldPathName);
        if (this.turtleFieldAutoLaunch) {
            this.prefs.put("TF_AUTO_LAUNCH", "YES");
        } else {
            this.prefs.put("TF_AUTO_LAUNCH", "NO");
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void restorePreferences() {
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        String im = this.prefs.get("INTERPRETER_MODE", "NO");
        this.interpreterMode = im.equals("YES");
        this.compileButton.setEnabled(this.interpreterMode == false);
        this.compileMenuItem.setEnabled(this.interpreterMode == false);
        this.compileCommand = this.prefs.get("COMPILE_COMMAND", "cc %f -lm");
        this.execCommand = this.prefs.get("EXEC_COMMAND", "./a.out");
        this.execPath = this.prefs.get("EXEC_PATH", "/opt/local/bin");
        this.helpURI = this.prefs.get("HELP_URI", "http://seaotter.cite.tohoku.ac.jp/coda/tedit/help/index.html");
        this.charCode = this.prefs.get("CHAR_CODE", "UTF-8");
        this.preferredFontName = this.prefs.get("PREFERRED_FONT_NAME", "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
        this.preferredFontSize = Integer.valueOf(this.prefs.get("PREFERRED_FONT_SIZE", "14"));
        this.passcodeForFeedback = this.prefs.get("PASSCODE", "");
        this.nicknameForFeedback = this.prefs.get("NICKNAME", "UNNAMED");
        this.channelForFeedback = Integer.valueOf(this.prefs.get("CHANNEL", "0"));
        this.turtleFieldPathName = this.prefs.get("TF_PATH_NAME", "");
        String launchMode = this.prefs.get("TF_AUTO_LAUNCH", "NO");
        this.turtleFieldAutoLaunch = launchMode.equals("YES");
    }

    public void setInterpreterMode(Boolean mode) {
        this.interpreterMode = mode;
        this.compileButton.setEnabled(mode == false);
        this.compileMenuItem.setEnabled(mode == false);
    }

    public void setCompileCommand(String s) {
        this.compileCommand = s;
    }

    public void setExecCommand(String s) {
        this.execCommand = s;
    }

    public void setExecPath(String s) {
        this.execPath = s;
    }

    public void setHelpURI(String s) {
        this.helpURI = s;
    }

    public void setCharCode(String s) {
        this.charCode = s;
    }

    public void setPreferredFontName(String s) {
        this.preferredFontName = s;
    }

    public void setPreferredFont(String name, int size) {
        if (!name.equals(this.preferredFontName) || size != this.preferredFontSize) {
            this.preferredFontName = name;
            this.preferredFontSize = size;
            this.setMonospacedFont();
        }
    }

    public void setTurtleField(String path, boolean mode) {
        this.turtleFieldPathName = path;
        this.turtleFieldAutoLaunch = mode;
    }

    public String baseFileName(String s) {
        int pos = s.lastIndexOf(46);
        if (pos == -1) {
            return s;
        }
        if (pos == 0) {
            return s;
        }
        return s.substring(0, pos);
    }

    public void setNicknamePasscodeAndChannel(String nickname, String passcode, int channel) {
        this.nicknameForFeedback = nickname;
        this.passcodeForFeedback = passcode;
        this.channelForFeedback = channel;
        this.prefs.put("NICKNAME", nickname);
        this.prefs.put("PASSCODE", passcode);
        this.prefs.put("CHANNEL", Integer.toString(channel));
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private int numberOfNewline(String str) {
        int j;
        int cnt = 0;
        int i = 0;
        while ((j = str.indexOf(10, i)) >= 0) {
            ++cnt;
            i = j + 1;
        }
        return cnt;
    }

    public void performFiltering(String regex, int type, boolean withLineNum, boolean dotAllFlag) {
        Pattern ptn = dotAllFlag ? Pattern.compile(regex, 40) : Pattern.compile(regex, 8);
        String target = this.editPane.getText();
        ((TEConsolePane)this.consolePane).clearAndSetText("");
        switch (type) {
            case 0: {
                int ln = 1;
                int start = 0;
                Matcher m = ptn.matcher(target);
                while (m.find()) {
                    MatchResult res = m.toMatchResult();
                    String str = target.substring(res.start(), res.end());
                    if (withLineNum) {
                        ((TEConsolePane)this.consolePane).appendText(String.format("%1$04d", ln += this.numberOfNewline(target.substring(start, res.start()))) + ":");
                    }
                    ((TEConsolePane)this.consolePane).appendText(str + "\n");
                    start = res.end();
                }
                break;
            }
            case 1: 
            case 2: {
                Matcher m;
                String line;
                int next;
                int ln = 1;
                int start = 0;
                while ((next = target.indexOf(10, start)) >= 0) {
                    line = target.substring(start, next);
                    m = ptn.matcher(line);
                    if (type == 1 ? m.matches() : m.find()) {
                        if (withLineNum) {
                            ((TEConsolePane)this.consolePane).appendText(String.format("%1$04d", ln) + ":");
                        }
                        ((TEConsolePane)this.consolePane).appendText(line + "\n");
                    }
                    start = next + 1;
                    ++ln;
                }
                if (start >= target.length()) break;
                next = target.length();
                line = target.substring(start, next);
                m = ptn.matcher(line);
                if (!(type == 1 ? m.matches() : m.find())) break;
                if (withLineNum) {
                    ((TEConsolePane)this.consolePane).appendText(String.format("%1$04d", ln) + ":");
                }
                ((TEConsolePane)this.consolePane).appendText(line + "\n");
                break;
            }
        }
    }

    public void performReplacement(String regex, String replaceTo, boolean dotAllFlag) {
        Pattern ptn = dotAllFlag ? Pattern.compile(regex, 40) : Pattern.compile(regex, 8);
        String target = this.editPane.getText();
        Matcher m = ptn.matcher(target);
        String res = m.replaceAll(replaceTo);
        ((TEConsolePane)this.consolePane).clearAndSetText(res);
    }

    public void performSort(int key, boolean ignoreCase, boolean reverseOrder, boolean numericSort) {
        String[] lines = this.editPane.getText().split("\\r?\\n");
        Arrays.sort(lines, new LineComparator(key, ignoreCase, reverseOrder, numericSort));
        StringBuilder txt = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            txt.append(lines[i] + "\n");
        }
        ((TEConsolePane)this.consolePane).clearAndSetText(txt.toString());
    }

    public void performUniq(boolean counting) {
        int counter = 0;
        String[] lines = this.editPane.getText().split("\\r?\\n");
        Iterator<String> iter = Arrays.asList(lines).iterator();
        StringBuilder txt = new StringBuilder();
        String previous = null;
        while (iter.hasNext()) {
            String current = iter.next().toString();
            if (previous == null || current.compareTo(previous) == 0) {
                ++counter;
            } else {
                if (counting) {
                    txt.append(counter + " ");
                }
                txt.append(previous + "\n");
                counter = 1;
            }
            previous = current;
        }
        if (previous != null) {
            if (counting) {
                txt.append(counter + " ");
            }
            txt.append(previous + "\n");
        }
        ((TEConsolePane)this.consolePane).clearAndSetText(txt.toString());
    }

    public void performCounting(boolean linenum, boolean countword, boolean countchar, boolean appendtext) {
        String[] lines = this.editPane.getText().split("\\r?\\n");
        StringBuilder txt = new StringBuilder();
        int lineno = 1;
        for (int i = 0; i < lines.length; ++i) {
            if (linenum) {
                txt.append(lineno + " ");
            }
            if (countword) {
                int nword = lines[i].length() == 0 ? 0 : lines[i].trim().split("\\s+").length;
                txt.append(nword + " ");
            }
            if (countchar) {
                int nchar = lines[i].length();
                txt.append(nchar + " ");
            }
            if (appendtext) {
                txt.append(lines[i]);
            }
            txt.append("\n");
            ++lineno;
        }
        ((TEConsolePane)this.consolePane).clearAndSetText(txt.toString());
    }

    public void performTranslation(int trfunc) {
        String text;
        String translatedText = text = this.editPane.getText();
        switch (trfunc) {
            case 1: {
                translatedText = text.toLowerCase();
                break;
            }
            case 2: {
                translatedText = text.toUpperCase();
                break;
            }
            case 3: {
                translatedText = this.zenkakuToHankaku(text);
                break;
            }
            case 4: {
                translatedText = this.hankakuToZenkaku(text);
                break;
            }
        }
        ((TEConsolePane)this.consolePane).clearAndSetText(translatedText);
    }

    public String zenkakuToHankaku(String str) {
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c >= '\uff01' && c <= '\uff5e') {
                sb.setCharAt(i, (char)(c - 65281 + 33));
                continue;
            }
            if (c != '\u3000') continue;
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }

    public String hankakuToZenkaku(String str) {
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c >= '!' && c <= '~') {
                sb.setCharAt(i, (char)(c - 33 + 65281));
                continue;
            }
            if (c != ' ') continue;
            sb.setCharAt(i, '\u3000');
        }
        return sb.toString();
    }

    private String convertQuotedSegment(String s) {
        int c0 = 0;
        boolean quoted = false;
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            if (c0 != 92 && c1 == '\'') {
                quoted = !quoted;
            } else if (c0 == 92 && c1 == '\'') {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(c1);
            } else if (c1 == ' ') {
                if (quoted) {
                    sb.append("%s");
                } else {
                    sb.append(" ");
                }
            } else {
                sb.append(c1);
            }
            c0 = c1;
        }
        return sb.toString();
    }

    public List parseCommandLine(String s) {
        ArrayList<String> commandList = new ArrayList<String>();
        String s2 = this.convertQuotedSegment(s);
        StringTokenizer tokenizer = new StringTokenizer(s2, " ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.workingFile != null) {
                token = token.replaceAll("%f", this.workingFile.getName());
                token = token.replaceAll("%d", this.workingFile.getParent().replaceAll("\\\\", "\\\\\\\\"));
                token = token.replaceAll("%b", this.baseFileName(this.workingFile.getName()));
            }
            token = token.replaceAll("%c", new File(".").getAbsoluteFile().getParent().replaceAll("\\\\", "\\\\\\\\"));
            token = token.replaceAll("%h", System.getProperty("user.home").replaceAll("\\\\", "\\\\\\\\"));
            token = token.replaceAll("%s", " ");
            commandList.add(token);
        }
        return commandList;
    }

    public String checkCompileError() {
        int rc = -1;
        this.compileWorkingFile();
        while (this.runningProcess != null) {
            try {
                rc = this.runningProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                rc = -1;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (rc < 0) continue;
        }
        String result = this.consolePane.getText();
        return result;
    }

    public void compileWorkingFile() {
        if (this.confirmToSaveDialogue() == 0) {
            return;
        }
        if (!this.workingFileIsSet.booleanValue()) {
            ((TEConsolePane)this.consolePane).clearAndSetText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("YOU NEED TO WRITE SOURCE CODE AND SAVE IT BEF0RE COMPILING"));
            return;
        }
        this.startCompiling = true;
        this.compileWasDoneNormally = false;
        int rc = this.execCommandInConsolePane(this.compileCommand, ResourceBundle.getBundle("turtleedit/TEBandle").getString("COMPILING"), false);
    }

    public void execCompiledCommand() {
        int rc = -1;
        if (this.interpreterMode.booleanValue()) {
            if (this.confirmToSaveDialogue() == 0) {
                return;
            }
            if (!this.workingFileIsSet.booleanValue()) {
                ((TEConsolePane)this.consolePane).clearAndSetText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("YOU NEED TO WRITE SOURCE CODE AND SAVE IT BEFORE EXECUTION"));
                return;
            }
        } else {
            if (this.startCompiling.booleanValue()) {
                if (this.runningProcess == null) {
                    this.startCompiling = false;
                } else {
                    try {
                        rc = this.runningProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        rc = -1;
                    }
                }
                if (rc == 0) {
                    this.compileWasDoneNormally = true;
                }
            } else if (((TEEditorPane)this.editPane).isContentModified()) {
                this.compileWasDoneNormally = false;
            }
            if (!this.compileWasDoneNormally.booleanValue()) {
                ((TEConsolePane)this.consolePane).clearAndSetText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("YOU NEED TO COMPILE SOURCE PROGRAM FIRST"));
                return;
            }
            this.startCompiling = false;
        }
        if (this.turtleFieldAutoLaunch) {
            this.tfLauncher.setCommandPath(this.turtleFieldPathName);
            this.tfLauncher.launch();
        }
        this.execCommandInConsolePane(this.execCommand, ResourceBundle.getBundle("turtleedit/TEBandle").getString("RUNNING PROGRAM"), false);
    }

    public void execCommandLine(String commandLine, boolean plungStdin) {
        ((TEConsolePane)this.consolePane).clearAndSetText("");
        this.execCommandInConsolePane(commandLine, "", true);
        if (plungStdin) {
            ((TEConsolePane)this.consolePane).writeStringToRunningProcess(((TEEditorPane)this.editPane).getText(), true);
        }
    }

    public int execCommandInConsolePane(String commandLine, String startingMessage, boolean silentMode) {
        int rc = 0;
        String osname = System.getProperty("os.name");
        String delimiter = osname.indexOf("Windows") >= 0 ? ";" : ":";
        this.killRunningProcess(silentMode);
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException ex) {
            return -1;
        }
        List commandList = this.parseCommandLine(commandLine);
        ProcessBuilder pb = new ProcessBuilder(commandList);
        Map<String, String> env = pb.environment();
        String execPaths = env.get("PATH") + delimiter + this.execPath;
        env.remove("PATH");
        env.put("PATH", execPaths);
        pb.redirectErrorStream(true);
        if (this.workingFile != null) {
            pb.directory(this.workingFile.getParentFile());
        } else {
            pb.directory(new File(System.getProperty("user.home")));
        }
        try {
            if (!silentMode) {
                ((TEConsolePane)this.consolePane).clearAndSetText(startingMessage + "\n$ ");
                for (String str : commandList) {
                    ((TEConsolePane)this.consolePane).appendText(str + " ");
                }
                ((TEConsolePane)this.consolePane).appendText("\n");
            }
            this.runningProcess = pb.start();
            ((TEConsolePane)this.consolePane).handleProcess(this.runningProcess, this.charCode, silentMode);
        }
        catch (IOException ex) {
            ((TEConsolePane)this.consolePane).clearAndSetText("Command execution error: " + commandLine + "\n");
            String errmsg = this.headingLineOfStackTrace(ex);
            String msgbody = errmsg.replaceAll("^.*?:\\s*", "");
            ((TEConsolePane)this.consolePane).appendText(msgbody + "\n");
            rc = -1;
        }
        return rc;
    }

    public String headingLineOfStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        Scanner sn = new Scanner(sw.toString());
        if (sn.hasNextLine()) {
            return sn.nextLine();
        }
        return "";
    }

    public void killRunningProcess(boolean silentMode) {
        if (this.runningProcess != null) {
            this.runningProcess.destroy();
            try {
                Thread.sleep(0L, 1000);
                ((TEConsolePane)this.consolePane).terminateRunningThread();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!silentMode) {
                ((TEConsolePane)this.consolePane).appendText(ResourceBundle.getBundle("turtleedit/TEBandle").getString("INTERRUPTED"));
            }
        }
        this.runningProcess = null;
    }

    public String checkAvailableMonospacedFont() {
        ArrayList<String> monospacedFonts = new ArrayList<String>();
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            if (!fonts[i].equalsIgnoreCase(this.preferredFontName) && !fonts[i].equalsIgnoreCase("MS Gothic") && !fonts[i].equalsIgnoreCase("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af") && !fonts[i].equalsIgnoreCase("\u3055\u3056\u306a\u307f\u30b4\u30b7\u30c3\u30af") && !fonts[i].equalsIgnoreCase("Monospaced") && !fonts[i].equalsIgnoreCase("Liberation Mono") && !fonts[i].equalsIgnoreCase("Lucida Console") && !fonts[i].equalsIgnoreCase("Monaco") && !fonts[i].equalsIgnoreCase("Terminal") && !fonts[i].equalsIgnoreCase("Courier") && !fonts[i].equalsIgnoreCase("Bitstream Vera Sans Mono") && !fonts[i].equalsIgnoreCase("OCRB")) continue;
            monospacedFonts.add(fonts[i]);
        }
        if (monospacedFonts.contains(this.preferredFontName)) {
            return this.preferredFontName;
        }
        if (monospacedFonts.contains("MS Gothic")) {
            return "MS Gothic";
        }
        if (monospacedFonts.contains("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af")) {
            return "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
        }
        if (monospacedFonts.contains("\u3055\u3056\u306a\u307f\u30b4\u30b7\u30c3\u30af")) {
            return "\u3055\u3056\u306a\u307f\u30b4\u30b7\u30c3\u30af";
        }
        if (monospacedFonts.contains("Lucida Console")) {
            return "Lucida Console";
        }
        if (monospacedFonts.contains("Bitstream Vera Sans Mono")) {
            return "Bitstream Vera Sans Mono";
        }
        if (monospacedFonts.contains("Monaco")) {
            return "Monaco";
        }
        if (monospacedFonts.contains("Terminal")) {
            return "Terminal";
        }
        if (monospacedFonts.contains("Monospaced")) {
            return "Monospaced";
        }
        if (monospacedFonts.contains("OCRB")) {
            return "OCRB";
        }
        if (monospacedFonts.contains("Courier")) {
            return "Courier";
        }
        return "Monospaced";
    }

    public void setMonospacedFont() {
        String fontname = this.checkAvailableMonospacedFont();
        ((TEEditorPane)this.editPane).setTextFont(new Font(fontname, 0, this.preferredFontSize));
        ((TEEditorPane)this.editPane).setLineNumFont(new Font(fontname, 0, this.preferredFontSize));
        this.consolePane.setFont(new Font(fontname, 0, 12));
    }

    public void distillClipboardContent() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard cb = kit.getSystemClipboard();
        try {
            String str = (String)cb.getData(DataFlavor.stringFlavor);
            StringSelection ss = new StringSelection(str);
            cb.setContents(ss, ss);
        }
        catch (UnsupportedFlavorException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    class LineComparator
    implements Comparator<String> {
        private int key;
        private boolean ignoreCase;
        private boolean reverseOrder;
        private boolean numericSort;

        LineComparator(int k, boolean caseinsensitive, boolean reverse, boolean numeric) {
            this.key = k;
            this.ignoreCase = caseinsensitive;
            this.reverseOrder = reverse;
            this.numericSort = numeric;
        }

        @Override
        public int compare(String o1, String o2) {
            String key2;
            String key1;
            int res = 0;
            if (this.key == 0) {
                key1 = o1;
                key2 = o2;
            } else {
                String[] s1 = o1.trim().split("\\s+", 5);
                String[] s2 = o2.trim().split("\\s+", 5);
                key1 = s1.length >= this.key ? s1[this.key - 1] : "";
                key2 = s2.length >= this.key ? s2[this.key - 1] : "";
            }
            if (this.numericSort) {
                double val2;
                double val1;
                try {
                    val1 = Double.parseDouble(key1);
                    val2 = Double.parseDouble(key2);
                }
                catch (NumberFormatException e) {
                    val2 = 0.0;
                    val1 = 0.0;
                }
                res = val1 > val2 ? 1 : (val1 < val2 ? -1 : 0);
            } else {
                res = this.ignoreCase ? key1.compareToIgnoreCase(key2) : key1.compareTo(key2);
            }
            if (this.reverseOrder) {
                res = -res;
            }
            return res;
        }
    }
}

