/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import turtleedit.TEMainWindow;

public class TESortDialog
extends JDialog {
    TEMainWindow mainWindow;
    private boolean ignoreCase = false;
    private boolean reverseOrder = false;
    private boolean numericSort = false;
    private int sortingKey = 1;
    private JButton cancelButton;
    private JCheckBox ignoreCaseCheckBox;
    private JRadioButton key0RadioButton;
    private JRadioButton key1RadioButton;
    private JRadioButton key2RadioButton;
    private JRadioButton key3RadioButton;
    private JRadioButton key4RadioButton;
    private JRadioButton key5RadioButton;
    private JCheckBox numericCheckBox;
    private JButton okButton;
    private JCheckBox reverseOrderCheckBox;
    private ButtonGroup sortKeyButtonGroup;
    private JPanel sortingKeyPanel;
    private JPanel sortingOptionsPanel;

    public TESortDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.initComponents();
        this.mainWindow = (TEMainWindow)parent;
        this.setLocationRelativeTo(parent);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TESortDialog.installEscapeCloseOperation(this);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "com.spodding.tackline.dispatch:WINDOW_CLOSING");
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing);
    }

    private void initComponents() {
        this.sortKeyButtonGroup = new ButtonGroup();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.sortingOptionsPanel = new JPanel();
        this.reverseOrderCheckBox = new JCheckBox();
        this.ignoreCaseCheckBox = new JCheckBox();
        this.numericCheckBox = new JCheckBox();
        this.sortingKeyPanel = new JPanel();
        this.key1RadioButton = new JRadioButton();
        this.key2RadioButton = new JRadioButton();
        this.key3RadioButton = new JRadioButton();
        this.key4RadioButton = new JRadioButton();
        this.key5RadioButton = new JRadioButton();
        this.key0RadioButton = new JRadioButton();
        this.setTitle("Sort lines");
        this.setResizable(false);
        this.setSize(new Dimension(480, 250));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.okButtonActionPerformed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.sortingOptionsPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SORTING OPTIONS")));
        this.sortingOptionsPanel.setToolTipText(bundle.getString("SORTING OPTION"));
        this.sortingOptionsPanel.setName("Sorting options");
        this.reverseOrderCheckBox.setText(bundle.getString("REVERSE ORDER"));
        this.reverseOrderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.reverseOrderCheckBoxActionPerformed(evt);
            }
        });
        this.ignoreCaseCheckBox.setText(bundle.getString("IGNORE CASE"));
        this.ignoreCaseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.ignoreCaseCheckBoxActionPerformed(evt);
            }
        });
        this.numericCheckBox.setText(bundle.getString("NUMERIC SORT"));
        this.numericCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.numericCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout sortingOptionsPanelLayout = new GroupLayout(this.sortingOptionsPanel);
        this.sortingOptionsPanel.setLayout(sortingOptionsPanelLayout);
        sortingOptionsPanelLayout.setHorizontalGroup(sortingOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingOptionsPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.reverseOrderCheckBox, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreCaseCheckBox, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numericCheckBox, -2, 128, -2).addContainerGap(-1, Short.MAX_VALUE)));
        sortingOptionsPanelLayout.setVerticalGroup(sortingOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(sortingOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reverseOrderCheckBox).addComponent(this.ignoreCaseCheckBox).addComponent(this.numericCheckBox)).addContainerGap(17, Short.MAX_VALUE)));
        this.sortingKeyPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("SORT KEY")));
        this.sortKeyButtonGroup.add(this.key1RadioButton);
        this.key1RadioButton.setMnemonic('1');
        this.key1RadioButton.setText("1");
        this.sortKeyButtonGroup.add(this.key2RadioButton);
        this.key2RadioButton.setMnemonic('2');
        this.key2RadioButton.setText("2");
        this.sortKeyButtonGroup.add(this.key3RadioButton);
        this.key3RadioButton.setMnemonic('3');
        this.key3RadioButton.setText("3");
        this.key3RadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TESortDialog.this.key3RadioButtonActionPerformed(evt);
            }
        });
        this.sortKeyButtonGroup.add(this.key4RadioButton);
        this.key4RadioButton.setMnemonic('4');
        this.key4RadioButton.setText("4");
        this.sortKeyButtonGroup.add(this.key5RadioButton);
        this.key5RadioButton.setMnemonic('5');
        this.key5RadioButton.setText("5");
        this.sortKeyButtonGroup.add(this.key0RadioButton);
        this.key0RadioButton.setMnemonic('0');
        this.key0RadioButton.setSelected(true);
        this.key0RadioButton.setText(bundle.getString("WHOLE LINE"));
        GroupLayout sortingKeyPanelLayout = new GroupLayout(this.sortingKeyPanel);
        this.sortingKeyPanel.setLayout(sortingKeyPanelLayout);
        sortingKeyPanelLayout.setHorizontalGroup(sortingKeyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingKeyPanelLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.key0RadioButton, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.key1RadioButton, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.key2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.key3RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.key4RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.key5RadioButton).addGap(84, 84, 84)));
        sortingKeyPanelLayout.linkSize(0, this.key1RadioButton, this.key2RadioButton, this.key3RadioButton, this.key4RadioButton, this.key5RadioButton);
        sortingKeyPanelLayout.setVerticalGroup(sortingKeyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingKeyPanelLayout.createSequentialGroup().addContainerGap().addGroup(sortingKeyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.key1RadioButton).addComponent(this.key2RadioButton).addComponent(this.key3RadioButton).addComponent(this.key4RadioButton).addComponent(this.key5RadioButton).addComponent(this.key0RadioButton)).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sortingKeyPanel, -2, 429, -2).addComponent(this.sortingOptionsPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 20, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addGap(32, 32, 32)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.sortingOptionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sortingKeyPanel, -2, -1, -2).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void numericCheckBoxActionPerformed(ActionEvent evt) {
        this.numericSort = !this.numericSort;
    }

    private void ignoreCaseCheckBoxActionPerformed(ActionEvent evt) {
        this.ignoreCase = !this.ignoreCase;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.performSorting();
    }

    private void reverseOrderCheckBoxActionPerformed(ActionEvent evt) {
        this.reverseOrder = !this.reverseOrder;
    }

    private void key3RadioButtonActionPerformed(ActionEvent evt) {
    }

    private void performSorting() {
        ButtonModel model = this.sortKeyButtonGroup.getSelection();
        this.sortingKey = model.getMnemonic() - 48;
        this.mainWindow.performSort(this.sortingKey, this.ignoreCase, this.reverseOrder, this.numericSort);
    }
}

