/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import turtleedit.TEMainWindow;

public class TECountDialog
extends JDialog {
    TEMainWindow mainWindow;
    boolean lineNumber;
    boolean countWord;
    boolean countChar;
    boolean appendText;
    private JCheckBox appendTextCheckBox;
    private JButton cancelButton;
    private JCheckBox charCountCheckBox;
    private JPanel jPanel1;
    private JCheckBox lineNumberCheckBox;
    private JButton okButton;
    private JCheckBox wordCountCheckBox;

    public TECountDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.initComponents();
        this.mainWindow = (TEMainWindow)parent;
        this.appendText = false;
        this.countChar = false;
        this.countWord = false;
        this.lineNumber = false;
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TECountDialog.installEscapeCloseOperation(this);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "com.spodding.tackline.dispatch:WINDOW_CLOSING");
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing);
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel1 = new JPanel();
        this.lineNumberCheckBox = new JCheckBox();
        this.wordCountCheckBox = new JCheckBox();
        this.charCountCheckBox = new JCheckBox();
        this.appendTextCheckBox = new JCheckBox();
        this.setTitle("Count words and characters in each line");
        this.setResizable(false);
        this.setSize(new Dimension(510, 170));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.okButtonActionPerformed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("OUTPUT RECORD")));
        this.jPanel1.setSize(new Dimension(480, 0));
        this.lineNumberCheckBox.setText(bundle.getString("LINE NUMBER"));
        this.lineNumberCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.lineNumberCheckBoxActionPerformed(evt);
            }
        });
        this.wordCountCheckBox.setText(bundle.getString("WORD COUNT"));
        this.wordCountCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.wordCountCheckBoxActionPerformed(evt);
            }
        });
        this.charCountCheckBox.setText(bundle.getString("CHARACTER COUNT"));
        this.charCountCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.charCountCheckBoxActionPerformed(evt);
            }
        });
        this.appendTextCheckBox.setText(bundle.getString("TEXT"));
        this.appendTextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TECountDialog.this.appendTextCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.lineNumberCheckBox).addGap(18, 18, 18).addComponent(this.wordCountCheckBox).addGap(29, 29, 29).addComponent(this.charCountCheckBox).addGap(18, 18, 18).addComponent(this.appendTextCheckBox, -2, 103, -2).addContainerGap(16, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineNumberCheckBox).addComponent(this.wordCountCheckBox).addComponent(this.charCountCheckBox).addComponent(this.appendTextCheckBox)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(309, 309, 309).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel1, -2, -1, -2))).addContainerGap(14, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void lineNumberCheckBoxActionPerformed(ActionEvent evt) {
        this.lineNumber = this.lineNumberCheckBox.isSelected();
    }

    private void charCountCheckBoxActionPerformed(ActionEvent evt) {
        this.countChar = this.charCountCheckBox.isSelected();
    }

    private void wordCountCheckBoxActionPerformed(ActionEvent evt) {
        this.countWord = this.wordCountCheckBox.isSelected();
    }

    private void appendTextCheckBoxActionPerformed(ActionEvent evt) {
        this.appendText = this.appendTextCheckBox.isSelected();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.mainWindow.performCounting(this.lineNumber, this.countWord, this.countChar, this.appendText);
    }
}

