/*
 * Decompiled with CFR 0.152.
 */
package turtleedit;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import turtleedit.TEMainWindow;

public class TEFilterDialog
extends JDialog {
    String regexString;
    int matchingType;
    boolean addLineNumber;
    boolean dotAllFlag;
    TEMainWindow mainWindow;
    private JButton OkButton;
    private JCheckBox addLineNumberCheckBox;
    private JButton cancelButton;
    private JCheckBox dotAllCheckBox;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JRadioButton matchedLine2RadioButton;
    private JRadioButton matchedLineRadioButton;
    private JRadioButton matchedStringRadioButton;
    private ButtonGroup outputButtonGroup;
    private JPanel outputPanel;
    private JTextArea regexTextArea;

    public TEFilterDialog(Frame parent, boolean modal) {
        super((Frame)null, modal);
        this.initComponents();
        this.mainWindow = (TEMainWindow)parent;
        this.setLocationRelativeTo(parent);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("images/tedit-icon.png"));
            this.setIconImage(img);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResizable(false);
        TEFilterDialog.installEscapeCloseOperation(this);
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "com.spodding.tackline.dispatch:WINDOW_CLOSING");
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing);
    }

    private void initComponents() {
        this.outputButtonGroup = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.regexTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.outputPanel = new JPanel();
        this.matchedStringRadioButton = new JRadioButton();
        this.matchedLineRadioButton = new JRadioButton();
        this.matchedLine2RadioButton = new JRadioButton();
        this.addLineNumberCheckBox = new JCheckBox();
        this.OkButton = new JButton();
        this.cancelButton = new JButton();
        this.dotAllCheckBox = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("turtleedit/TEBandle");
        this.setTitle(bundle.getString("FILTER"));
        this.setResizable(false);
        this.regexTextArea.setColumns(20);
        this.regexTextArea.setLineWrap(true);
        this.regexTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.regexTextArea);
        this.jLabel1.setText(bundle.getString("REGULAR EXPRESSION:"));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("OUTPUT")));
        this.outputButtonGroup.add(this.matchedStringRadioButton);
        this.matchedStringRadioButton.setSelected(true);
        this.matchedStringRadioButton.setText(bundle.getString("MATCHED STRING"));
        this.outputButtonGroup.add(this.matchedLineRadioButton);
        this.matchedLineRadioButton.setText(bundle.getString("MATCHED LINE"));
        this.outputButtonGroup.add(this.matchedLine2RadioButton);
        this.matchedLine2RadioButton.setText(bundle.getString("LINES CONTAINING PATTERN"));
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(1).add(outputPanelLayout.createSequentialGroup().addContainerGap().add(outputPanelLayout.createParallelGroup(1).add(outputPanelLayout.createSequentialGroup().add(outputPanelLayout.createParallelGroup(1).add(this.matchedStringRadioButton).add(this.matchedLineRadioButton)).addContainerGap(-1, Short.MAX_VALUE)).add(outputPanelLayout.createSequentialGroup().add(this.matchedLine2RadioButton).add(0, 13, Short.MAX_VALUE)))));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(1).add(outputPanelLayout.createSequentialGroup().add(this.matchedStringRadioButton).addPreferredGap(0).add(this.matchedLineRadioButton).addPreferredGap(0).add(this.matchedLine2RadioButton).addContainerGap(11, Short.MAX_VALUE)));
        this.addLineNumberCheckBox.setText(bundle.getString("LINE NUMBER"));
        this.OkButton.setText(bundle.getString("OK"));
        this.OkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEFilterDialog.this.OkButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TEFilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.dotAllCheckBox.setText(bundle.getString("DOT ALL"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.outputPanel, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.cancelButton, -2, 101, -2).addPreferredGap(0).add(this.OkButton, -1, 81, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.addLineNumberCheckBox).add(this.dotAllCheckBox)).add(0, 0, Short.MAX_VALUE))).add(0, 12, Short.MAX_VALUE)).add(this.jLabel1).add(this.jScrollPane1, -2, 403, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(13, 13, 13).add(this.jLabel1).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(17, 17, 17).add(this.addLineNumberCheckBox).addPreferredGap(0).add(this.dotAllCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.OkButton))).add(this.outputPanel, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.pack();
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.regexString = this.regexTextArea.getText();
        if (!this.isCorrectRegex(this.regexString)) {
            return;
        }
        this.matchingType = this.matchedStringRadioButton.isSelected() ? 0 : (this.matchedLineRadioButton.isSelected() ? 1 : (this.matchedLine2RadioButton.isSelected() ? 2 : -1));
        this.addLineNumber = this.addLineNumberCheckBox.isSelected();
        this.dotAllFlag = this.dotAllCheckBox.isSelected();
        this.mainWindow.performFiltering(this.regexString, this.matchingType, this.addLineNumber, this.dotAllFlag);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private boolean isCorrectRegex(String str) {
        if (str.length() == 0) {
            return false;
        }
        try {
            Pattern pattern = Pattern.compile(str);
        }
        catch (PatternSyntaxException e) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("turtleedit/TEBandle").getString("ERROR FOUND IN THE REGULAR EXPRESSION"), ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"), 2);
            return false;
        }
        return true;
    }
}

