/*
 * The MIT License
 *
 * Copyright 2013 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package turtleedit;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */
public class TEAboutDialog extends javax.swing.JDialog {

    /**
     * Creates new form TEAboutDialog
     */
    public TEAboutDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        
        String version = getClass().getPackage().getImplementationVersion() ;
//        if (version == null) {
//            try {
//                InputStream stream = getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
//                Manifest manifest = new Manifest(stream);
//
//                Attributes attributes = manifest.getMainAttributes();
//                version = attributes.getValue("Implementation-Version");
//
//            } catch (IOException e) {
//                ;
//            }
//        }
        installEscapeCloseOperation(this) ;
        builtDatejLabel.setText("build " + version) ;
    }
    
    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        mainTitleLabel = new javax.swing.JLabel();
        builtDatejLabel = new javax.swing.JLabel();
        copyrightLabel = new javax.swing.JLabel();
        turtleHeadLabel = new javax.swing.JLabel();
        uriButton = new javax.swing.JButton();
        subTitlejLabel1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("ABOUT TURTLEEDIT...")); // NOI18N

        okButton.setText(bundle.getString("OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        mainTitleLabel.setFont(new java.awt.Font("Lucida Grande", 1, 20)); // NOI18N
        mainTitleLabel.setText("TurtleEdit");

        builtDatejLabel.setText("Build 20140812");

        copyrightLabel.setText("Copyright (c) 2013-2018 Yoshinori Hayakawa. All Rights Reserved.");

        turtleHeadLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/turtleedit/images/turtle-head.png"))); // NOI18N

        uriButton.setForeground(new java.awt.Color(0, 0, 204));
        uriButton.setText("http://seaotter.cite.tohoku.ac.jp");
        uriButton.setBorder(null);
        uriButton.setBorderPainted(false);
        uriButton.setContentAreaFilled(false);
        uriButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        uriButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        uriButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                uriButtonActionPerformed(evt);
            }
        });

        subTitlejLabel1.setText(bundle.getString("A VERY SIMPLE TEXT EDITOR FOR PROGRAMMING PRIMERS")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(19, 19, 19)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(layout.createSequentialGroup()
                        .add(turtleHeadLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(layout.createSequentialGroup()
                                .add(mainTitleLabel)
                                .add(112, 112, 112)
                                .add(builtDatejLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 112, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(20, 20, 20))
                            .add(subTitlejLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(layout.createSequentialGroup()
                            .add(uriButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 216, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(okButton))
                        .add(copyrightLabel)))
                .add(0, 15, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(layout.createSequentialGroup()
                        .add(turtleHeadLabel)
                        .add(21, 21, 21))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(mainTitleLabel)
                            .add(builtDatejLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 24, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(13, 13, 13)
                        .add(subTitlejLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 24, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)))
                .add(copyrightLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(okButton)
                    .add(uriButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose() ; 
    }//GEN-LAST:event_okButtonActionPerformed

    private void uriButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_uriButtonActionPerformed
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("http://seaotter.cite.tohoku.ac.jp"));
            } catch (IOException e) { 
                ; 
            } catch (URISyntaxException ex) {
                ;
            }
        }  
    }//GEN-LAST:event_uriButtonActionPerformed

    /**
     * @param args the command line arguments
     */
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel builtDatejLabel;
    private javax.swing.JLabel copyrightLabel;
    private javax.swing.JLabel mainTitleLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel subTitlejLabel1;
    private javax.swing.JLabel turtleHeadLabel;
    private javax.swing.JButton uriButton;
    // End of variables declaration//GEN-END:variables
}
