package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */


public class TECountDialog extends javax.swing.JDialog {

    /**
     * Creates new form TECountDialog
     */
    
    TEMainWindow mainWindow ;
    boolean lineNumber ;
    boolean countWord ;
    boolean countChar ;
    boolean appendText ;
    public TECountDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        mainWindow = (TEMainWindow) parent ;
        lineNumber=countWord=countChar=appendText=false ;
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
        
        installEscapeCloseOperation(this) ;
        this.getRootPane().setDefaultButton(okButton);
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        lineNumberCheckBox = new javax.swing.JCheckBox();
        wordCountCheckBox = new javax.swing.JCheckBox();
        charCountCheckBox = new javax.swing.JCheckBox();
        appendTextCheckBox = new javax.swing.JCheckBox();

        setTitle("Count words and characters in each line");
        setResizable(false);
        setSize(new java.awt.Dimension(510, 170));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("OUTPUT RECORD"))); // NOI18N
        jPanel1.setSize(new java.awt.Dimension(480, 0));

        lineNumberCheckBox.setText(bundle.getString("LINE NUMBER")); // NOI18N
        lineNumberCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lineNumberCheckBoxActionPerformed(evt);
            }
        });

        wordCountCheckBox.setText(bundle.getString("WORD COUNT")); // NOI18N
        wordCountCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wordCountCheckBoxActionPerformed(evt);
            }
        });

        charCountCheckBox.setText(bundle.getString("CHARACTER COUNT")); // NOI18N
        charCountCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                charCountCheckBoxActionPerformed(evt);
            }
        });

        appendTextCheckBox.setText(bundle.getString("TEXT")); // NOI18N
        appendTextCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                appendTextCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(9, 9, 9)
                .addComponent(lineNumberCheckBox)
                .addGap(18, 18, 18)
                .addComponent(wordCountCheckBox)
                .addGap(29, 29, 29)
                .addComponent(charCountCheckBox)
                .addGap(18, 18, 18)
                .addComponent(appendTextCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 103, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(16, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lineNumberCheckBox)
                    .addComponent(wordCountCheckBox)
                    .addComponent(charCountCheckBox)
                    .addComponent(appendTextCheckBox))
                .addContainerGap(12, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(309, 309, 309)
                        .addComponent(cancelButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(okButton))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(14, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void lineNumberCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineNumberCheckBoxActionPerformed
        if (lineNumberCheckBox.isSelected()) lineNumber=true ;
        else lineNumber=false ;
    }//GEN-LAST:event_lineNumberCheckBoxActionPerformed

    private void charCountCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_charCountCheckBoxActionPerformed
        if (charCountCheckBox.isSelected()) countChar=true ;
        else countChar=false ;
    }//GEN-LAST:event_charCountCheckBoxActionPerformed

    private void wordCountCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wordCountCheckBoxActionPerformed
        if (wordCountCheckBox.isSelected()) countWord=true ;
        else countWord=false ;
    }//GEN-LAST:event_wordCountCheckBoxActionPerformed

    private void appendTextCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_appendTextCheckBoxActionPerformed
        if (appendTextCheckBox.isSelected()) appendText=true ;
        else appendText=false ;
    }//GEN-LAST:event_appendTextCheckBoxActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        mainWindow.performCounting(lineNumber, countWord, countChar, appendText) ;
    }//GEN-LAST:event_okButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox appendTextCheckBox;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox charCountCheckBox;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox lineNumberCheckBox;
    private javax.swing.JButton okButton;
    private javax.swing.JCheckBox wordCountCheckBox;
    // End of variables declaration//GEN-END:variables
}
