/*
 * The MIT License
 *
 * Copyright 2013 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package turtleedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */
public class TEDirListDialog extends javax.swing.JDialog {

    File targetFile ;
    /**
     * Creates new form TEDirListDialog
     */
    public TEDirListDialog(java.awt.Frame parent, boolean modal, File file) {
        super(parent, modal);
        initComponents();
        setResizable(false) ;
        setLocationRelativeTo(parent) ;
        targetFile = file ;
        
        fileListTable.setShowGrid(false);
        fileListTable.setIntercellSpacing(new Dimension(0,0));
        fileListTable.setFillsViewportHeight(true) ;
        
        JTableHeader tabHeader = fileListTable.getTableHeader();
        tabHeader.setFont( new Font(Font.SANS_SERIF, Font.BOLD, 12 ) );
        
        TableColumnModel tcm = fileListTable.getColumnModel();
        FileTableCellRenderer cellRenderer = new FileTableCellRenderer() ;
        tcm.getColumn(0).setCellRenderer(cellRenderer);
        tcm.getColumn(1).setCellRenderer(cellRenderer);
        
        this.generateFileTable();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        directoryNameTextArea = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        fileListTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("CONTENTS OF WORKING DIRECTORY")); // NOI18N
        setAlwaysOnTop(true);

        jLabel1.setText(bundle.getString("CURRENT DIRECTORY:")); // NOI18N

        directoryNameTextArea.setEditable(false);
        directoryNameTextArea.setColumns(20);
        directoryNameTextArea.setLineWrap(true);
        directoryNameTextArea.setRows(5);
        directoryNameTextArea.setWrapStyleWord(true);

        fileListTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Last modified"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        fileListTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setViewportView(fileListTable);
        fileListTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        fileListTable.getColumnModel().getColumn(1).setPreferredWidth(30);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(okButton)
                .add(37, 37, 37))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(okButton)
                .addContainerGap(13, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, directoryNameTextArea)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane2)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .add(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(directoryNameTextArea, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 35, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 276, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void generateFileTable() {
        directoryNameTextArea.setText(targetFile.getParent()) ;
        
        File dir = new File(targetFile.getParent()) ;
        File[] files = dir.listFiles() ;
        
        Arrays.sort(files, new fileNameComparator());
        
        DefaultListModel fileListModel = new DefaultListModel() ;
        SimpleDateFormat simple = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        for (int i=0 ; i<files.length ; i++) {         
            if (files[i].getName().charAt(0) != '.') {
                String filename,lastModified ;
                if (files[i].isDirectory()) {
                    filename = files[i].getName() + "/" ;
                    lastModified = "" ;
                } else {
                    filename = files[i].getName() ;
                    long lm = files[i].lastModified() ;    
                    lastModified = simple.format(new Date(lm));
                }
                
                ((DefaultTableModel) fileListTable.getModel()).insertRow(
                        0,
                        new Object[]{filename, lastModified} );
            }
        }
        fileListTable.setAutoCreateRowSorter(true);
    }
    
   
    
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose() ;
    }//GEN-LAST:event_okButtonActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea directoryNameTextArea;
    private javax.swing.JTable fileListTable;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables

    public class FileTableCellRenderer extends JTextArea implements TableCellRenderer {

        private Font font;
        // private Color bgColor ;

        public FileTableCellRenderer() {
            setLineWrap(true);
            setWrapStyleWord(true);
            setOpaque(true);
            font = new Font(Font.SANS_SERIF, Font.PLAIN, 12);
            // bgColor = new Color(240,240,255) ;
        }

        public Component getTableCellRendererComponent(
                JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
           
            // if (row%2==0) setBackground(bgColor);
            // else setBackground(Color.WHITE) ;
            
            if (value != null) {
                if (value.toString().equals(targetFile.getName())) 
                   setForeground(Color.RED);
                else 
                   setForeground(Color.BLACK) ;
                setText(value.toString());
            } else {
                setText("");
            }
            return this;
        }        
    }

    class fileNameComparator implements Comparator {
       public int compare(Object o1,Object o2){
            String fn1 = ((File) o1).getName();
            String fn2 = ((File) o2).getName();
            return fn2.compareTo(fn1);
        }
    }
}
