package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */


public class TEExecCommandDialog extends javax.swing.JDialog {
    
    private boolean plungePipe ;
    TEMainWindow mainWindow ;
    ArrayList<String> commandHistory ;
    KeyListener textFieldKeyListener ;
    int currentIndex=0 ;
    /**
     * Creates new form TEExecCommandDialog
     */
    public TEExecCommandDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        plungePipe = true ;
        mainWindow = (TEMainWindow) parent ;
        initComponents();
        setLocationRelativeTo(parent) ;
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
        
        commandHistory = new ArrayList<String>();
        
        textFieldKeyListener = new KeyListener() {
            public void keyPressed(KeyEvent ev) {
                int keyCode = ev.getKeyCode();
                if (commandHistory.size()<=0) return ;
                switch (keyCode) {
                    case KeyEvent.VK_DOWN:
                        currentIndex++ ;
                        if (currentIndex>commandHistory.size()-1) currentIndex=commandHistory.size()-1 ;
                        commandLineTextField.setText(commandHistory.get(currentIndex));
                        break;
                    case KeyEvent.VK_UP:
                        currentIndex-- ;
                        if (currentIndex<0) currentIndex=0 ;
                        commandLineTextField.setText(commandHistory.get(currentIndex));
                        break;
                    case KeyEvent.VK_LEFT:
                        break;
                    case KeyEvent.VK_RIGHT:
                        break;
                }
            }

            public void keyReleased(KeyEvent ev) {
                ;
            }

            public void keyTyped(KeyEvent ev) {
               ;
            }
        };
        commandLineTextField.addKeyListener(textFieldKeyListener);
        installEscapeCloseOperation(this) ;
        this.getRootPane().setDefaultButton(executeButton);
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        commandLineTextField = new javax.swing.JTextField();
        cancelButton = new javax.swing.JButton();
        executeButton = new javax.swing.JButton();
        plungeTextCheckBox = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("EXEC COMMAND")); // NOI18N
        setResizable(false);

        commandLineTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                commandLineTextFieldActionPerformed(evt);
            }
        });

        cancelButton.setText(bundle.getString("CANCEL")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        executeButton.setText(bundle.getString("EXECUTE")); // NOI18N
        executeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                executeButtonActionPerformed(evt);
            }
        });

        plungeTextCheckBox.setSelected(true);
        plungeTextCheckBox.setText(bundle.getString("PLUNGE TEXT")); // NOI18N
        plungeTextCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plungeTextCheckBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(layout.createSequentialGroup()
                        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(plungeTextCheckBox)
                        .add(102, 102, 102)
                        .add(cancelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(executeButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 99, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(19, 19, 19)
                        .add(commandLineTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 514, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(18, 18, 18)
                .add(commandLineTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(executeButton)
                    .add(plungeTextCheckBox))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void plungeTextCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plungeTextCheckBoxActionPerformed
        if (plungePipe) plungePipe = false ;
        else plungePipe = true ;
    }//GEN-LAST:event_plungeTextCheckBoxActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        mainWindow.killRunningProcess(true);
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void executeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_executeButtonActionPerformed
        String line = commandLineTextField.getText() ;
        if (line.length()>0) {
            mainWindow.execCommandLine(commandLineTextField.getText(), plungePipe) ;
            commandHistory.add(line) ;
            currentIndex = commandHistory.size()-1 ;
        }
    }//GEN-LAST:event_executeButtonActionPerformed

    private void commandLineTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commandLineTextFieldActionPerformed
        executeButtonActionPerformed(null) ;
    }//GEN-LAST:event_commandLineTextFieldActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextField commandLineTextField;
    private javax.swing.JButton executeButton;
    private javax.swing.JCheckBox plungeTextCheckBox;
    // End of variables declaration//GEN-END:variables
}
