/*
 * The MIT License
 *
 * Copyright 2013 hida.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */
public class TEFilterDialog extends javax.swing.JDialog {

    
    String regexString ;
    int matchingType ; /* 0: matched string,  1:matched ling, 3: lines containing matched pattern...  */
    boolean addLineNumber ;
    boolean dotAllFlag ;
    TEMainWindow mainWindow ;
    /**
     * Creates new form TEFilterDialog
     */
    public TEFilterDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        mainWindow = (TEMainWindow) parent ;
        setLocationRelativeTo(parent) ;
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
        
        setResizable(false) ;
        installEscapeCloseOperation(this) ;
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        outputButtonGroup = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        regexTextArea = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        outputPanel = new javax.swing.JPanel();
        matchedStringRadioButton = new javax.swing.JRadioButton();
        matchedLineRadioButton = new javax.swing.JRadioButton();
        matchedLine2RadioButton = new javax.swing.JRadioButton();
        addLineNumberCheckBox = new javax.swing.JCheckBox();
        OkButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        dotAllCheckBox = new javax.swing.JCheckBox();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("FILTER")); // NOI18N
        setResizable(false);

        regexTextArea.setColumns(20);
        regexTextArea.setLineWrap(true);
        regexTextArea.setRows(5);
        jScrollPane1.setViewportView(regexTextArea);

        jLabel1.setText(bundle.getString("REGULAR EXPRESSION:")); // NOI18N

        outputPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("OUTPUT"))); // NOI18N

        outputButtonGroup.add(matchedStringRadioButton);
        matchedStringRadioButton.setSelected(true);
        matchedStringRadioButton.setText(bundle.getString("MATCHED STRING")); // NOI18N

        outputButtonGroup.add(matchedLineRadioButton);
        matchedLineRadioButton.setText(bundle.getString("MATCHED LINE")); // NOI18N

        outputButtonGroup.add(matchedLine2RadioButton);
        matchedLine2RadioButton.setText(bundle.getString("LINES CONTAINING PATTERN")); // NOI18N

        org.jdesktop.layout.GroupLayout outputPanelLayout = new org.jdesktop.layout.GroupLayout(outputPanel);
        outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(
            outputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(outputPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(outputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(outputPanelLayout.createSequentialGroup()
                        .add(outputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(matchedStringRadioButton)
                            .add(matchedLineRadioButton))
                        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(outputPanelLayout.createSequentialGroup()
                        .add(matchedLine2RadioButton)
                        .add(0, 13, Short.MAX_VALUE))))
        );
        outputPanelLayout.setVerticalGroup(
            outputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(outputPanelLayout.createSequentialGroup()
                .add(matchedStringRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(matchedLineRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(matchedLine2RadioButton)
                .addContainerGap(11, Short.MAX_VALUE))
        );

        addLineNumberCheckBox.setText(bundle.getString("LINE NUMBER")); // NOI18N

        OkButton.setText(bundle.getString("OK")); // NOI18N
        OkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OkButtonActionPerformed(evt);
            }
        });

        cancelButton.setText(bundle.getString("CANCEL")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        dotAllCheckBox.setText(bundle.getString("DOT ALL")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(outputPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(cancelButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 101, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(OkButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(addLineNumberCheckBox)
                                    .add(dotAllCheckBox))
                                .add(0, 0, Short.MAX_VALUE)))
                        .add(0, 12, Short.MAX_VALUE))
                    .add(jLabel1)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 403, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(13, 13, 13)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(layout.createSequentialGroup()
                        .add(17, 17, 17)
                        .add(addLineNumberCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(dotAllCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(cancelButton)
                            .add(OkButton)))
                    .add(outputPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(16, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void OkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OkButtonActionPerformed
        regexString = regexTextArea.getText() ;
        
        if (!isCorrectRegex(regexString)) return ;
        
        if (matchedStringRadioButton.isSelected()) matchingType=0 ;
        else if (matchedLineRadioButton.isSelected()) matchingType=1 ;
        else if (matchedLine2RadioButton.isSelected()) matchingType=2 ;
        else matchingType = -1 ;
        
        if (addLineNumberCheckBox.isSelected()) addLineNumber = true ; 
        else addLineNumber = false ;
        
        if (dotAllCheckBox.isSelected()) dotAllFlag = true ;
        else dotAllFlag = false ;
        
        mainWindow.performFiltering(regexString, matchingType, addLineNumber, dotAllFlag) ;
    }//GEN-LAST:event_OkButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // dispose() ;
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private boolean isCorrectRegex(String str) {
        if (str.length()==0) return false ;
        try {
            Pattern p = Pattern.compile(str) ;
        } catch (PatternSyntaxException e) {
              JOptionPane.showMessageDialog(
                    this,
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("ERROR FOUND IN THE REGULAR EXPRESSION"),
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"),
                    JOptionPane.WARNING_MESSAGE);
            return false ;
        }
        return true ;
    }
    
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton OkButton;
    private javax.swing.JCheckBox addLineNumberCheckBox;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox dotAllCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JRadioButton matchedLine2RadioButton;
    private javax.swing.JRadioButton matchedLineRadioButton;
    private javax.swing.JRadioButton matchedStringRadioButton;
    private javax.swing.ButtonGroup outputButtonGroup;
    private javax.swing.JPanel outputPanel;
    private javax.swing.JTextArea regexTextArea;
    // End of variables declaration//GEN-END:variables
}
