package turtleedit;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import static java.lang.Thread.sleep;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.imageio.ImageIO;
import javax.swing.ButtonModel;
import javax.swing.JOptionPane;
import javax.swing.WindowConstants;
/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */


public class TEResponseDialog extends javax.swing.JDialog {

    private static final int MAXCHARS = 140 ;
    private static final int MAXERRMSG = 1024 ;
    private static final int PORT_BROADCAST = 3100 ;
    private static final int PORT_SUBMISSION = 3100 ;
    private static final int BROADCAST_MESSAGE_LENGTH = 1024 ;
    private static final int RSA_KEY_LENGTH = 512 ; 
    private static final int LISTENER_MAX_RETRY_COUNT = 30 ;
    private static final int LISTENER_TIMEOUT_MS = 1000 ;
    private final Object SERVER_ADDRESS_LOCK ;
    private InetAddress serverAddress ;
    private DatagramSocket listenerSocket=null;
    private ListenerThread listener ;
    private boolean terminatingListener=false ; 
    
    private int channelNumber ;
    
    private TEMainWindow mainWindow ;
    
    public RSAPublicKey publicKey ;
    /**
     * Creates new form TEFeedbackDialog
     */
    public TEResponseDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        mainWindow = (TEMainWindow) parent ;
        initComponents();
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        
        submitButton.setEnabled(false) ;
        
        SERVER_ADDRESS_LOCK = new Object() ;
        
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                closeButtonActionPerformed(null);
            }
        });
        serverAddress = null ;
        publicKey=null ;
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        numberButtonGroup = new javax.swing.ButtonGroup();
        channelButtonGroup = new javax.swing.ButtonGroup();
        submitButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        nicknameTextField = new javax.swing.JTextField();
        nicknameLabel = new javax.swing.JLabel();
        messageLabel = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRadioButton3 = new javax.swing.JRadioButton();
        jRadioButton4 = new javax.swing.JRadioButton();
        jRadioButton5 = new javax.swing.JRadioButton();
        jRadioButton6 = new javax.swing.JRadioButton();
        jRadioButton7 = new javax.swing.JRadioButton();
        jRadioButton8 = new javax.swing.JRadioButton();
        jRadioButton9 = new javax.swing.JRadioButton();
        jRadioButton10 = new javax.swing.JRadioButton();
        choiceLabel = new javax.swing.JLabel();
        passcodeLabel = new javax.swing.JLabel();
        messageTextArea = new javax.swing.JTextArea();
        passcodeTextField = new javax.swing.JTextField();
        channelLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        channelCRadioButton = new javax.swing.JRadioButton();
        channelBRadioButton = new javax.swing.JRadioButton();
        channelARadioButton = new javax.swing.JRadioButton();
        commentsTextArea = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        webButton = new javax.swing.JButton();
        attachCompileErrorCheckBox = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("FEEDBACK")); // NOI18N

        submitButton.setText(bundle.getString("SUBMIT")); // NOI18N
        submitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitButtonActionPerformed(evt);
            }
        });

        closeButton.setText(bundle.getString("CLOSE")); // NOI18N
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        nicknameTextField.setText("nickname");

        nicknameLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        nicknameLabel.setText(bundle.getString("NICKNAME")); // NOI18N

        messageLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        messageLabel.setText(bundle.getString("MESSAGE")); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        numberButtonGroup.add(jRadioButton1);
        jRadioButton1.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton1.setMnemonic('1');
        jRadioButton1.setText("1/YES");

        numberButtonGroup.add(jRadioButton2);
        jRadioButton2.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton2.setMnemonic('2');
        jRadioButton2.setText("2/NO");

        numberButtonGroup.add(jRadioButton3);
        jRadioButton3.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton3.setMnemonic('3');
        jRadioButton3.setText("3");

        numberButtonGroup.add(jRadioButton4);
        jRadioButton4.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton4.setMnemonic('4');
        jRadioButton4.setText("4");

        numberButtonGroup.add(jRadioButton5);
        jRadioButton5.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton5.setMnemonic('5');
        jRadioButton5.setText("5");

        numberButtonGroup.add(jRadioButton6);
        jRadioButton6.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton6.setMnemonic('6');
        jRadioButton6.setText("6");

        numberButtonGroup.add(jRadioButton7);
        jRadioButton7.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton7.setMnemonic('7');
        jRadioButton7.setText("7");

        numberButtonGroup.add(jRadioButton8);
        jRadioButton8.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton8.setMnemonic('8');
        jRadioButton8.setText("8");

        numberButtonGroup.add(jRadioButton9);
        jRadioButton9.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton9.setMnemonic('9');
        jRadioButton9.setText("9");

        numberButtonGroup.add(jRadioButton10);
        jRadioButton10.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        jRadioButton10.setMnemonic('0');
        jRadioButton10.setSelected(true);
        jRadioButton10.setText("0/?");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jRadioButton1)
                    .add(jRadioButton6))
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jRadioButton7))
                    .add(jPanel1Layout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jRadioButton2)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jRadioButton3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jRadioButton4))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jRadioButton8)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jRadioButton9)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jRadioButton10)
                    .add(jRadioButton5))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1Layout.linkSize(new java.awt.Component[] {jRadioButton1, jRadioButton10, jRadioButton2, jRadioButton3, jRadioButton4, jRadioButton5, jRadioButton6, jRadioButton7, jRadioButton8, jRadioButton9}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jRadioButton1)
                    .add(jRadioButton2)
                    .add(jRadioButton3)
                    .add(jRadioButton4)
                    .add(jRadioButton5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jRadioButton6)
                    .add(jRadioButton7)
                    .add(jRadioButton8)
                    .add(jRadioButton9)
                    .add(jRadioButton10))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        choiceLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        choiceLabel.setText(bundle.getString("CHOICE")); // NOI18N

        passcodeLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        passcodeLabel.setText(bundle.getString("PASSCODE")); // NOI18N

        messageTextArea.setColumns(20);
        messageTextArea.setLineWrap(true);
        messageTextArea.setRows(5);
        messageTextArea.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        passcodeTextField.setText("0000");

        channelLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        channelLabel.setText(bundle.getString("CHANNEL")); // NOI18N

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        channelButtonGroup.add(channelCRadioButton);
        channelCRadioButton.setText("C");
        channelCRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                channelCRadioButtonActionPerformed(evt);
            }
        });

        channelButtonGroup.add(channelBRadioButton);
        channelBRadioButton.setText("B");
        channelBRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                channelBRadioButtonActionPerformed(evt);
            }
        });

        channelButtonGroup.add(channelARadioButton);
        channelARadioButton.setSelected(true);
        channelARadioButton.setText("A");
        channelARadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                channelARadioButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .add(14, 14, 14)
                .add(channelARadioButton)
                .add(18, 18, 18)
                .add(channelBRadioButton)
                .add(20, 20, 20)
                .add(channelCRadioButton)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(channelCRadioButton)
                    .add(channelBRadioButton)
                    .add(channelARadioButton))
                .addContainerGap())
        );

        commentsTextArea.setEditable(false);
        commentsTextArea.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        commentsTextArea.setColumns(20);
        commentsTextArea.setLineWrap(true);
        commentsTextArea.setRows(5);
        commentsTextArea.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel1.setText(bundle.getString("INSTRUCTION")); // NOI18N

        webButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/turtleedit/images/globe.png"))); // NOI18N
        webButton.setBorder(null);
        webButton.setBorderPainted(false);
        webButton.setContentAreaFilled(false);
        webButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                webButtonActionPerformed(evt);
            }
        });

        attachCompileErrorCheckBox.setText(bundle.getString("ATTACH ERROR MESSAGE")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(channelLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE)
                    .add(nicknameLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(messageLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(choiceLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(webButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 56, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(layout.createSequentialGroup()
                                .add(1, 1, 1)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                    .add(layout.createSequentialGroup()
                                        .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .add(58, 58, 58)
                                        .add(passcodeLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(passcodeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 118, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                    .add(layout.createSequentialGroup()
                                        .add(closeButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 102, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(18, 18, 18)
                                        .add(submitButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 106, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, messageTextArea)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, commentsTextArea))))
                        .addContainerGap(18, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(nicknameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 142, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(attachCompileErrorCheckBox)
                        .add(35, 35, 35))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(29, 29, 29)
                        .add(channelLabel)
                        .add(5, 5, 5))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(layout.createSequentialGroup()
                                .add(6, 6, 6)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                    .add(passcodeLabel)
                                    .add(passcodeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(commentsTextArea, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(33, 33, 33)
                        .add(jLabel1)))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(nicknameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(nicknameLabel))
                    .add(attachCompileErrorCheckBox))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(11, 11, 11)
                        .add(messageTextArea, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 66, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(29, 29, 29)
                        .add(messageLabel)))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(36, 36, 36)
                        .add(choiceLabel)))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(webButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(closeButton)
                    .add(submitButton))
                .add(17, 17, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void submitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
        mainWindow.setNicknamePasscodeAndChannel(
                nicknameTextField.getText().trim(), 
                passcodeTextField.getText().trim(),
                channelNumber) ;
        submitFeedback() ;
    }//GEN-LAST:event_submitButtonActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        forceToTerminateListener() ;
        // dispose() ;
        setVisible(false) ;
    }//GEN-LAST:event_closeButtonActionPerformed

    private void channelARadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_channelARadioButtonActionPerformed
        channelNumber = 0 ;
        restartListener() ;
    }//GEN-LAST:event_channelARadioButtonActionPerformed

    private void channelBRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_channelBRadioButtonActionPerformed
        channelNumber = 1 ;
        restartListener() ;
    }//GEN-LAST:event_channelBRadioButtonActionPerformed

    private void channelCRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_channelCRadioButtonActionPerformed
        channelNumber = 2 ;
        restartListener() ;
    }//GEN-LAST:event_channelCRadioButtonActionPerformed

    private void webButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_webButtonActionPerformed
        if (serverAddress == null) {
            JOptionPane.showMessageDialog(
                    this,
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("CANNOT FIND SERVER"),
                    "WARNING",
                    JOptionPane.WARNING_MESSAGE);
            return;
        } else {
            String url = "http://" + serverAddress.getHostAddress() + ":3080/index.html";
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                } catch (IOException e) {
                    ;
                } catch (URISyntaxException ex) {
                    ;
                }
            }
        }
    }//GEN-LAST:event_webButtonActionPerformed

    public void startListener() {
        if (listener!=null || terminatingListener) return ;
        
        terminatingListener = false ;
        listener = new ListenerThread() ;
        listener.start() ;
         // wait a short time until listener is up
        try {
             sleep(50) ;
        } catch (InterruptedException ex) {
            ;
        }
    }
    
    private void restartListener() {
        submitButton.setEnabled(false);
        forceToTerminateListener() ;
        if (openListenerSocket()) {
            startListener() ;
            submitButton.setEnabled(true);
        }
    }
    
    private void forceToTerminateListener() {
        if (listener != null && listener.isAlive()) {
            terminatingListener = true;
            while (terminatingListener) {
                try {
                    sleep(500);
                } catch (InterruptedException ex) {
                    ;
                }
            }
        }
    }
     
    public void setNicknamePasscodeAndChannel(String nickname, String passcode, int channel) {
        nicknameTextField.setText(nickname) ;
        passcodeTextField.setText(passcode) ;
        channelNumber = channel ;
        switch (channel) {
            case 0: channelARadioButton.setSelected(true) ; break ;
            case 1: channelBRadioButton.setSelected(true) ; break ;
            case 2: channelCRadioButton.setSelected(true) ; break ;
            default: break ;
        }
    }
    
    public String selectedNumber() {
        ButtonModel model = numberButtonGroup.getSelection() ;
        return String.valueOf(model.getMnemonic() - '0') ;
    }
    
    
    public boolean submitFeedback() {
        
        BufferedReader reader;
        OutputStreamWriter writer;
        StringBuilder server_msg = new StringBuilder("");
        boolean gotResponse = false ;
        
        if (serverAddress==null) {
            JOptionPane.showMessageDialog(
                    this,
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("CANNOT FIND SERVER"),
                    "WARNING",
                    JOptionPane.WARNING_MESSAGE);
           return false ;
        }

        try {
            Socket socket ;
            synchronized (SERVER_ADDRESS_LOCK) {
                socket = new Socket(serverAddress, PORT_SUBMISSION + channelNumber);
                writer = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
                reader = new BufferedReader(
                        new InputStreamReader(socket.getInputStream(), "utf-8"));
            }            
            String passcode = passcodeTextField.getText().trim() ;
            if (passcode.length()>8) passcode = passcode.substring(0,8) ;
            writer.write("passcode=" + encryptShortMessage(passcode) + "\r\n") ;
 
            String nickname = nicknameTextField.getText().trim();
            if (nickname.length() > 16) {
                nickname = nickname.substring(0,16);
            }
              
            writer.write("nickname=" + nickname.replaceAll("[\t\r\n\"]", "") + "\r\n") ;
            
            writer.write("userid=" + encryptShortMessage(System.getProperty("user.name")) + "\r\n");

            String localHostName = "unknown";
            try {
                java.net.InetAddress localMachine = java.net.InetAddress.getLocalHost();
                localHostName = localMachine.getHostName();
            } catch (UnknownHostException ex) {;
            }
            writer.write("hostname=" + encryptShortMessage(localHostName) + "\r\n");

            writer.write("choice=" + selectedNumber() + "\r\n");
            
            String message = messageTextArea.getText().trim();
            message = message.replaceAll("\t", " ") ;
            message = message.replaceAll("[\r\n]", "<br>") ;
            if (message.length() > MAXCHARS) {
                message = message.substring(0,MAXCHARS-1);
            }
            writer.write("message=" + message + "\r\n");
            
            if (attachCompileErrorCheckBox.isSelected()) {
                String compileErrors = mainWindow.checkCompileError() ;
                // System.err.println(compileErrors);
                compileErrors = compileErrors.replaceAll("\t", " ") ;
                compileErrors = compileErrors.replaceAll("[\r\n]", "<br>") ;
                if (compileErrors.length() > MAXERRMSG) {
                    compileErrors = compileErrors.substring(0,MAXERRMSG-1);
                }
                writer.write("errmsg=" + compileErrors + "\r\n");
            }
            
            writer.write("\r\n");

            writer.flush();
            socket.shutdownOutput();
                        
            String line;
            while ((line = reader.readLine()) != null) {
                // System.out.println(line);
                server_msg.append(line);
                gotResponse = true ;
            }
        } catch (IOException ex) {
            // Logger.getLogger(TEResponseDialog.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(
                    this,
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("COMMUNICATION ERROR"),
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"),
                    JOptionPane.WARNING_MESSAGE);
            serverAddress=null ;
            return false;
        }

        if (!gotResponse) server_msg.append("COMMUNICATION ERROR");
        
        JOptionPane.showMessageDialog(
                this,
                server_msg.toString(),
                java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("INFORMATION"),
                JOptionPane.INFORMATION_MESSAGE);
        
        return true;
    }


    public void regeneratePublicKey(byte[] byteMod, byte[] byteExp) {
        BigInteger modules = new BigInteger(byteMod);
        BigInteger publicExponent = new BigInteger(byteExp);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modules, publicExponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        } catch (NoSuchAlgorithmException ex) {
            publicKey = null ;
        } catch (InvalidKeySpecException ex) {
            publicKey = null ;
        }
    }
    
    public String byte2hex(byte[] bytes) {
        if (bytes==null) return "" ;
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toHexString((b & 0xF0) >> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString() ;
    }
    
    
    public String encryptShortMessage(String str) {
        if (publicKey==null) return str ;
        byte[] data = str.getBytes();
        while (data.length > RSA_KEY_LENGTH/8-12) {
            str = str.substring(0,str.length()/2) ; // make it half
            data = str.getBytes();
        }
        byte[] encrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            encrypted = cipher.doFinal(data);
        } catch (NoSuchAlgorithmException e) {
            ;
        } catch (NoSuchPaddingException e) {
            ;
        } catch (BadPaddingException e) {
            ;
        } catch (InvalidKeyException ex) {
            ;
        } catch (IllegalBlockSizeException ex) {
            ;
        }
        return byte2hex(encrypted) ;
    }
    
    
    
   
  
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox attachCompileErrorCheckBox;
    private javax.swing.JRadioButton channelARadioButton;
    private javax.swing.JRadioButton channelBRadioButton;
    private javax.swing.ButtonGroup channelButtonGroup;
    private javax.swing.JRadioButton channelCRadioButton;
    private javax.swing.JLabel channelLabel;
    private javax.swing.JLabel choiceLabel;
    private javax.swing.JButton closeButton;
    private javax.swing.JTextArea commentsTextArea;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton10;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JRadioButton jRadioButton4;
    private javax.swing.JRadioButton jRadioButton5;
    private javax.swing.JRadioButton jRadioButton6;
    private javax.swing.JRadioButton jRadioButton7;
    private javax.swing.JRadioButton jRadioButton8;
    private javax.swing.JRadioButton jRadioButton9;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JTextArea messageTextArea;
    private javax.swing.JLabel nicknameLabel;
    private javax.swing.JTextField nicknameTextField;
    private javax.swing.ButtonGroup numberButtonGroup;
    private javax.swing.JLabel passcodeLabel;
    private javax.swing.JTextField passcodeTextField;
    private javax.swing.JButton submitButton;
    private javax.swing.JButton webButton;
    // End of variables declaration//GEN-END:variables

class ListenerThread extends Thread {

        public ListenerThread() {
        
        }

        @Override
        public void run() {
            byte[] receiveData = new byte[BROADCAST_MESSAGE_LENGTH];
            int retry_counter=0 ;
            for (;;) {
                if (terminatingListener) { // going to die
                    listenerSocket.close();
                    listener=null ;
                    terminatingListener=false ;
                    return ;
                }

                DatagramPacket receivePacket =
                        new DatagramPacket(receiveData, receiveData.length);

                try {
                    listenerSocket.setSoTimeout(LISTENER_TIMEOUT_MS);
                    listenerSocket.receive(receivePacket);
                } catch (UnsupportedEncodingException ex) {
                    continue ;
                } catch (IOException ex) {
                    retry_counter++ ;
                    if (serverAddress != null && retry_counter < LISTENER_MAX_RETRY_COUNT) {
                        continue ;
                    } else {
                        if (serverAddress != null) {
                            synchronized (SERVER_ADDRESS_LOCK) {
                                serverAddress = null;
                            }
                        }
                        publicKey = null;
                        submitButton.setEnabled(false) ;
                        continue ;
                    } 
                } 

                retry_counter = 0;

                synchronized (SERVER_ADDRESS_LOCK) {
                    if (serverAddress == null) {
                        serverAddress = receivePacket.getAddress();
                    } else {
                        InetAddress addr = receivePacket.getAddress();
                        if (!addr.equals(serverAddress)) { // server addr has changed..                       
                            serverAddress = addr;
                            publicKey = null;
                        }
                    }
                }
                
                try {
                    int k=0 ;
                    byte[] msg = new byte[(int)(receiveData[k] & 0xff)] ;
                    k++ ;
                    for (int i=0; i<msg.length && k<BROADCAST_MESSAGE_LENGTH ; i++, k++) {
                        msg[i] = receiveData[k] ;
                    }
                    commentsTextArea.setText(new String(msg,"UTF-8")) ;
                    
                    if (publicKey == null) {
                        byte[] byteMod = new byte[(int)(receiveData[k] & 0xff)];
                        k++;
                        for (int i = 0; i < byteMod.length && k<BROADCAST_MESSAGE_LENGTH ; i++, k++) {
                            byteMod[i] = receiveData[k];
                        }
                        // hexDump(byteMod) ;
                        byte[] byteExp = new byte[(int)(receiveData[k] & 0xff)];
                        k++;
                        for (int i = 0; i < byteExp.length && k<BROADCAST_MESSAGE_LENGTH ; i++, k++) {
                            byteExp[i] = receiveData[k];
                        }
                        // hexDump(byteExp) ;
                        regeneratePublicKey(byteMod, byteExp);
                    }
                    submitButton.setEnabled(true) ;
                } catch (UnsupportedEncodingException ex) { ; }
                                
                try {
                    sleep(1000) ;
                } catch (InterruptedException ex) {
                    terminatingListener = true ;
                }
            }
        }
    }

    public boolean openListenerSocket() {
        if (listener!=null) return true ; // listener of this instance is already running
        DatagramSocket socket ;
        try {
            socket = new DatagramSocket(PORT_BROADCAST + channelNumber);
        } catch (SocketException ex) {
            JOptionPane.showMessageDialog(
                    this,
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("PORT IS ALREADY IN USE"),
                    "WARNING",
                    JOptionPane.WARNING_MESSAGE);
            return false;
        }
        listenerSocket = socket ;
        return true;
    }
    
}
