/*
 * The MIT License
 *
 * Copyright 2013 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package turtleedit;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */
public class TESettingDialog extends javax.swing.JDialog {
    
    public class PresetSetting {
        String name ;
        String compileCommand ;
        String execCommand ;
        Boolean isInterpreter ;
        public PresetSetting(String nm, String ccmd, String ecmd, Boolean imode) {
            name = nm ;
            compileCommand = ccmd ;
            execCommand = ecmd ;
            isInterpreter = imode ;
        }
    }
    public ArrayList presets ;
    
    TEMainWindow mainWindow ;
    String charCode ;
    String preferredFontName ;
    int preferredFontSize ;
    
    public TESettingDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        mainWindow = (TEMainWindow) parent ; 
        initComponents();
        setDefaultCloseOperation(javax.swing.JDialog.DISPOSE_ON_CLOSE);
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        initPresets() ;
        setPresetsComboBox() ;
        initFontComboBox() ;
        
    }

    public void initPresets() {
         presets = new ArrayList() ;
         presets.add(new PresetSetting("---","","",false)) ;
         presets.add(new PresetSetting("C","cc %f -lm","./a.out",false)) ;
         presets.add(new PresetSetting("C++","c++ %f -lm","./a.out",false)) ;
         presets.add(new PresetSetting("Java","javac %f","java %b",false)) ;
         presets.add(new PresetSetting("Ruby","","ruby %f",true)) ;
         presets.add(new PresetSetting("Python","","python %f",true)) ;
         presets.add(new PresetSetting("LaTeX(DVI)","platex %f","pxdvi %b",false)) ;
         presets.add(new PresetSetting("LaTeX(PDF)","platex %f","bash -c dvipdfmx%s%b.dvi&&acroread%s%b.pdf",false)) ;
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        characterSetButtonGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        compileCommandTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        execCommandTextField = new javax.swing.JTextField();
        execPathTextField = new javax.swing.JTextField();
        settingsCancelButton = new javax.swing.JButton();
        settingsOKButton = new javax.swing.JButton();
        presetComboBox = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        sjisRadioButton = new javax.swing.JRadioButton();
        eucjpRadioButton = new javax.swing.JRadioButton();
        utf8RadioButton = new javax.swing.JRadioButton();
        fontPanel = new javax.swing.JPanel();
        fontComboBox = new javax.swing.JComboBox();
        fontSizeComboBox = new javax.swing.JComboBox();
        presetLabel = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        turtleFieldPathTextField = new javax.swing.JTextField();
        tfSearchButton = new javax.swing.JButton();
        tfAutoLaunchCheckBox = new javax.swing.JCheckBox();
        interpreterModeCheckBox = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        setTitle(bundle.getString("SETTING FOR COMPILATION AND EXECUTION")); // NOI18N
        setAlwaysOnTop(true);
        setPreferredSize(new java.awt.Dimension(680, 500));
        setResizable(false);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText(bundle.getString("COMPILE COMMAND")); // NOI18N

        compileCommandTextField.setText("gcc");

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText(bundle.getString("COMMAND FOR EXECUTION")); // NOI18N

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText(bundle.getString("ADDITIONAL EXEC PATH")); // NOI18N

        jLabel5.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel5.setText("%f :");

        jLabel6.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel6.setText(bundle.getString("FILE NAME")); // NOI18N

        jLabel7.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel7.setText("%b :");

        jLabel8.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel8.setText(bundle.getString("BASE NAME")); // NOI18N

        jLabel9.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel9.setText(" %d :");

        jLabel10.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel10.setText(bundle.getString("DIRECTORY")); // NOI18N

        execCommandTextField.setText("a.out");

        execPathTextField.setText("/opt/local/bin");

        settingsCancelButton.setText(bundle.getString("CANCEL")); // NOI18N
        settingsCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                settingsCancelButtonActionPerformed(evt);
            }
        });

        settingsOKButton.setText(bundle.getString("OK")); // NOI18N
        settingsOKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                settingsOKButtonActionPerformed(evt);
            }
        });

        presetComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                presetComboBoxActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, bundle.getString("CHARACTER CODE"), javax.swing.border.TitledBorder.LEFT, javax.swing.border.TitledBorder.DEFAULT_POSITION)); // NOI18N

        characterSetButtonGroup.add(sjisRadioButton);
        sjisRadioButton.setText("Shift_JIS");

        characterSetButtonGroup.add(eucjpRadioButton);
        eucjpRadioButton.setText("EUC-JP");

        characterSetButtonGroup.add(utf8RadioButton);
        utf8RadioButton.setSelected(true);
        utf8RadioButton.setText("UTF-8");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(utf8RadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(eucjpRadioButton)
                .add(18, 18, 18)
                .add(sjisRadioButton)
                .add(18, 18, 18))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(utf8RadioButton)
                    .add(eucjpRadioButton)
                    .add(sjisRadioButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        fontPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("PREFERRED FONT"))); // NOI18N

        fontComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontComboBoxActionPerformed(evt);
            }
        });

        fontSizeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "12", "14", "16", "18", "24" }));
        fontSizeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontSizeComboBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout fontPanelLayout = new org.jdesktop.layout.GroupLayout(fontPanel);
        fontPanel.setLayout(fontPanelLayout);
        fontPanelLayout.setHorizontalGroup(
            fontPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(fontPanelLayout.createSequentialGroup()
                .add(18, 18, 18)
                .add(fontComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 165, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(fontSizeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        fontPanelLayout.setVerticalGroup(
            fontPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(fontPanelLayout.createSequentialGroup()
                .add(fontPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(fontComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(fontSizeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(11, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(31, 31, 31)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 288, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(27, 27, 27)
                .add(fontPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(8, 8, 8))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(fontPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        presetLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        presetLabel.setText(bundle.getString("PRESET CONFIGURATIONS")); // NOI18N

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel11.setText(bundle.getString("PATH TO TURTLE FIELD")); // NOI18N

        turtleFieldPathTextField.setText("/opt/local/bin/tfield-linux");

        tfSearchButton.setText("...");
        tfSearchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfSearchButtonActionPerformed(evt);
            }
        });

        tfAutoLaunchCheckBox.setText(bundle.getString("AUTO LAUNCH")); // NOI18N

        interpreterModeCheckBox.setText(bundle.getString("INTERPRETER")); // NOI18N
        interpreterModeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                interpreterModeCheckBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(jLabel5)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 88, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel7)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 127, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel9)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 92, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(execCommandTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 459, Short.MAX_VALUE)
                                .add(compileCommandTextField))))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(layout.createSequentialGroup()
                            .add(424, 424, 424)
                            .add(settingsCancelButton)
                            .add(28, 28, 28)
                            .add(settingsOKButton))
                        .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(layout.createSequentialGroup()
                            .add(26, 26, 26)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel11, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .add(18, 18, 18)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(execPathTextField)
                                .add(layout.createSequentialGroup()
                                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(layout.createSequentialGroup()
                                            .add(112, 112, 112)
                                            .add(presetLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 135, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                            .add(37, 37, 37)
                                            .add(presetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 141, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                        .add(layout.createSequentialGroup()
                                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                                .add(tfAutoLaunchCheckBox)
                                                .add(turtleFieldPathTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 360, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                            .add(tfSearchButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 43, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                    .add(34, 34, 34))))))
                .addContainerGap(26, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(0, 0, Short.MAX_VALUE)
                .add(interpreterModeCheckBox)
                .add(49, 49, 49))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(18, 18, 18)
                .add(interpreterModeCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(compileCommandTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(execCommandTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(jLabel6)
                    .add(jLabel7)
                    .add(jLabel8)
                    .add(jLabel9)
                    .add(jLabel10))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(execPathTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(presetComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(presetLabel))
                .add(7, 7, 7)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel11)
                    .add(turtleFieldPathTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(tfSearchButton))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(26, 26, 26)
                        .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(tfAutoLaunchCheckBox)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(settingsCancelButton)
                    .add(settingsOKButton))
                .addContainerGap(17, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void settingsCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_settingsCancelButtonActionPerformed
        dispose() ;
    }//GEN-LAST:event_settingsCancelButtonActionPerformed

    private void settingsOKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_settingsOKButtonActionPerformed
        mainWindow.setInterpreterMode(interpreterModeCheckBox.isSelected()) ;
        mainWindow.setCompileCommand(compileCommandTextField.getText());
        mainWindow.setExecCommand(execCommandTextField.getText());
        mainWindow.setExecPath(execPathTextField.getText());
        mainWindow.setCharCode(selectedCharCode()) ;
        mainWindow.setPreferredFont(preferredFontName, preferredFontSize);
        mainWindow.setTurtleField(turtleFieldPathTextField.getText(), tfAutoLaunchCheckBox.isSelected());
        mainWindow.savePreferences();
        dispose() ;
    }//GEN-LAST:event_settingsOKButtonActionPerformed

    private void presetComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_presetComboBoxActionPerformed
        int index = presetComboBox.getSelectedIndex() ;
      
        if (index>0 && index<presets.size()) {
            PresetSetting p = (PresetSetting) presets.get(index) ;
            compileCommandTextField.setText(p.compileCommand) ;
            execCommandTextField.setText(p.execCommand) ;
            interpreterModeCheckBox.setSelected(p.isInterpreter) ;
            compileCommandTextField.setEnabled(!p.isInterpreter) ;
        }
    }//GEN-LAST:event_presetComboBoxActionPerformed

    private void fontComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontComboBoxActionPerformed
        preferredFontName = (String) fontComboBox.getSelectedItem() ;
    }//GEN-LAST:event_fontComboBoxActionPerformed

    private void tfSearchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfSearchButtonActionPerformed
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File tfFile = fileChooser.getSelectedFile();
            try {
                turtleFieldPathTextField.setText(tfFile.getCanonicalPath()) ;
            } catch (IOException ex) {
                ;
            }
        }
    }//GEN-LAST:event_tfSearchButtonActionPerformed

    private void fontSizeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontSizeComboBoxActionPerformed
       preferredFontSize = Integer.valueOf((String) fontSizeComboBox.getSelectedItem()) ;
    }//GEN-LAST:event_fontSizeComboBoxActionPerformed

    private void interpreterModeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interpreterModeCheckBoxActionPerformed
        if (interpreterModeCheckBox.isSelected()) {
            compileCommandTextField.setEnabled(false);
        } else {
            compileCommandTextField.setEnabled(true);
        }
    }//GEN-LAST:event_interpreterModeCheckBoxActionPerformed

    public void initFontComboBox() {
        // Font [] fonts=GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        String fonts[] = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        
        List<String> jaFontNames = new ArrayList() ;
        for (int i=0; i<fonts.length ; i++) {
            Font testFont = new Font(fonts[i],Font.PLAIN,14) ;
            if (testFont.canDisplay('あ')) {
                jaFontNames.add(fonts[i]);
            }
        }
        for (int i=0; i<jaFontNames.size() ; i++) {
            fontComboBox.addItem(jaFontNames.get(i)) ;
        }
    }
    
    public void setPreferredFontName(String s) {
        preferredFontName = s ;
        boolean found = false ;
        for (int i = 0 ; i < fontComboBox.getItemCount() ; i++) {
            if (fontComboBox.getItemAt(i).equals(s)) {
                fontComboBox.setSelectedIndex(i) ;
                return ;
            }
        }
        if (!found) {
            fontComboBox.insertItemAt(s,0) ;
            fontComboBox.setSelectedIndex(0) ;
        }
    }
    
    public void setPreferredFontSize(int size) {
        preferredFontSize = size ;
        boolean found = false ;
        for (int i = 0 ; i < fontSizeComboBox.getItemCount() ; i++) {
            if (Integer.valueOf((String)fontSizeComboBox.getItemAt(i)) == size) {
                fontSizeComboBox.setSelectedIndex(i) ;
                return ;
            }
        }
         if (!found) {
            fontSizeComboBox.setSelectedIndex(1) ;
        }
    }
    
    public void setCharCodeRadioButton(String code) {
        if (code.equalsIgnoreCase("UTF-8")) utf8RadioButton.setSelected(true);
        else if (code.equalsIgnoreCase("EUC_JP")) eucjpRadioButton.setSelected(true);
        else if (code.equalsIgnoreCase("Shift_JIS")) sjisRadioButton.setSelected(true);   
    }
    
    public String selectedCharCode() {
        if (utf8RadioButton.isSelected()) return "UTF-8" ;
        else if (eucjpRadioButton.isSelected()) return "EUC_JP" ;
        else if (sjisRadioButton.isSelected()) return "Shift_JIS" ;
        return "UTF-8" ;
    }
    
    public void setCompileCommandTextField(String s) {
        compileCommandTextField.setText(s);
    }
    
  
    public void setExecCommandTextField(String s) {
        execCommandTextField.setText(s) ;
    }
     
    public void setExecPathTextField(String s) {
        execPathTextField.setText(s);
    }
 
    
    public void setPresetsComboBox() {
        presetComboBox.removeAllItems() ;
        
        for (int i=0 ; i<presets.size() ; i++) {
            PresetSetting p = (PresetSetting) presets.get(i) ;
            presetComboBox.addItem(p.name) ;
        }
    }
    
    public void setTurtleFieldPathName(String path) {
        turtleFieldPathTextField.setText(path) ;
    }
    
    
    public void setTurtleFieldAutoLaunch(boolean mode) {
        tfAutoLaunchCheckBox.setSelected(mode) ;
    }
    
    public void setInterpreterMode(boolean mode) {
        interpreterModeCheckBox.setSelected(mode) ;
        compileCommandTextField.setEnabled(!mode);  
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup characterSetButtonGroup;
    private javax.swing.JTextField compileCommandTextField;
    private javax.swing.JRadioButton eucjpRadioButton;
    private javax.swing.JTextField execCommandTextField;
    private javax.swing.JTextField execPathTextField;
    private javax.swing.JComboBox fontComboBox;
    private javax.swing.JPanel fontPanel;
    private javax.swing.JComboBox fontSizeComboBox;
    private javax.swing.JCheckBox interpreterModeCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JComboBox presetComboBox;
    private javax.swing.JLabel presetLabel;
    private javax.swing.JButton settingsCancelButton;
    private javax.swing.JButton settingsOKButton;
    private javax.swing.JRadioButton sjisRadioButton;
    private javax.swing.JCheckBox tfAutoLaunchCheckBox;
    private javax.swing.JButton tfSearchButton;
    private javax.swing.JTextField turtleFieldPathTextField;
    private javax.swing.JRadioButton utf8RadioButton;
    // End of variables declaration//GEN-END:variables
}
