package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */

public class TESortDialog extends javax.swing.JDialog {

    /**
     * Creates new form TESortDialog
     */
    TEMainWindow mainWindow ;
    private boolean ignoreCase=false ;
    private boolean reverseOrder=false ;
    private boolean numericSort=false ;
    private int sortingKey=1 ;
    public TESortDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        mainWindow = (TEMainWindow) parent ;
        setLocationRelativeTo(parent) ;
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
        this.installEscapeCloseOperation(this) ;
        this.getRootPane().setDefaultButton(okButton);
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sortKeyButtonGroup = new javax.swing.ButtonGroup();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        sortingOptionsPanel = new javax.swing.JPanel();
        reverseOrderCheckBox = new javax.swing.JCheckBox();
        ignoreCaseCheckBox = new javax.swing.JCheckBox();
        numericCheckBox = new javax.swing.JCheckBox();
        sortingKeyPanel = new javax.swing.JPanel();
        key1RadioButton = new javax.swing.JRadioButton();
        key2RadioButton = new javax.swing.JRadioButton();
        key3RadioButton = new javax.swing.JRadioButton();
        key4RadioButton = new javax.swing.JRadioButton();
        key5RadioButton = new javax.swing.JRadioButton();
        key0RadioButton = new javax.swing.JRadioButton();

        setTitle("Sort lines");
        setResizable(false);
        setSize(new java.awt.Dimension(480, 250));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        sortingOptionsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("SORTING OPTIONS"))); // NOI18N
        sortingOptionsPanel.setToolTipText(bundle.getString("SORTING OPTION")); // NOI18N
        sortingOptionsPanel.setName("Sorting options"); // NOI18N

        reverseOrderCheckBox.setText(bundle.getString("REVERSE ORDER")); // NOI18N
        reverseOrderCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reverseOrderCheckBoxActionPerformed(evt);
            }
        });

        ignoreCaseCheckBox.setText(bundle.getString("IGNORE CASE")); // NOI18N
        ignoreCaseCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ignoreCaseCheckBoxActionPerformed(evt);
            }
        });

        numericCheckBox.setText(bundle.getString("NUMERIC SORT")); // NOI18N
        numericCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                numericCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout sortingOptionsPanelLayout = new javax.swing.GroupLayout(sortingOptionsPanel);
        sortingOptionsPanel.setLayout(sortingOptionsPanelLayout);
        sortingOptionsPanelLayout.setHorizontalGroup(
            sortingOptionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sortingOptionsPanelLayout.createSequentialGroup()
                .addGap(18, 18, 18)
                .addComponent(reverseOrderCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ignoreCaseCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 129, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(numericCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 128, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        sortingOptionsPanelLayout.setVerticalGroup(
            sortingOptionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sortingOptionsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(sortingOptionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(reverseOrderCheckBox)
                    .addComponent(ignoreCaseCheckBox)
                    .addComponent(numericCheckBox))
                .addContainerGap(17, Short.MAX_VALUE))
        );

        sortingKeyPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("SORT KEY"))); // NOI18N

        sortKeyButtonGroup.add(key1RadioButton);
        key1RadioButton.setMnemonic('1');
        key1RadioButton.setText("1");

        sortKeyButtonGroup.add(key2RadioButton);
        key2RadioButton.setMnemonic('2');
        key2RadioButton.setText("2");

        sortKeyButtonGroup.add(key3RadioButton);
        key3RadioButton.setMnemonic('3');
        key3RadioButton.setText("3");
        key3RadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                key3RadioButtonActionPerformed(evt);
            }
        });

        sortKeyButtonGroup.add(key4RadioButton);
        key4RadioButton.setMnemonic('4');
        key4RadioButton.setText("4");

        sortKeyButtonGroup.add(key5RadioButton);
        key5RadioButton.setMnemonic('5');
        key5RadioButton.setText("5");

        sortKeyButtonGroup.add(key0RadioButton);
        key0RadioButton.setMnemonic('0');
        key0RadioButton.setSelected(true);
        key0RadioButton.setText(bundle.getString("WHOLE LINE")); // NOI18N

        javax.swing.GroupLayout sortingKeyPanelLayout = new javax.swing.GroupLayout(sortingKeyPanel);
        sortingKeyPanel.setLayout(sortingKeyPanelLayout);
        sortingKeyPanelLayout.setHorizontalGroup(
            sortingKeyPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sortingKeyPanelLayout.createSequentialGroup()
                .addGap(22, 22, 22)
                .addComponent(key0RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(key1RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(key2RadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(key3RadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(key4RadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(key5RadioButton)
                .addGap(84, 84, 84))
        );

        sortingKeyPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {key1RadioButton, key2RadioButton, key3RadioButton, key4RadioButton, key5RadioButton});

        sortingKeyPanelLayout.setVerticalGroup(
            sortingKeyPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sortingKeyPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(sortingKeyPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(key1RadioButton)
                    .addComponent(key2RadioButton)
                    .addComponent(key3RadioButton)
                    .addComponent(key4RadioButton)
                    .addComponent(key5RadioButton)
                    .addComponent(key0RadioButton))
                .addContainerGap(20, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(sortingKeyPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 429, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(sortingOptionsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(0, 20, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(cancelButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(okButton)
                .addGap(32, 32, 32))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(17, 17, 17)
                .addComponent(sortingOptionsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(sortingKeyPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(12, 12, 12)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(okButton)
                    .addComponent(cancelButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void numericCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_numericCheckBoxActionPerformed
        if (numericSort) numericSort=false ;
        else numericSort=true ;
    }//GEN-LAST:event_numericCheckBoxActionPerformed

    private void ignoreCaseCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ignoreCaseCheckBoxActionPerformed
        if (ignoreCase) ignoreCase=false ;
        else ignoreCase=true ;
    }//GEN-LAST:event_ignoreCaseCheckBoxActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        performSorting() ;
    }//GEN-LAST:event_okButtonActionPerformed

    private void reverseOrderCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reverseOrderCheckBoxActionPerformed
        if (reverseOrder) reverseOrder=false ;
        else reverseOrder=true ;
    }//GEN-LAST:event_reverseOrderCheckBoxActionPerformed

    private void key3RadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_key3RadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_key3RadioButtonActionPerformed

    private void performSorting() {
        ButtonModel model = sortKeyButtonGroup.getSelection();
        sortingKey = model.getMnemonic() - '0';
        ((TEMainWindow) mainWindow).performSort(sortingKey, ignoreCase, reverseOrder, numericSort) ;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox ignoreCaseCheckBox;
    private javax.swing.JRadioButton key0RadioButton;
    private javax.swing.JRadioButton key1RadioButton;
    private javax.swing.JRadioButton key2RadioButton;
    private javax.swing.JRadioButton key3RadioButton;
    private javax.swing.JRadioButton key4RadioButton;
    private javax.swing.JRadioButton key5RadioButton;
    private javax.swing.JCheckBox numericCheckBox;
    private javax.swing.JButton okButton;
    private javax.swing.JCheckBox reverseOrderCheckBox;
    private javax.swing.ButtonGroup sortKeyButtonGroup;
    private javax.swing.JPanel sortingKeyPanel;
    private javax.swing.JPanel sortingOptionsPanel;
    // End of variables declaration//GEN-END:variables

    
}

