package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */

public class TETrDialog extends javax.swing.JDialog {

    /**
     * Creates new form TESortDialog
     */
    TEMainWindow mainWindow ;
    private boolean ignoreCase=false ;
    private boolean reverseOrder=false ;
    private boolean numericSort=false ;
    private int trFunction=1 ;
    public TETrDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        mainWindow = (TEMainWindow) parent ;
        setLocationRelativeTo(parent) ;       
        installEscapeCloseOperation(this) ;
        this.getRootPane().setDefaultButton(okButton);
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        functionButtonGroup = new javax.swing.ButtonGroup();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        functionPanel = new javax.swing.JPanel();
        toLowerCaseRadioButton = new javax.swing.JRadioButton();
        toUpperCaseRadioButton = new javax.swing.JRadioButton();
        zenkakuToHankakuRadioButton = new javax.swing.JRadioButton();
        hankakuToZenkakuRadioButton = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();

        setTitle("Translate characters");
        setResizable(false);
        setSize(new java.awt.Dimension(440, 230));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        functionPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("FUNCTION"))); // NOI18N

        functionButtonGroup.add(toLowerCaseRadioButton);
        toLowerCaseRadioButton.setMnemonic('1');
        toLowerCaseRadioButton.setSelected(true);
        toLowerCaseRadioButton.setText(bundle.getString("TO LOWER CASE")); // NOI18N

        functionButtonGroup.add(toUpperCaseRadioButton);
        toUpperCaseRadioButton.setMnemonic('2');
        toUpperCaseRadioButton.setText(bundle.getString("TO UPPER CASE")); // NOI18N

        functionButtonGroup.add(zenkakuToHankakuRadioButton);
        zenkakuToHankakuRadioButton.setMnemonic('3');
        zenkakuToHankakuRadioButton.setText(bundle.getString("ZENKAKU TO HANKAKU")); // NOI18N
        zenkakuToHankakuRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zenkakuToHankakuRadioButtonActionPerformed(evt);
            }
        });

        functionButtonGroup.add(hankakuToZenkakuRadioButton);
        hankakuToZenkakuRadioButton.setMnemonic('4');
        hankakuToZenkakuRadioButton.setText(bundle.getString("HANKAKU TO ZENKAKU")); // NOI18N
        hankakuToZenkakuRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hankakuToZenkakuRadioButtonActionPerformed(evt);
            }
        });

        jLabel1.setText(bundle.getString("ASCII CHARACTERS ONLY")); // NOI18N

        javax.swing.GroupLayout functionPanelLayout = new javax.swing.GroupLayout(functionPanel);
        functionPanel.setLayout(functionPanelLayout);
        functionPanelLayout.setHorizontalGroup(
            functionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(functionPanelLayout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addGroup(functionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(toUpperCaseRadioButton)
                    .addComponent(toLowerCaseRadioButton)
                    .addComponent(hankakuToZenkakuRadioButton)
                    .addComponent(zenkakuToHankakuRadioButton))
                .addGap(38, 38, 38)
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 166, Short.MAX_VALUE)
                .addContainerGap())
        );
        functionPanelLayout.setVerticalGroup(
            functionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(functionPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(toLowerCaseRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(toUpperCaseRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(zenkakuToHankakuRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(functionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hankakuToZenkakuRadioButton)
                    .addComponent(jLabel1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cancelButton)
                        .addGap(18, 18, 18)
                        .addComponent(okButton))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGap(23, 23, 23)
                        .addComponent(functionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(17, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(functionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap(22, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        performTranslation() ;
    }//GEN-LAST:event_okButtonActionPerformed

    private void zenkakuToHankakuRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zenkakuToHankakuRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_zenkakuToHankakuRadioButtonActionPerformed

    private void hankakuToZenkakuRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hankakuToZenkakuRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_hankakuToZenkakuRadioButtonActionPerformed

    private void performTranslation() {
        ButtonModel model = functionButtonGroup.getSelection();
        trFunction = model.getMnemonic() - '0';
        ((TEMainWindow) mainWindow).performTranslation(trFunction) ;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.ButtonGroup functionButtonGroup;
    private javax.swing.JPanel functionPanel;
    private javax.swing.JRadioButton hankakuToZenkakuRadioButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton okButton;
    private javax.swing.JRadioButton toLowerCaseRadioButton;
    private javax.swing.JRadioButton toUpperCaseRadioButton;
    private javax.swing.JRadioButton zenkakuToHankakuRadioButton;
    // End of variables declaration//GEN-END:variables

    
}

