package turtleedit;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 *
 * @author hida
 */


public class TEUniqDialog extends javax.swing.JDialog {

    TEMainWindow mainWindow ;
    boolean counting ;
    public TEUniqDialog(java.awt.Frame parent, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        mainWindow = (TEMainWindow) parent ;
        setLocationRelativeTo(parent) ;
        setResizable(false) ;
        installEscapeCloseOperation(this) ;
        this.getRootPane().setDefaultButton(okButton);
        
        Image img;
        try {
            img = ImageIO.read(getClass().getResource("images/tedit-icon.png"));
            setIconImage(img);
        } catch (IOException ex) { ; }
        
        counting=false ;
    }

    // this portion of code is from 
    // http://stackoverflow.com/questions/642925/swing-how-do-i-close-a-dialog-when-the-esc-key-is-pressed
    public static void installEscapeCloseOperation(final javax.swing.JDialog dialog) {
        Action dispatchClosing = new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(
                        dialog, WindowEvent.WINDOW_CLOSING
                ));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                "com.spodding.tackline.dispatch:WINDOW_CLOSING"
        );
        root.getActionMap().put("com.spodding.tackline.dispatch:WINDOW_CLOSING", dispatchClosing
        );
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        countingCheckBox = new javax.swing.JCheckBox();

        setTitle("Filter out repeated lines");
        setResizable(false);
        setSize(new java.awt.Dimension(480, 100));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("turtleedit/TEBandle"); // NOI18N
        countingCheckBox.setText(bundle.getString("COUNTING")); // NOI18N
        countingCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                countingCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(47, 47, 47)
                .addComponent(countingCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE)
                .addComponent(cancelButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(okButton)
                .addGap(29, 29, 29))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(countingCheckBox)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap(40, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false) ;
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        mainWindow.performUniq(counting);
    }//GEN-LAST:event_okButtonActionPerformed

    private void countingCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_countingCheckBoxActionPerformed
        if (!counting) counting=true ;
        else counting=false ;
    }//GEN-LAST:event_countingCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox countingCheckBox;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
}
