/*
 * The MIT License
 *
 * Copyright 2013 Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


package turtleedit;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

/**
 *
 * @author Yoshinori Hayakawa <hayakawa@cite.tohoku.ac.jp>
 */


public class TFLauncher {
    
    private String USER_AGENT = "TurtleEdit" ;
    private String turtleFieldPath ;
    
    private InputStreamThread readThr = null  ;
    private TEMainWindow mainWin ;
    
   
    TFLauncher(TEMainWindow parent) {
        turtleFieldPath=null ;
        mainWin = parent ;
    }
    
    public void launch() {
        /* TurtleField is listening http port 2280 for live mode */
        String URI = "http://localhost:2280/" ;
        if (isHttpPortAlive(URI)) return ;
        
        if (readThr!=null && readThr.isAlive()) {
            readThr.interrupt() ;
            try {
                Thread.sleep(10) ;
            } catch (InterruptedException ex) {
                    ;            
            }
        }
        
        String osname = System.getProperty("os.name");
        if(osname.indexOf("Mac")>=0) {
            execCommand("open "+turtleFieldPath);
        } else {
            execCommand(turtleFieldPath) ;
        }
        
        int cnt=0 ;
        while (!isHttpPortAlive(URI) && cnt < 10) {
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                ;
            }
            cnt++;
        }
    }
    
    
    public void setCommandPath(String pathname) {
        File tf = new File(pathname) ;
        if (tf.exists()) {       
            turtleFieldPath = pathname ;
        }
        else {
            JOptionPane.showMessageDialog(
                    mainWin,
                    "Path to TurtleFiled is incorrect",
                    java.util.ResourceBundle.getBundle("turtleedit/TEBandle").getString("WARNING"),
                    JOptionPane.WARNING_MESSAGE);
            turtleFieldPath="" ;
        }
    }
    
    public boolean isHttpPortAlive(String uriString) {
        URL url ;
        int response ;
        try {
            url = new URL(uriString) ;
            HttpURLConnection con = (HttpURLConnection) url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept-Language", "jp");
            con.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            con.connect();
            response = con.getResponseCode() ;
            BufferedInputStream is = new BufferedInputStream( con.getInputStream() );       
            int data;
            while ( (data = is.read()) != -1 ) { ; }
        } catch (MalformedURLException ex) {
            return false ;
        } catch (IOException ex) {
            return false ;
        }
        return true ;
        
    }
           
    public void execCommand(String command) {
        List<String> commandList = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(command, " ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            token = token.replaceAll("\\\\", "\\\\\\\\") ; // for Windows
            commandList.add(token);
        }
        ProcessBuilder pb = new ProcessBuilder(commandList);
        pb.redirectErrorStream(true);
        try {
            Process proc = pb.start();
            readThr = new InputStreamThread(proc.getInputStream());
            readThr.start() ;
        } catch (IOException ex) {
            ;
        }
    }
    
    public class InputStreamThread extends Thread {
        private BufferedReader br;
        public InputStreamThread(InputStream is) {
            br = new BufferedReader(new InputStreamReader(is));
        }
        @Override
        public void run() {
            String line ; 
            try {
                while ( (line = br.readLine()) != null ) { sleep(1) ; }
            } catch (IOException e) {
                ;
            } catch (InterruptedException ex) {
                ;
            }
            try {
                br.close();
            } catch (IOException ex) {
                ;
            }
        }
    }
}
