/* a simple interface to turtle field      */
/* for JOHO KISO                           */
/* Yoshinori Hayakawa (CITE, Tohoku Univ.) */
/* 08-JUN-2013 version                     */

#ifdef _WIN32
#pragma comment(linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"")
#pragma comment(lib,"ws2_32.lib")
#endif

#define EVENT_HIT_BY_BULLET   (0x00000001)
#define EVENT_RUN_INTO_TURTLE (0x00000002)
#define EVENT_RUN_INTO_DONUT  (0x00000004)
#define EVENT_RUN_INTO_STONE  (0x00000008)
#define EVENT_RUN_INTO_WALL   (0x00000010)
#define EVENT_FOUND_COIN      (0x00000020)
#define EVENT_DETECTED_BY_FINDER (0x00000040)
#define EVENT_DETECTED_BY_RADAR  (0x00000080)
#define EVENT_GOT_MESSAGE        (0x00000100)


#define DISCONNECT(x) DISCON(x)
extern void DISCON() ;
#define CONNECT(x) CON(x)
extern int CON(char *hostname) ;
extern void SET_HIT_BY_BULLET_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_TURTLE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_DONUT_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_STONE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_WALL_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_FOUND_COIN_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_DETECTED_BY_FINDER_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_DETECTED_BY_RADAR_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_GOT_MESSAGE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern int TTL_ENABLE_EVENT(unsigned int eventcode) ;
extern int TTL_DISABLE_EVENT(unsigned int eventcode) ;
extern int HOME() ;
extern int RST() ;
extern int CF() ;
extern int CLR() ;
extern int FD(float step) ;
extern int JUMP(float x, float y) ;
extern int RJUMP(float dx, float dy) ;
extern int BK(float step) ;
extern int RT(float angle) ;
extern int LT(float angle) ;
extern int EAST() ;
extern int WEST() ;
extern int NORTH() ;
extern int SOUTH() ;
extern int LW(float width) ;
extern int PD() ;
extern int PU() ;
extern int FILL() ;
extern int BRUSH() ;
extern int LINE() ;
extern int POINT() ;
extern int IDLE(float u) ;
extern int RF(float range) ;
extern int SAY(char *something) ;
extern int TPRINTF(const char* format, ...) ;
extern int TSCANF(const char* format, ...) ;
extern int FIRE() ;
extern int ROBOT() ;
#define DOUGHNUT(x) DONUT(x)
extern int DONUT() ;
extern int COIN() ;
extern int BORROWCOIN() ;
extern int DROPCOIN() ;
extern int PICKCOIN() ;
extern int COL(float r, float g, float b) ;
extern int BGC(float r, float g, float b) ;
extern int CARD(int c, float x, float y) ;
extern int CLRCARD() ;
extern int BMODE() ;
extern int GMODE() ;
extern int NM(char *s) ;
extern int TM(int team) ;
extern int BCAS(char *msg) ;
extern int Q_ID(int *myteam) ;
extern int Q_TM(int *team) ;
extern int Q_POS(float *x, float *y) ;
#define Q_HEADING(x) Q_DIR(x)
extern int Q_DIR(float *dir) ;
extern int Q_ALIVE(int *yn) ;
extern int Q_SCORE(int *score) ;
extern int Q_NT(int *nt) ;
extern int Q_COIN(int *nc) ;
extern int Q_MYCOIN(int *nmyc) ;
extern int Q_RADAR(float *dir) ;
extern int Q_RADAR_N(float *dir, int nn) ;
extern int Q_FINDER(int *yn) ;
extern int Q_SONAR(int *left, int *front, int *right) ; 
extern int Q_BCAS(int *etime, char *msg) ; 
extern int Q_TIME(int *tim) ; 
extern int Q_STAT_CARD(int c, int *stat) ;
extern int Q_POS_CARD(int c, float *x, float *y) ;

