/* a simple interface to turtle field      */
/* for JOHO KISO                           */
/* Yoshinori Hayakawa (CITE, Tohoku Univ.) */
/* 08-JUN-2013 version                     */

#ifdef _WIN32
#pragma comment(linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"")
#pragma comment(lib,"ws2_32.lib")
#endif

#define EVENT_HIT_BY_BULLET   (0x00000001)
#define EVENT_RUN_INTO_TURTLE (0x00000002)
#define EVENT_RUN_INTO_DONUT  (0x00000004)
#define EVENT_RUN_INTO_STONE  (0x00000008)
#define EVENT_RUN_INTO_WALL   (0x00000010)
#define EVENT_FOUND_COIN      (0x00000020)
#define EVENT_DETECTED_BY_FINDER (0x00000040)
#define EVENT_DETECTED_BY_RADER  (0x00000080)
#define EVENT_GOT_MESSAGE        (0x00000100)


#define DISCONNECT(x) DISCON(x)
extern void DISCON() ;
#define CONNECT(x) CON(x)
extern int CON(char *hostname) ;
extern void SET_HIT_BY_BULLET_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_TURTLE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_DONUT_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_STONE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_RUN_INTO_WALL_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_FOUND_COIN_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_DETECTED_BY_FINDER_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_DETECTED_BY_RADER_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void SET_GOT_MESSAGE_HANDLER(void (*callbackfunc)(unsigned int)) ;
extern void TTL_ENABLE_EVENT(unsigned int eventcode) ;
extern void TTL_DISABLE_EVENT(unsigned int eventcode) ;
extern void HOME() ;
extern void RST() ;
extern void CF() ;
extern void CLR() ;
extern void FD(float step) ;
extern void JUMP(float x, float y) ;
extern void BK(float step) ;
extern void RT(float angle) ;
extern void LT(float angle) ;
extern void EAST() ;
extern void WEST() ;
extern void NORTH() ;
extern void SOUTH() ;
extern void LW(float width) ;
extern void PD() ;
extern void PU() ;
extern void FILL() ;
extern void BRUSH() ;
extern void LINE() ;
extern void IDLE(float u) ;
extern void RF(float range) ;
extern void SAY(char *something) ;
extern void TPRINTF(const char* format, ...) ;
extern void TSCANF(const char* format, ...) ;
extern void FIRE() ;
extern void ROBOT() ;
#define DOUGHNUT(x) DONUT(x)
extern void DONUT() ;
extern void COIN() ;
extern void BORROWCOIN() ;
extern void DROPCOIN() ;
extern void PICKCOIN() ;
extern void COL(float r, float g, float b) ;
extern void BGC(float r, float g, float b) ;
extern void BMODE() ;
extern void GMODE() ;
extern void NM(char *s) ;
extern void TM(int team) ;
extern void BCAS(char *msg) ;
extern void Q_ID(int *myteam) ;
extern void Q_TM(int *team) ;
extern void Q_POS(float *x, float *y) ;
#define Q_HEADING(x) Q_DIR(x)
extern void Q_DIR(float *dir) ;
extern void Q_ALIVE(int *yn) ;
extern void Q_SCORE(int *score) ;
extern void Q_NT(int *nt) ;
extern void Q_COIN(int *nc) ;
extern void Q_MYCOIN(int *nmyc) ;
extern void Q_RADER(float *dir) ;
extern void Q_FINDER(int *yn) ;
extern void Q_SONAR(int *left, int *front, int *right) ; 
extern void Q_BCAS(int *etime, char *msg) ; 
extern void Q_TIME(int *tim) ; ;
extern void ttl_koch_curve(float length) ;
