/* a simple interface to turtle field      */
/* for JOHO KISO                           */
/* Yoshinori Hayakawa (CITE, Tohoku Univ.) */
/* 08-JUN-2013 version                     */

#ifdef _WIN32
#pragma comment(linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"")
#pragma comment(lib,"ws2_32.lib")
#endif

#define BUFFLEN 512
#define MAX_MSG 128
#define TSLEEP  2000
#define TTLPORT 2222

#define EVENT_HIT_BY_BULLET   (0x00000001)
#define EVENT_RUN_INTO_TURTLE (0x00000002)
#define EVENT_RUN_INTO_DONUT  (0x00000004)
#define EVENT_RUN_INTO_STONE  (0x00000008)
#define EVENT_RUN_INTO_WALL   (0x00000010)
#define EVENT_FOUND_COIN      (0x00000020)
#define EVENT_DETECTED_BY_FINDER (0x00000040)
#define EVENT_DETECTED_BY_RADER  (0x00000080)
#define EVENT_GOT_MESSAGE        (0x00000100)

struct t_position {
  float x ;
  float y ;
} ;

struct t_sonar {
  bool left ;
  bool front ;
  bool right ;
} ;

class Turtle {
 private:
  char ttl_buf_[BUFFLEN] ;
  char ttl_ack_[BUFFLEN] ;
  int socket_ ;
  int team_ ;
  int send_ttl_buf_and_receive_ack(void) ;
  void check_event(int eventcode, int timecode) ;
  void ttl_send_command_(const char *cmd) ;
  void ttl_send_packet(char *msg) ;
  void ttl_convert_str2hex(char *str, char *hex) ;
  int  ttl_char2int(char c) ;
  void ttl_convert_hex2str(char *hex, char *str) ;
  float threshold_length_ ;
  float prev_angle_ ;
  void koch_curve_(float length, float angle) ;
 public:
  Turtle(const char *hostname) ;  
  ~Turtle(void) ;  
  int con(const char *hostname) ;
  void discon() ;
  void hit_by_bullet(int timecode) ;
  void run_into_turtle(int timecode) ;
  void run_into_donut(int timecode) ;
  void run_into_stone(int timecode) ;
  void run_into_wall(int timecode) ;
  void found_coin(int timecode) ;
  void detected_by_finder(int timecode) ;
  void detected_by_rader(int timecode) ;
  void got_message(int timecode) ;
  void enable_event(unsigned int eventcode) ;
  void disable_event(unsigned int eventcode) ;
  void home() ;
  void rst() ;
  void cf() ;
  void clr() ;
  void fd(float step) ;
  void jump(float x, float y) ;
  void bk(float step) ;
  void rt(float angle) ;
  void lt(float angle) ;
  void east() ;
  void west() ;
  void north() ;
  void south() ;
  void lw(float width) ;
  void pd() ;
  void pu() ;
  void fill() ;
  void brush() ;
  void line() ;
  void idle(float u) ;
  void rf(float range) ;
  void say(char *something) ;
  void say(const char *something) ;
  void bcas(const char *msg) ;
  void bcas(char *msg) ;
  void tprintf(const char* format, ...) ;
  void tscanf(const char* format, ...) ;
  void fire() ;
  void robot() ;
#define donut(x) doughnut(x)
  void doughnut() ;
  void dropcoin() ;
  void pickcoin() ;
  void col(float r, float g, float b) ;
  void bgc(float r, float g, float b) ;
  void bmode() ;
  void gmode() ;
  void nm(char *s) ;
  void tm(int team) ;
  int q_id(void) ;
  int q_tm(void) ;
  struct t_position q_pos(void) ;
#define q_heading(x) q_dir(x)
  float q_dir(void) ;
  bool q_alive(void) ;
  int  q_score(void) ;
  int  q_nt(void) ;
  int  q_coin(void) ;
  float q_rader(void) ;
  int  q_finder(void) ;
  struct t_sonar q_sonar(void) ;
  int  q_bcas(char *msg) ;
  int  q_time(void) ;
  void ttl_koch_curve(float length) ;
} ;
